/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.part;

import appeng.api.parts.IPart;
import appeng.core.localization.InGameTooltip;
import appeng.integration.modules.waila.part.IPartDataProvider;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.util.Platform;
import mcp.mobius.waila.api.ITooltip;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;

public final class P2PStateDataProvider
implements IPartDataProvider {
    private static final byte STATE_UNLINKED = 0;
    private static final byte STATE_OUTPUT = 1;
    private static final byte STATE_INPUT = 2;
    public static final String TAG_P2P_STATE = "p2pState";
    public static final String TAG_P2P_OUTPUTS = "p2pOutputs";
    public static final String TAG_P2P_FREQUENCY = "p2pFrequency";

    @Override
    public void appendBodyTooltip(IPart part, CompoundTag partTag, ITooltip tooltip) {
        if (partTag.m_128425_(TAG_P2P_STATE, 1)) {
            byte state = partTag.m_128445_(TAG_P2P_STATE);
            int outputs = partTag.m_128451_(TAG_P2P_OUTPUTS);
            switch (state) {
                case 0: {
                    tooltip.add((Component)InGameTooltip.P2PUnlinked.text());
                    break;
                }
                case 1: {
                    tooltip.add((Component)InGameTooltip.P2POutput.text());
                    break;
                }
                case 2: {
                    tooltip.add(P2PStateDataProvider.getOutputText(outputs));
                }
            }
            short freq = partTag.m_128448_(TAG_P2P_FREQUENCY);
            String freqTooltip = Platform.p2p().toHexString(freq);
            tooltip.add((Component)new TranslatableComponent("gui.tooltips.ae2.P2PFrequency", new Object[]{freqTooltip}));
        }
    }

    @Override
    public void appendServerData(ServerPlayer player, IPart part, CompoundTag partTag) {
        if (part instanceof P2PTunnelPart) {
            P2PTunnelPart p2pTunnel = (P2PTunnelPart)part;
            if (!p2pTunnel.isPowered()) {
                return;
            }
            partTag.m_128376_(TAG_P2P_FREQUENCY, p2pTunnel.getFrequency());
            int state = 0;
            if (!p2pTunnel.isOutput()) {
                int outputCount = p2pTunnel.getOutputs().size();
                if (outputCount > 0) {
                    state = 2;
                    partTag.m_128405_(TAG_P2P_OUTPUTS, outputCount);
                }
            } else if (p2pTunnel.getInput() != null) {
                state = 1;
            }
            partTag.m_128344_(TAG_P2P_STATE, (byte)state);
        }
    }

    private static Component getOutputText(int outputs) {
        if (outputs <= 1) {
            return InGameTooltip.P2PInputOneOutput.text();
        }
        return InGameTooltip.P2PInputManyOutputs.text(outputs);
    }
}

