/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.config.CondenserOutput;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.config.YesNo;
import appeng.api.features.AEWorldGenInternal;
import appeng.api.networking.pathing.ChannelMode;
import appeng.core.AELog;
import appeng.core.config.BooleanOption;
import appeng.core.config.ConfigFileManager;
import appeng.core.config.ConfigSection;
import appeng.core.config.ConfigValidationException;
import appeng.core.config.DoubleOption;
import appeng.core.config.EnumOption;
import appeng.core.config.IntegerOption;
import appeng.core.config.StringListOption;
import appeng.core.config.StringOption;
import appeng.core.settings.TickRates;
import appeng.util.EnumCycler;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;

public final class AEConfig {
    public static final String CLIENT_CONFIG_PATH = "appliedenergistics2/client.json";
    public static final String COMMON_CONFIG_PATH = "appliedenergistics2/common.json";
    public final ClientConfig CLIENT;
    public final ConfigFileManager clientConfigManager;
    public final CommonConfig COMMON;
    public final ConfigFileManager commonConfigManager;
    private static final double DEFAULT_FE_EXCHANGE = 0.5;
    private static AEConfig instance;
    private int formationPlaneEntityLimit;
    private boolean enableEffects;
    private boolean useLargeFonts;
    private boolean useColoredCraftingStatus;
    private boolean disableColoredCableRecipesInJEI;
    private boolean isEnableFacadesInJEI;
    private int craftingCalculationTimePerTick;
    private boolean craftingSimulatedExtraction;
    private double spatialPowerExponent;
    private double spatialPowerMultiplier;
    private int wirelessTerminalBattery;
    private int entropyManipulatorBattery;
    private int matterCannonBattery;
    private int portableCellBattery;
    private int colorApplicatorBattery;
    private int chargedStaffBattery;
    private double wirelessBaseCost;
    private double wirelessCostMultiplier;
    private double wirelessTerminalDrainMultiplier;
    private double wirelessBaseRange;
    private double wirelessBoosterRangeMultiplier;
    private double wirelessBoosterExp;
    private double wirelessHighWirelessCount;
    public static final double TUNNEL_POWER_LOSS = 0.05;
    @Nullable
    private TagKey<Fluid> improvedFluidTagKey;

    AEConfig(Path configDir) {
        ConfigSection clientRoot = ConfigSection.createRoot();
        this.CLIENT = new ClientConfig(clientRoot);
        this.clientConfigManager = configDir != null ? AEConfig.createConfigFileManager(clientRoot, configDir, CLIENT_CONFIG_PATH) : null;
        ConfigSection commonRoot = ConfigSection.createRoot();
        this.COMMON = new CommonConfig(commonRoot);
        this.commonConfigManager = configDir != null ? AEConfig.createConfigFileManager(commonRoot, configDir, COMMON_CONFIG_PATH) : null;
        this.syncClientConfig();
        this.syncCommonConfig();
    }

    private static ConfigFileManager createConfigFileManager(ConfigSection commonRoot, Path configDir, String filename) {
        Path configFile = configDir.resolve(filename);
        ConfigFileManager result = new ConfigFileManager(commonRoot, configFile);
        if (!Files.exists(configFile, new LinkOption[0])) {
            result.save();
        } else {
            try {
                result.load();
            }
            catch (ConfigValidationException e) {
                AELog.error("Failed to load AE2 Config. Making backup", e);
                AEConfig.makeBackupAndReset(configDir, filename);
            }
            try {
                result.save();
            }
            catch (Exception e) {
                AELog.warn(e);
            }
        }
        return result;
    }

    public static void load(Path configFolder) {
        if (instance != null) {
            throw new IllegalStateException("Config is already loaded");
        }
        instance = new AEConfig(configFolder);
    }

    private static void makeBackupAndReset(Path configFolder, String configFile) {
        Path backupFile = configFolder.resolve(configFile + ".bak");
        Path originalFile = configFolder.resolve(configFile);
        try {
            Files.move(originalFile, backupFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            AELog.warn("Failed to backup config file %s: %s!", originalFile, e);
        }
    }

    private void syncClientConfig() {
        this.disableColoredCableRecipesInJEI = this.CLIENT.disableColoredCableRecipesInJEI.get();
        this.isEnableFacadesInJEI = this.CLIENT.enableFacadesInJEI.get();
        this.enableEffects = this.CLIENT.enableEffects.get();
        this.useLargeFonts = this.CLIENT.useLargeFonts.get();
        this.useColoredCraftingStatus = this.CLIENT.useColoredCraftingStatus.get();
    }

    private void syncCommonConfig() {
        PowerUnits.RF.conversionRatio = this.COMMON.powerRatioForgeEnergy.get();
        PowerMultiplier.CONFIG.multiplier = this.COMMON.powerUsageMultiplier.get();
        CondenserOutput.MATTER_BALLS.requiredPower = this.COMMON.condenserMatterBallsPower.get();
        CondenserOutput.SINGULARITY.requiredPower = this.COMMON.condenserSingularityPower.get();
        this.wirelessBaseCost = this.COMMON.wirelessBaseCost.get();
        this.wirelessCostMultiplier = this.COMMON.wirelessCostMultiplier.get();
        this.wirelessBaseRange = this.COMMON.wirelessBaseRange.get();
        this.wirelessBoosterRangeMultiplier = this.COMMON.wirelessBoosterRangeMultiplier.get();
        this.wirelessBoosterExp = this.COMMON.wirelessBoosterExp.get();
        this.wirelessHighWirelessCount = this.COMMON.wirelessHighWirelessCount.get();
        this.wirelessTerminalDrainMultiplier = this.COMMON.wirelessTerminalDrainMultiplier.get();
        this.formationPlaneEntityLimit = this.COMMON.formationPlaneEntityLimit.get();
        this.wirelessTerminalBattery = this.COMMON.wirelessTerminalBattery.get();
        this.chargedStaffBattery = this.COMMON.chargedStaffBattery.get();
        this.entropyManipulatorBattery = this.COMMON.entropyManipulatorBattery.get();
        this.portableCellBattery = this.COMMON.portableCellBattery.get();
        this.colorApplicatorBattery = this.COMMON.colorApplicatorBattery.get();
        this.matterCannonBattery = this.COMMON.matterCannonBattery.get();
        for (TickRates tr : TickRates.values()) {
            tr.setMin(this.COMMON.tickRateMin.get((Object)tr).get());
            tr.setMax(this.COMMON.tickRateMax.get((Object)tr).get());
        }
        this.spatialPowerMultiplier = this.COMMON.spatialPowerMultiplier.get();
        this.spatialPowerExponent = this.COMMON.spatialPowerExponent.get();
        this.craftingCalculationTimePerTick = this.COMMON.craftingCalculationTimePerTick.get();
        this.craftingSimulatedExtraction = this.COMMON.craftingSimulatedExtraction.get();
        AEWorldGenInternal.setConfigBlacklists(this.COMMON.quartzOresBiomeBlacklist.get().stream().map(ResourceLocation::new).collect(Collectors.toList()));
        AELog.setCraftingLogEnabled(this.COMMON.craftingLog.get());
        AELog.setDebugLogEnabled(this.COMMON.debugLog.get());
        AELog.setGridLogEnabled(this.COMMON.gridLog.get());
    }

    public static AEConfig instance() {
        return instance;
    }

    public double wireless_getDrainRate(double range) {
        return this.wirelessTerminalDrainMultiplier * range;
    }

    public double wireless_getMaxRange(int boosters) {
        return this.wirelessBaseRange + this.wirelessBoosterRangeMultiplier * Math.pow(boosters, this.wirelessBoosterExp);
    }

    public double wireless_getPowerDrain(int boosters) {
        return this.wirelessBaseCost + this.wirelessCostMultiplier * Math.pow(boosters, 1.0 + (double)boosters / this.wirelessHighWirelessCount);
    }

    public YesNo getSearchTooltips() {
        return this.CLIENT.searchTooltips.get();
    }

    public TerminalStyle getTerminalStyle() {
        return this.CLIENT.terminalStyle.get();
    }

    public void setTerminalStyle(TerminalStyle setting) {
        this.CLIENT.terminalStyle.set(setting);
    }

    public SearchBoxMode getTerminalSearchMode() {
        return this.CLIENT.terminalSearchMode.get();
    }

    public void setTerminalSearchMode(SearchBoxMode setting) {
        this.CLIENT.terminalSearchMode.set(setting);
    }

    public void save() {
    }

    public PowerUnits getSelectedPowerUnit() {
        return this.CLIENT.selectedPowerUnit.get();
    }

    public void nextPowerUnit(boolean backwards) {
        PowerUnits selectedPowerUnit = EnumCycler.rotateEnum(this.getSelectedPowerUnit(), backwards, Settings.POWER_UNITS.getValues());
        this.CLIENT.selectedPowerUnit.set(selectedPowerUnit);
    }

    public boolean isBlockEntityFacadesEnabled() {
        return this.COMMON.allowBlockEntityFacades.get();
    }

    public boolean isDebugToolsEnabled() {
        return this.COMMON.debugTools.get();
    }

    public int getFormationPlaneEntityLimit() {
        return this.formationPlaneEntityLimit;
    }

    public boolean isEnableEffects() {
        return this.enableEffects;
    }

    public boolean isUseLargeFonts() {
        return this.useLargeFonts;
    }

    public boolean isUseColoredCraftingStatus() {
        return this.useColoredCraftingStatus;
    }

    public boolean isDisableColoredCableRecipesInJEI() {
        return this.disableColoredCableRecipesInJEI;
    }

    public boolean isEnableFacadesInJEI() {
        return this.isEnableFacadesInJEI;
    }

    public int getCraftingCalculationTimePerTick() {
        return this.craftingCalculationTimePerTick;
    }

    public boolean isCraftingSimulatedExtraction() {
        return this.craftingSimulatedExtraction;
    }

    public double getSpatialPowerExponent() {
        return this.spatialPowerExponent;
    }

    public double getSpatialPowerMultiplier() {
        return this.spatialPowerMultiplier;
    }

    public double getChargerChargeRate() {
        return this.COMMON.chargerChargeRate.get();
    }

    public DoubleSupplier getWirelessTerminalBattery() {
        return () -> this.wirelessTerminalBattery;
    }

    public DoubleSupplier getEntropyManipulatorBattery() {
        return () -> this.entropyManipulatorBattery;
    }

    public DoubleSupplier getMatterCannonBattery() {
        return () -> this.matterCannonBattery;
    }

    public DoubleSupplier getPortableCellBattery() {
        return () -> this.portableCellBattery;
    }

    public DoubleSupplier getColorApplicatorBattery() {
        return () -> this.colorApplicatorBattery;
    }

    public DoubleSupplier getChargedStaffBattery() {
        return () -> this.chargedStaffBattery;
    }

    public int getQuartzOresPerCluster() {
        return this.COMMON.quartzOresPerCluster.get();
    }

    public int getQuartzOresClusterAmount() {
        return this.COMMON.quartzOresClusterAmount.get();
    }

    @Nullable
    public TagKey<Fluid> getImprovedFluidTag() {
        String tagName;
        if (this.improvedFluidTagKey == null && (tagName = Strings.emptyToNull((String)this.COMMON.improvedFluidTag.get())) != null) {
            this.improvedFluidTagKey = TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)new ResourceLocation(tagName));
        }
        return this.improvedFluidTagKey;
    }

    public float getImprovedFluidMultiplier() {
        return (float)this.COMMON.improvedFluidMultiplier.get();
    }

    public boolean isShowDebugGuiOverlays() {
        return this.CLIENT.debugGuiOverlays.get();
    }

    public boolean isSpawnPressesInMeteoritesEnabled() {
        return this.COMMON.spawnPressesInMeteorites.get();
    }

    public boolean isGenerateQuartzOre() {
        return this.COMMON.generateQuartzOre.get();
    }

    public boolean isGenerateMeteorites() {
        return this.COMMON.generateMeteorites.get();
    }

    public boolean isMatterCanonBlockDamageEnabled() {
        return this.COMMON.matterCannonBlockDamage.get();
    }

    public boolean isTinyTntBlockDamageEnabled() {
        return this.COMMON.tinyTntBlockDamage.get();
    }

    public boolean isInWorldSingularityEnabled() {
        return this.COMMON.inWorldSingularity.get();
    }

    public boolean isInWorldFluixEnabled() {
        return this.COMMON.inWorldFluix.get();
    }

    public boolean isInWorldCrystalGrowthEnabled() {
        return this.COMMON.inWorldCrystalGrowth.get();
    }

    public boolean isDisassemblyCraftingEnabled() {
        return this.COMMON.disassemblyCrafting.get();
    }

    public boolean isSecurityAuditLogEnabled() {
        return this.COMMON.securityAuditLog.get();
    }

    public boolean isBlockUpdateLogEnabled() {
        return this.COMMON.blockUpdateLog.get();
    }

    public boolean isPacketLogEnabled() {
        return this.COMMON.packetLog.get();
    }

    public boolean isChunkLoggerTraceEnabled() {
        return this.COMMON.chunkLoggerTrace.get();
    }

    public boolean serverOpsIgnoreSecurity() {
        return this.COMMON.serverOpsIgnoreSecurity.get();
    }

    public ChannelMode getChannelMode() {
        return this.COMMON.channels.get();
    }

    public void setChannelModel(ChannelMode mode) {
        this.COMMON.channels.set(mode);
    }

    public int getPathfindingStepsPerTick() {
        return this.COMMON.pathfindingStepsPerTick.get();
    }

    public boolean isPlacementPreviewEnabled() {
        return this.CLIENT.showPlacementPreview.get();
    }

    public boolean isPortableCellDisassemblyEnabled() {
        return this.COMMON.portableCellDisassembly.get();
    }

    private static class ClientConfig {
        public final BooleanOption enableEffects;
        public final BooleanOption useLargeFonts;
        public final BooleanOption useColoredCraftingStatus;
        public final BooleanOption disableColoredCableRecipesInJEI;
        public final BooleanOption enableFacadesInJEI;
        public final EnumOption<PowerUnits> selectedPowerUnit;
        public final BooleanOption debugGuiOverlays;
        public final BooleanOption showPlacementPreview;
        public final EnumOption<YesNo> searchTooltips;
        public final EnumOption<TerminalStyle> terminalStyle;
        public final EnumOption<SearchBoxMode> terminalSearchMode;

        public ClientConfig(ConfigSection root) {
            ConfigSection client = root.subsection("client");
            this.disableColoredCableRecipesInJEI = client.addBoolean("disableColoredCableRecipesInJEI", true);
            this.enableFacadesInJEI = client.addBoolean("enableFacadesInJEI", false);
            this.enableEffects = client.addBoolean("enableEffects", true);
            this.useLargeFonts = client.addBoolean("useTerminalUseLargeFont", false);
            this.useColoredCraftingStatus = client.addBoolean("useColoredCraftingStatus", true);
            this.selectedPowerUnit = client.addEnum("PowerUnit", PowerUnits.AE, "Power unit shown in AE UIs");
            this.debugGuiOverlays = client.addBoolean("showDebugGuiOverlays", false, "Show debugging GUI overlays");
            this.showPlacementPreview = client.addBoolean("showPlacementPreview", true, "Show a preview of part and facade placement");
            ConfigSection terminals = root.subsection("terminals");
            this.searchTooltips = terminals.addEnum("searchTooltips", YesNo.YES, "Should tooltips be searched. Performance impact");
            this.terminalStyle = terminals.addEnum("terminalStyle", TerminalStyle.TALL);
            this.terminalSearchMode = terminals.addEnum("terminalSearchMode", SearchBoxMode.DEFAULT);
        }
    }

    private static class CommonConfig {
        public final IntegerOption formationPlaneEntityLimit;
        public final IntegerOption craftingCalculationTimePerTick;
        public final BooleanOption craftingSimulatedExtraction;
        public final BooleanOption allowBlockEntityFacades;
        public final BooleanOption debugTools;
        public final BooleanOption matterCannonBlockDamage;
        public final BooleanOption tinyTntBlockDamage;
        public final BooleanOption serverOpsIgnoreSecurity;
        public final EnumOption<ChannelMode> channels;
        public final IntegerOption pathfindingStepsPerTick;
        public final BooleanOption inWorldSingularity;
        public final BooleanOption inWorldFluix;
        public final BooleanOption inWorldCrystalGrowth;
        public final BooleanOption disassemblyCrafting;
        public final DoubleOption spatialPowerExponent;
        public final DoubleOption spatialPowerMultiplier;
        public final BooleanOption securityAuditLog;
        public final BooleanOption blockUpdateLog;
        public final BooleanOption packetLog;
        public final BooleanOption craftingLog;
        public final BooleanOption debugLog;
        public final BooleanOption gridLog;
        public final BooleanOption chunkLoggerTrace;
        public final DoubleOption chargerChargeRate;
        public final IntegerOption wirelessTerminalBattery;
        public final IntegerOption entropyManipulatorBattery;
        public final IntegerOption matterCannonBattery;
        public final IntegerOption portableCellBattery;
        public final IntegerOption colorApplicatorBattery;
        public final IntegerOption chargedStaffBattery;
        public final IntegerOption quartzOresPerCluster;
        public final IntegerOption quartzOresClusterAmount;
        public final BooleanOption generateQuartzOre;
        public final BooleanOption generateMeteorites;
        public final StringListOption quartzOresBiomeBlacklist;
        public final BooleanOption spawnPressesInMeteorites;
        public final DoubleOption wirelessBaseCost;
        public final DoubleOption wirelessCostMultiplier;
        public final DoubleOption wirelessTerminalDrainMultiplier;
        public final DoubleOption wirelessBaseRange;
        public final DoubleOption wirelessBoosterRangeMultiplier;
        public final DoubleOption wirelessBoosterExp;
        public final DoubleOption wirelessHighWirelessCount;
        public final BooleanOption portableCellDisassembly;
        public final DoubleOption powerRatioForgeEnergy;
        public final DoubleOption powerUsageMultiplier;
        public final IntegerOption condenserMatterBallsPower;
        public final IntegerOption condenserSingularityPower;
        public final StringOption improvedFluidTag;
        public final DoubleOption improvedFluidMultiplier;
        public final Map<TickRates, IntegerOption> tickRateMin = new HashMap<TickRates, IntegerOption>();
        public final Map<TickRates, IntegerOption> tickRateMax = new HashMap<TickRates, IntegerOption>();

        public CommonConfig(ConfigSection root) {
            ConfigSection general = root.subsection("general");
            this.debugTools = general.addBoolean("unsupportedDeveloperTools", false);
            this.matterCannonBlockDamage = general.addBoolean("matterCannonBlockDamage", true, "Enables the ability of the Matter Cannon to break blocks.");
            this.tinyTntBlockDamage = general.addBoolean("tinyTntBlockDamage", true, "Enables the ability of Tiny TNT to break blocks.");
            this.serverOpsIgnoreSecurity = general.addBoolean("serverOpsIgnoreSecurity", true, "Server operators are not restricted by ME security terminal settings.");
            this.channels = general.addEnum("channels", ChannelMode.DEFAULT, "Changes the channel capacity that cables provide in AE2.");
            this.pathfindingStepsPerTick = general.addInt("pathfindingStepsPerTick", 4, 1, 1024, "The number of pathfinding steps that are taken per tick and per grid that is booting. Lower numbers will mean booting takes longer, but less work is done per tick.");
            ConfigSection automation = root.subsection("automation");
            this.formationPlaneEntityLimit = automation.addInt("formationPlaneEntityLimit", 128);
            ConfigSection facades = root.subsection("facades");
            this.allowBlockEntityFacades = facades.addBoolean("allowBlockEntities", false, "Unsupported: Allows whitelisting block entities as facades. Could work, have render issues, or corrupt your world. USE AT YOUR OWN RISK.");
            ConfigSection craftingCPU = root.subsection("craftingCPU");
            this.craftingCalculationTimePerTick = craftingCPU.addInt("craftingCalculationTimePerTick", 5);
            this.craftingSimulatedExtraction = craftingCPU.addBoolean("craftingSimulatedExtraction", false, "When true: simulate extraction of all the network's contents when starting a crafting job calculation. When false: use the cached available content list (same as terminals). Enabling might work a bit better, but it will significantly reduce performance.");
            ConfigSection crafting = root.subsection("crafting");
            this.inWorldSingularity = crafting.addBoolean("inWorldSingularity", true, "Enable the in-world crafting of singularities.");
            this.inWorldFluix = crafting.addBoolean("inWorldFluix", true, "Enable the in-world crafting of fluix crystals.");
            this.inWorldCrystalGrowth = crafting.addBoolean("inWorldCrystalGrowth", true, "Enable the in-world crafting of crystals.");
            this.disassemblyCrafting = crafting.addBoolean("disassemblyCrafting", true, "Enable shift-clicking with the crafting units in hand to disassemble them.");
            ConfigSection spatialio = root.subsection("spatialio");
            this.spatialPowerMultiplier = spatialio.addDouble("spatialPowerMultiplier", 1250.0);
            this.spatialPowerExponent = spatialio.addDouble("spatialPowerExponent", 1.35);
            ConfigSection logging = root.subsection("logging");
            this.securityAuditLog = logging.addBoolean("securityAuditLog", false);
            this.blockUpdateLog = logging.addBoolean("blockUpdateLog", false);
            this.packetLog = logging.addBoolean("packetLog", false);
            this.craftingLog = logging.addBoolean("craftingLog", false);
            this.debugLog = logging.addBoolean("debugLog", false);
            this.gridLog = logging.addBoolean("gridLog", false);
            this.chunkLoggerTrace = logging.addBoolean("chunkLoggerTrace", false, "Enable stack trace logging for the chunk loading debug command");
            ConfigSection battery = root.subsection("battery");
            this.chargerChargeRate = battery.addDouble("chargerChargeRate", 1.0, 0.1, 10.0, "The chargers charging rate factor, which is applied to the charged items charge rate. 2 means it charges everything twice as fast. 0.5 half as fast.");
            this.wirelessTerminalBattery = battery.addInt("wirelessTerminal", 1600000);
            this.chargedStaffBattery = battery.addInt("chargedStaff", 8000);
            this.entropyManipulatorBattery = battery.addInt("entropyManipulator", 200000);
            this.portableCellBattery = battery.addInt("portableCell", 20000);
            this.colorApplicatorBattery = battery.addInt("colorApplicator", 20000);
            this.matterCannonBattery = battery.addInt("matterCannon", 200000);
            ConfigSection worldGen = root.subsection("worldGen");
            this.spawnPressesInMeteorites = worldGen.addBoolean("spawnPressesInMeteorites", true);
            this.generateQuartzOre = worldGen.addBoolean("generateQuartzOre", true);
            this.generateMeteorites = worldGen.addBoolean("generateMeteorites", true);
            this.quartzOresPerCluster = worldGen.addInt("quartzOresPerCluster", 7);
            this.quartzOresClusterAmount = worldGen.addInt("quartzOresClusterAmount", 20);
            this.quartzOresBiomeBlacklist = worldGen.addStringList("quartzOresBiomeBlacklist", new ArrayList<String>(), "Biome IDs in which quartz ores should NOT be generated (i.e. minecraft:plains).");
            ConfigSection wireless = root.subsection("wireless");
            this.wirelessBaseCost = wireless.addDouble("wirelessBaseCost", 8.0);
            this.wirelessCostMultiplier = wireless.addDouble("wirelessCostMultiplier", 1.0);
            this.wirelessBaseRange = wireless.addDouble("wirelessBaseRange", 16.0);
            this.wirelessBoosterRangeMultiplier = wireless.addDouble("wirelessBoosterRangeMultiplier", 1.0);
            this.wirelessBoosterExp = wireless.addDouble("wirelessBoosterExp", 1.5);
            this.wirelessHighWirelessCount = wireless.addDouble("wirelessHighWirelessCount", 64.0);
            this.wirelessTerminalDrainMultiplier = wireless.addDouble("wirelessTerminalDrainMultiplier", 1.0);
            ConfigSection portableCells = root.subsection("PortableCells");
            this.portableCellDisassembly = portableCells.addBoolean("allowDisassembly", true, "Allow disassembly of portable cells into the recipe ingredients using shift+right-click");
            ConfigSection PowerRatios = root.subsection("PowerRatios");
            this.powerRatioForgeEnergy = PowerRatios.addDouble("ForgeEnergy", 0.5);
            this.powerUsageMultiplier = PowerRatios.addDouble("UsageMultiplier", 1.0, 0.01, Double.MAX_VALUE);
            ConfigSection Condenser = root.subsection("Condenser");
            this.condenserMatterBallsPower = Condenser.addInt("MatterBalls", 256);
            this.condenserSingularityPower = Condenser.addInt("Singularity", 256000);
            ConfigSection tickrates = root.subsection("tickRates", " Min / Max Tickrates for dynamic ticking, most of these components also use sleeping, to prevent constant ticking, adjust with care, non standard rates are not supported or tested.");
            for (TickRates tickRate : TickRates.values()) {
                this.tickRateMin.put(tickRate, tickrates.addInt(tickRate.name() + "Min", tickRate.getDefaultMin()));
                this.tickRateMax.put(tickRate, tickrates.addInt(tickRate.name() + "Max", tickRate.getDefaultMax()));
            }
            ConfigSection inWorldCrystalGrowth = root.subsection("inWorldCrystalGrowth", "Settings for in-world growth of crystals.");
            this.improvedFluidTag = inWorldCrystalGrowth.addString("improvedFluidTag", "", "A fluid tag that identifies fluids that improve crystal growth speed. Does not affect growth with water/lava.");
            this.improvedFluidMultiplier = inWorldCrystalGrowth.addDouble("improvedFluidMultiplier", 2.0, 1.0, 10.0, "The speed multiplier to use when the crystals are submerged in the improved fluid.");
        }
    }
}

