/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

final class RenderHelper {
    private static EnumMap<Direction, List<Vec3>> cornersForFacing = RenderHelper.generateCornersForFacings();

    private RenderHelper() {
    }

    static List<Vec3> getFaceCorners(Direction side) {
        return cornersForFacing.get(side);
    }

    private static EnumMap<Direction, List<Vec3>> generateCornersForFacings() {
        EnumMap<Direction, List<Vec3>> result = new EnumMap<Direction, List<Vec3>>(Direction.class);
        for (Direction facing : Direction.values()) {
            List corners;
            float offset = facing.m_122421_() == Direction.AxisDirection.NEGATIVE ? 0.0f : 1.0f;
            switch (facing.m_122434_()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case X: {
                    ArrayList arrayList = Lists.newArrayList((Object[])new Vec3[]{new Vec3((double)offset, 1.0, 1.0), new Vec3((double)offset, 0.0, 1.0), new Vec3((double)offset, 0.0, 0.0), new Vec3((double)offset, 1.0, 0.0)});
                    break;
                }
                case Y: {
                    ArrayList arrayList = Lists.newArrayList((Object[])new Vec3[]{new Vec3(1.0, (double)offset, 1.0), new Vec3(1.0, (double)offset, 0.0), new Vec3(0.0, (double)offset, 0.0), new Vec3(0.0, (double)offset, 1.0)});
                    break;
                }
                case Z: {
                    ArrayList arrayList = corners = Lists.newArrayList((Object[])new Vec3[]{new Vec3(0.0, 1.0, (double)offset), new Vec3(0.0, 0.0, (double)offset), new Vec3(1.0, 0.0, (double)offset), new Vec3(1.0, 1.0, (double)offset)});
                }
            }
            if (facing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
                corners = Lists.reverse((List)corners);
            }
            result.put(facing, (List<Vec3>)ImmutableList.copyOf((Collection)corners));
        }
        return result;
    }

    private static Vec3 adjust(Vec3 vec, Direction.Axis axis, double delta) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vec3(vec.f_82479_ + delta, vec.f_82480_, vec.f_82481_);
            case Direction.Axis.Y -> new Vec3(vec.f_82479_, vec.f_82480_ + delta, vec.f_82481_);
            case Direction.Axis.Z -> new Vec3(vec.f_82479_, vec.f_82480_, vec.f_82481_ + delta);
        };
    }
}

