/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.config.CondenserOutput;
import appeng.api.config.Settings;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.inventories.BaseInternalInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.MEStorage;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.AEBaseInvBlockEntity;
import appeng.blockentity.misc.CondenserInventory;
import appeng.capabilities.Capabilities;
import appeng.core.definitions.AEItems;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.AEItemFilters;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class CondenserBlockEntity
extends AEBaseInvBlockEntity
implements IConfigurableObject {
    public static final int BYTE_MULTIPLIER = 8;
    private final ConfigManager cm = new ConfigManager(() -> {
        this.saveChanges();
        this.addPower(0.0);
    });
    private final AppEngInternalInventory outputSlot = new AppEngInternalInventory(this, 1);
    private final AppEngInternalInventory storageSlot = new AppEngInternalInventory(this, 1);
    private final InternalInventory inputSlot = new CondenseItemHandler();
    private final IFluidHandler fluidHandler = new FluidHandler();
    private final MEHandler meHandler = new MEHandler();
    private final InternalInventory externalInv = new CombinedInternalInventory(this.inputSlot, new FilteredInternalInventory(this.outputSlot, AEItemFilters.EXTRACT_ONLY));
    private final InternalInventory combinedInv = new CombinedInternalInventory(this.inputSlot, this.outputSlot, this.storageSlot);
    private double storedPower = 0.0;

    public CondenserBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.cm.registerSetting(Settings.CONDENSER_OUTPUT, CondenserOutput.TRASH);
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.cm.writeToNBT(data);
        data.m_128347_("storedPower", this.getStoredPower());
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.cm.readFromNBT(data);
        this.setStoredPower(data.m_128459_("storedPower"));
    }

    public double getStorage() {
        IStorageComponent sc;
        Item item;
        ItemStack is = this.storageSlot.getStackInSlot(0);
        if (!is.m_41619_() && (item = is.m_41720_()) instanceof IStorageComponent && (sc = (IStorageComponent)item).isStorageComponent(is)) {
            return sc.getBytes(is) * 8;
        }
        return 0.0;
    }

    public void addPower(double rawPower) {
        this.setStoredPower(this.getStoredPower() + rawPower);
        this.setStoredPower(Math.max(0.0, Math.min(this.getStorage(), this.getStoredPower())));
        this.fillOutput();
    }

    private void fillOutput() {
        double requiredPower = this.getRequiredPower();
        ItemStack output = this.getOutput();
        while (requiredPower <= this.getStoredPower() && !output.m_41619_() && requiredPower > 0.0 && this.canAddOutput(output)) {
            this.setStoredPower(this.getStoredPower() - requiredPower);
            this.addOutput(output);
        }
    }

    private boolean canAddOutput(ItemStack output) {
        return this.outputSlot.insertItem(0, output, true).m_41619_();
    }

    private void addOutput(ItemStack output) {
        this.outputSlot.insertItem(0, output, false);
    }

    InternalInventory getOutputSlot() {
        return this.outputSlot;
    }

    private ItemStack getOutput() {
        return switch (this.cm.getSetting(Settings.CONDENSER_OUTPUT)) {
            case CondenserOutput.MATTER_BALLS -> AEItems.MATTER_BALL.stack();
            case CondenserOutput.SINGULARITY -> AEItems.SINGULARITY.stack();
            default -> ItemStack.f_41583_;
        };
    }

    public double getRequiredPower() {
        return this.cm.getSetting(Settings.CONDENSER_OUTPUT).requiredPower;
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.combinedInv;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.outputSlot) {
            this.fillOutput();
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    public double getStoredPower() {
        return this.storedPower;
    }

    private void setStoredPower(double storedPower) {
        this.storedPower = storedPower;
    }

    public InternalInventory getExternalInv() {
        return this.externalInv;
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    public MEHandler getMEHandler() {
        return this.meHandler;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(this.externalInv::toItemHandler);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.fluidHandler);
        }
        if (capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR) {
            return LazyOptional.of(() -> this.meHandler);
        }
        return super.getCapability(capability, facing);
    }

    private class CondenseItemHandler
    extends BaseInternalInventory {
        private CondenseItemHandler() {
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        @Override
        public void setItemDirect(int slotIndex, ItemStack stack) {
            if (!stack.m_41619_()) {
                CondenserBlockEntity.this.addPower(stack.m_41613_());
            }
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!simulate && !stack.m_41619_()) {
                CondenserBlockEntity.this.addPower(stack.m_41613_());
            }
            return ItemStack.f_41583_;
        }

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }
    }

    private class FluidHandler
    implements IFluidTank,
    IFluidHandler {
        private FluidHandler() {
        }

        public FluidStack getFluid() {
            return FluidStack.EMPTY;
        }

        public int getFluidAmount() {
            return 0;
        }

        public int getCapacity() {
            return 1000;
        }

        public boolean isFluidValid(FluidStack stack) {
            return !stack.isEmpty();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            AEFluidKey what;
            if (action == IFluidHandler.FluidAction.EXECUTE && (what = AEFluidKey.of(resource)) != null) {
                double transferFactor = what.getAmountPerOperation();
                CondenserBlockEntity.this.addPower((double)resource.getAmount() / transferFactor);
            }
            return resource.isEmpty() ? 0 : resource.getAmount();
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? this.getCapacity() : 0;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return tank == 0 && this.isFluidValid(stack);
        }
    }

    private class MEHandler
    implements IStorageMonitorableAccessor {
        private final CondenserInventory itemInventory;

        private MEHandler() {
            this.itemInventory = new CondenserInventory(CondenserBlockEntity.this);
        }

        @Override
        @Nullable
        public MEStorage getInventory(IActionSource src) {
            return this.itemInventory;
        }
    }
}

