/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache.type;

import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.recipe.ingredient.creator.ItemStackIngredientCreator;
import mekanism.common.recipe.lookup.cache.type.NBTSensitiveInputCache;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.NBTIngredient;

public class ItemInputCache<RECIPE extends MekanismRecipe>
extends NBTSensitiveInputCache<Item, HashedItem, ItemStack, ItemStackIngredient, RECIPE> {
    @Override
    public boolean mapInputs(RECIPE recipe, ItemStackIngredient inputIngredient) {
        if (inputIngredient instanceof ItemStackIngredientCreator.SingleItemStackIngredient) {
            ItemStackIngredientCreator.SingleItemStackIngredient single = (ItemStackIngredientCreator.SingleItemStackIngredient)inputIngredient;
            return this.mapIngredient(recipe, single.getInputRaw());
        }
        if (inputIngredient instanceof ItemStackIngredientCreator.MultiItemStackIngredient) {
            ItemStackIngredientCreator.MultiItemStackIngredient multi = (ItemStackIngredientCreator.MultiItemStackIngredient)inputIngredient;
            return this.mapMultiInputs(recipe, multi);
        }
        return true;
    }

    private boolean mapIngredient(RECIPE recipe, Ingredient input) {
        if (input.isVanilla() || input.isSimple()) {
            for (ItemStack item : input.m_43908_()) {
                this.addInputCache(item.m_41720_(), recipe);
            }
        } else {
            if (input instanceof CompoundIngredient) {
                CompoundIngredient compoundIngredient = (CompoundIngredient)input;
                boolean result = false;
                for (Ingredient child : compoundIngredient.getChildren()) {
                    result |= this.mapIngredient(recipe, child);
                }
                return result;
            }
            if (input instanceof NBTIngredient) {
                this.addNbtInputCache(HashedItem.create(input.m_43908_()[0]), recipe);
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Item createKey(ItemStack stack) {
        return stack.m_41720_();
    }

    @Override
    protected HashedItem createNbtKey(ItemStack stack) {
        return HashedItem.raw(stack);
    }

    @Override
    public boolean isEmpty(ItemStack input) {
        return input.m_41619_();
    }
}

