/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;

public class MekFakePlayer
extends FakePlayer {
    private static WeakReference<MekFakePlayer> INSTANCE;
    private UUID emulatingUUID = null;

    private MekFakePlayer(ServerLevel world) {
        super(world, (GameProfile)new FakeGameProfile());
        ((FakeGameProfile)this.m_36316_()).myFakePlayer = this;
    }

    public boolean m_7301_(@Nonnull MobEffectInstance effect) {
        return false;
    }

    public void setEmulatingUUID(UUID uuid) {
        this.emulatingUUID = uuid;
    }

    @Nonnull
    public UUID m_142081_() {
        return this.emulatingUUID == null ? super.m_142081_() : this.emulatingUUID;
    }

    public Vec3 m_20182_() {
        return new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public BlockPos m_142538_() {
        return new BlockPos(this.m_146903_(), this.m_146904_(), this.m_146907_());
    }

    public static <R> R withFakePlayer(ServerLevel world, Function<MekFakePlayer, R> fakePlayerConsumer) {
        MekFakePlayer actual;
        MekFakePlayer mekFakePlayer = actual = INSTANCE == null ? null : (MekFakePlayer)((Object)INSTANCE.get());
        if (actual == null) {
            actual = new MekFakePlayer(world);
            INSTANCE = new WeakReference<MekFakePlayer>(actual);
        }
        MekFakePlayer player = actual;
        player.f_19853_ = world;
        R result = fakePlayerConsumer.apply(player);
        player.emulatingUUID = null;
        player.f_19853_ = null;
        return result;
    }

    public static <R> R withFakePlayer(ServerLevel world, double x, double y, double z, Function<MekFakePlayer, R> fakePlayerConsumer) {
        return (R)MekFakePlayer.withFakePlayer(world, fakePlayer -> {
            fakePlayer.m_20343_(x, y, z);
            return fakePlayerConsumer.apply((MekFakePlayer)((Object)fakePlayer));
        });
    }

    public static void releaseInstance(LevelAccessor world) {
        MekFakePlayer actual;
        MekFakePlayer mekFakePlayer = actual = INSTANCE == null ? null : (MekFakePlayer)((Object)INSTANCE.get());
        if (actual != null && actual.f_19853_ == world) {
            actual.f_19853_ = null;
        }
    }

    private static class FakeGameProfile
    extends GameProfile {
        private MekFakePlayer myFakePlayer = null;

        public FakeGameProfile() {
            super(Mekanism.gameProfile.getId(), Mekanism.gameProfile.getName());
        }

        private UUID getEmulatingUUID() {
            return this.myFakePlayer == null ? null : this.myFakePlayer.emulatingUUID;
        }

        public UUID getId() {
            UUID emulatingUUID = this.getEmulatingUUID();
            return emulatingUUID == null ? super.getId() : emulatingUUID;
        }

        public String getName() {
            UUID emulatingUUID = this.getEmulatingUUID();
            return emulatingUUID == null ? super.getName() : MekanismUtils.getLastKnownUsername(emulatingUUID);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GameProfile)) {
                return false;
            }
            GameProfile that = (GameProfile)o;
            return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName());
        }

        public int hashCode() {
            UUID id = this.getId();
            String name = this.getName();
            int result = id == null ? 0 : id.hashCode();
            result = 31 * result + (name == null ? 0 : name.hashCode());
            return result;
        }
    }
}

