/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.SpecialColors;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public interface IFancyFontRenderer {
    public int getXSize();

    public Font getFont();

    default public int titleTextColor() {
        return SpecialColors.TEXT_TITLE.argb();
    }

    default public int headingTextColor() {
        return SpecialColors.TEXT_HEADING.argb();
    }

    default public int subheadingTextColor() {
        return SpecialColors.TEXT_SUBHEADING.argb();
    }

    default public int screenTextColor() {
        return SpecialColors.TEXT_SCREEN.argb();
    }

    default public int drawString(PoseStack matrix, Component component, int x, int y, int color) {
        return this.getFont().m_92889_(matrix, component, (float)x, (float)y, color);
    }

    default public int getStringWidth(Component component) {
        return this.getFont().m_92852_((FormattedText)component);
    }

    default public void drawCenteredText(PoseStack matrix, Component component, float x, float y, int color) {
        this.drawCenteredText(matrix, component, x, 0.0f, y, color);
    }

    default public void drawCenteredText(PoseStack matrix, Component component, float xStart, float areaWidth, float y, int color) {
        int textWidth = this.getStringWidth(component);
        float centerX = xStart + areaWidth / 2.0f - (float)textWidth / 2.0f;
        this.drawTextExact(matrix, component, centerX, y, color);
    }

    default public void drawTitleText(PoseStack matrix, Component text, float y) {
        this.drawCenteredTextScaledBound(matrix, text, this.getXSize() - 8, y, this.titleTextColor());
    }

    default public void drawScaledCenteredTextScaledBound(PoseStack matrix, Component text, float left, float y, int color, float maxX, float textScale) {
        float width = (float)this.getStringWidth(text) * textScale;
        float scale = Math.min(1.0f, maxX / width) * textScale;
        this.drawScaledCenteredText(matrix, text, left, y, color, scale);
    }

    default public void drawScaledCenteredText(PoseStack matrix, Component text, float left, float y, int color, float scale) {
        int textWidth = this.getStringWidth(text);
        float centerX = left - (float)textWidth / 2.0f * scale;
        this.drawTextWithScale(matrix, text, centerX, y, color, scale);
    }

    default public void drawCenteredTextScaledBound(PoseStack matrix, Component text, float maxLength, float y, int color) {
        this.drawCenteredTextScaledBound(matrix, text, maxLength, 0.0f, y, color);
    }

    default public void drawCenteredTextScaledBound(PoseStack matrix, Component text, float maxLength, float x, float y, int color) {
        float scale = Math.min(1.0f, maxLength / (float)this.getStringWidth(text));
        this.drawScaledCenteredText(matrix, text, x + (float)this.getXSize() / 2.0f, y, color, scale);
    }

    default public void drawTextExact(PoseStack matrix, Component text, float x, float y, int color) {
        matrix.m_85836_();
        matrix.m_85837_((double)x, (double)y, 0.0);
        this.drawString(matrix, text, 0, 0, color);
        matrix.m_85849_();
    }

    default public float getNeededScale(Component text, float maxLength) {
        int length = this.getStringWidth(text);
        return (float)length <= maxLength ? 1.0f : maxLength / (float)length;
    }

    default public void drawTextScaledBound(PoseStack matrix, String text, float x, float y, int color, float maxLength) {
        this.drawTextScaledBound(matrix, (Component)TextComponentUtil.getString(text), x, y, color, maxLength);
    }

    default public void drawTextScaledBound(PoseStack matrix, Component component, float x, float y, int color, float maxLength) {
        int length = this.getStringWidth(component);
        if ((float)length <= maxLength) {
            this.drawTextExact(matrix, component, x, y, color);
        } else {
            this.drawTextWithScale(matrix, component, x, y, color, maxLength / (float)length);
        }
        MekanismRenderer.resetColor();
    }

    default public void drawScaledTextScaledBound(PoseStack matrix, Component text, float x, float y, int color, float maxX, float textScale) {
        float width = (float)this.getStringWidth(text) * textScale;
        float scale = Math.min(1.0f, maxX / width) * textScale;
        this.drawTextWithScale(matrix, text, x, y, color, scale);
    }

    default public void drawTextWithScale(PoseStack matrix, Component text, float x, float y, int color, float scale) {
        this.prepTextScale(matrix, m -> this.drawString((PoseStack)m, text, 0, 0, color), x, y, scale);
    }

    default public void prepTextScale(PoseStack matrix, Consumer<PoseStack> runnable, float x, float y, float scale) {
        float yAdd = 4.0f - scale * 8.0f / 2.0f;
        matrix.m_85836_();
        matrix.m_85837_((double)x, (double)(y + yAdd), 0.0);
        matrix.m_85841_(scale, scale, scale);
        runnable.accept(matrix);
        matrix.m_85849_();
        MekanismRenderer.resetColor();
    }

    default public int drawWrappedTextWithScale(PoseStack matrix, Component text, float x, float y, int color, float maxLength, float scale) {
        return new WrappedTextRenderer(this, text).renderWithScale(matrix, x, y, color, maxLength, scale);
    }

    default public void drawWrappedCenteredText(PoseStack matrix, Component text, float x, float y, int color, float maxLength) {
        new WrappedTextRenderer(this, text).renderCentered(matrix, x, y, color, maxLength);
    }

    public static class WrappedTextRenderer {
        private final List<LineData> linesToDraw = new ArrayList<LineData>();
        private final IFancyFontRenderer font;
        private final String text;
        @Nullable
        private Font lastFont;
        private float lastMaxLength = -1.0f;
        private float lineLength = 0.0f;

        public WrappedTextRenderer(IFancyFontRenderer font, Component text) {
            this(font, text.getString());
        }

        public WrappedTextRenderer(IFancyFontRenderer font, String text) {
            this.font = font;
            this.text = text;
        }

        public void renderCentered(PoseStack matrix, float x, float y, int color, float maxLength) {
            this.calculateLines(maxLength);
            float startY = y;
            for (LineData line : this.linesToDraw) {
                this.font.drawTextExact(matrix, line.component(), x - line.length() / 2.0f, startY, color);
                startY += 9.0f;
            }
        }

        public int renderWithScale(PoseStack matrix, float x, float y, int color, float maxLength, float scale) {
            this.calculateLines(maxLength / scale);
            this.font.prepTextScale(matrix, m -> {
                int startY = 0;
                for (LineData line : this.linesToDraw) {
                    this.font.drawString((PoseStack)m, line.component(), 0, startY, color);
                    startY += 9;
                }
            }, x, y, scale);
            return this.linesToDraw.size();
        }

        void calculateLines(float maxLength) {
            Font font = this.font.getFont();
            if (font != null && (this.lastFont != font || this.lastMaxLength != maxLength)) {
                this.lastFont = font;
                this.lastMaxLength = maxLength;
                this.linesToDraw.clear();
                StringBuilder lineBuilder = new StringBuilder();
                StringBuilder wordBuilder = new StringBuilder();
                int spaceLength = this.lastFont.m_92895_(" ");
                int wordLength = 0;
                for (char c : this.text.toCharArray()) {
                    if (c == ' ') {
                        lineBuilder = this.addWord(lineBuilder, wordBuilder, maxLength, spaceLength, wordLength);
                        wordBuilder = new StringBuilder();
                        wordLength = 0;
                        continue;
                    }
                    wordBuilder.append(c);
                    wordLength += this.lastFont.m_92895_(Character.toString(c));
                }
                if (!wordBuilder.isEmpty()) {
                    lineBuilder = this.addWord(lineBuilder, wordBuilder, maxLength, spaceLength, wordLength);
                }
                if (!lineBuilder.isEmpty()) {
                    this.linesToDraw.add(new LineData((Component)TextComponentUtil.getString(lineBuilder.toString()), this.lineLength));
                }
            }
        }

        StringBuilder addWord(StringBuilder lineBuilder, StringBuilder wordBuilder, float maxLength, int spaceLength, int wordLength) {
            float spacingLength;
            float f = spacingLength = lineBuilder.isEmpty() ? 0.0f : (float)spaceLength;
            if (this.lineLength + spacingLength + (float)wordLength > maxLength) {
                this.linesToDraw.add(new LineData((Component)TextComponentUtil.getString(lineBuilder.toString()), this.lineLength));
                lineBuilder = new StringBuilder(wordBuilder);
                this.lineLength = wordLength;
            } else {
                if (spacingLength > 0.0f) {
                    lineBuilder.append(" ");
                }
                lineBuilder.append((CharSequence)wordBuilder);
                this.lineLength += spacingLength + (float)wordLength;
            }
            return lineBuilder;
        }

        public static int calculateHeightRequired(Font font, Component text, int width, float maxLength) {
            return WrappedTextRenderer.calculateHeightRequired(font, text.getString(), width, maxLength);
        }

        public static int calculateHeightRequired(final Font font, String text, final int width, float maxLength) {
            WrappedTextRenderer wrappedTextRenderer = new WrappedTextRenderer(new IFancyFontRenderer(){

                @Override
                public int getXSize() {
                    return width;
                }

                @Override
                public Font getFont() {
                    return font;
                }
            }, text);
            wrappedTextRenderer.calculateLines(maxLength);
            return 9 * wrappedTextRenderer.linesToDraw.size();
        }

        private record LineData(Component component, float length) {
        }
    }
}

