/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.slot;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.VirtualSlotContainerScreen;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.interfaces.IJEIIngredientHelper;
import mekanism.common.inventory.container.IGUIWindow;
import mekanism.common.inventory.container.slot.IVirtualSlot;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.slot.VirtualInventoryContainerSlot;
import net.minecraft.world.item.ItemStack;

public class GuiVirtualSlot
extends GuiSlot
implements IJEIIngredientHelper {
    private IVirtualSlot virtualSlot;

    public GuiVirtualSlot(@Nullable IGUIWindow window, SlotType type, IGuiWrapper gui, int x, int y, VirtualInventoryContainerSlot containerSlot) {
        this(type, gui, x, y);
        if (containerSlot != null) {
            SlotOverlay slotOverlay = containerSlot.getSlotOverlay();
            if (slotOverlay != null) {
                this.with(slotOverlay);
            }
            this.updateVirtualSlot(window, containerSlot);
        }
    }

    public GuiVirtualSlot(SlotType type, IGuiWrapper gui, int x, int y) {
        super(type, gui, x, y);
        this.setRenderHover(true);
    }

    public boolean isElementForSlot(IVirtualSlot virtualSlot) {
        return this.virtualSlot == virtualSlot;
    }

    public void updateVirtualSlot(@Nullable IGUIWindow window, @Nonnull IVirtualSlot virtualSlot) {
        this.virtualSlot = virtualSlot;
        this.virtualSlot.updatePosition(window, () -> this.relativeX + 1, () -> this.relativeY + 1);
    }

    @Override
    protected void drawContents(@Nonnull PoseStack matrix) {
        ItemStack stack;
        if (this.virtualSlot != null && !(stack = this.virtualSlot.getStackToRender()).m_41619_()) {
            int xPos = this.f_93620_ + 1;
            int yPos = this.f_93621_ + 1;
            if (this.virtualSlot.shouldDrawOverlay()) {
                GuiVirtualSlot.m_93172_((PoseStack)matrix, (int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-2130706433);
            }
            this.gui().renderItemWithOverlay(matrix, stack, xPos, yPos, 1.0f, this.virtualSlot.getTooltipOverride());
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        IGuiWrapper gui;
        if (mouseX >= (double)this.f_93620_ && mouseY >= (double)this.f_93621_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY < (double)(this.f_93621_ + this.f_93619_) && (gui = this.gui()) instanceof VirtualSlotContainerScreen) {
            VirtualSlotContainerScreen screen = (VirtualSlotContainerScreen)((Object)gui);
            if (this.virtualSlot != null) {
                return screen.slotClicked(this.virtualSlot.getSlot(), button);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    @Nullable
    public Object getIngredient(double mouseX, double mouseY) {
        return this.virtualSlot == null ? null : this.virtualSlot.getStackToRender();
    }
}

