/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import net.minecraft.resources.ResourceLocation;

public abstract class GuiScrollableElement
extends GuiTexturedElement {
    protected double scroll;
    private boolean isDragging;
    private int dragOffset;
    protected final int maxBarHeight;
    protected final int barWidth;
    protected final int barHeight;
    protected final int barXShift;
    protected int barX;
    protected int barY;

    protected GuiScrollableElement(ResourceLocation resource, IGuiWrapper gui, int x, int y, int width, int height, int barXShift, int barYShift, int barWidth, int barHeight, int maxBarHeight) {
        super(resource, gui, x, y, width, height);
        this.barXShift = barXShift;
        this.barX = this.f_93620_ + barXShift;
        this.barY = this.f_93621_ + barYShift;
        this.barWidth = barWidth;
        this.barHeight = barHeight;
        this.maxBarHeight = maxBarHeight;
    }

    @Override
    public void resize(int prevLeft, int prevTop, int left, int top) {
        super.resize(prevLeft, prevTop, left, top);
        this.barX = this.barX - prevLeft + left;
        this.barY = this.barY - prevTop + top;
    }

    @Override
    public void move(int changeX, int changeY) {
        super.move(changeX, changeY);
        this.barX += changeX;
        this.barY += changeY;
    }

    protected abstract int getMaxElements();

    protected abstract int getFocusedElements();

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
        int scroll = this.getScroll();
        if (mouseX >= (double)this.barX && mouseX <= (double)(this.barX + this.barWidth) && mouseY >= (double)(this.barY + scroll) && mouseY <= (double)(this.barY + scroll + this.barHeight)) {
            if (this.needsScrollBars()) {
                double yAxis = mouseY - (double)this.getGuiTop();
                this.dragOffset = (int)(yAxis - (double)(scroll + this.barY));
                this.isDragging = true;
            } else {
                this.scroll = 0.0;
            }
        }
    }

    @Override
    public void m_7212_(double mouseX, double mouseY, double mouseXOld, double mouseYOld) {
        super.m_7212_(mouseX, mouseY, mouseXOld, mouseYOld);
        if (this.needsScrollBars() && this.isDragging) {
            double yAxis = mouseY - (double)this.getGuiTop();
            this.scroll = Math.min(Math.max((yAxis - (double)this.barY - (double)this.dragOffset) / (double)this.getMax(), 0.0), 1.0);
        }
    }

    @Override
    public void m_7691_(double mouseX, double mouseY) {
        super.m_7691_(mouseX, mouseY);
        this.dragOffset = 0;
        this.isDragging = false;
    }

    protected boolean needsScrollBars() {
        return this.getMaxElements() > this.getFocusedElements();
    }

    private int getMax() {
        return this.maxBarHeight - this.barHeight;
    }

    protected int getScroll() {
        int max = this.getMax();
        return Math.max(Math.min((int)(this.scroll * (double)max), max), 0);
    }

    public int getCurrentSelection() {
        if (this.needsScrollBars()) {
            int size = this.getMaxElements() - this.getFocusedElements();
            return (int)(((double)size + 0.5) * this.scroll);
        }
        return 0;
    }

    public boolean adjustScroll(double delta) {
        int elements;
        if (delta != 0.0 && this.needsScrollBars() && (elements = this.getMaxElements() - this.getFocusedElements()) > 0) {
            delta = delta > 0.0 ? 1.0 : -1.0;
            this.scroll = (float)(this.scroll - delta / (double)elements);
            if (this.scroll < 0.0) {
                this.scroll = 0.0;
            } else if (this.scroll > 1.0) {
                this.scroll = 1.0;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPersistentData() {
        return true;
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        GuiScrollableElement old = (GuiScrollableElement)element;
        if (this.needsScrollBars() && old.needsScrollBars()) {
            this.scroll = old.scroll;
        }
    }
}

