/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.common.MekanismLang;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class GuiDigitalSwitch
extends GuiTexturedElement {
    public static final ResourceLocation SWITCH = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "switch/switch.png");
    public static final int BUTTON_SIZE_X = 15;
    public static final int BUTTON_SIZE_Y = 8;
    private final SwitchType type;
    private final ResourceLocation icon;
    private final BooleanSupplier stateSupplier;
    private final Component tooltip;
    private final Runnable onToggle;

    public GuiDigitalSwitch(IGuiWrapper gui, int x, int y, ResourceLocation icon, BooleanSupplier stateSupplier, Component tooltip, Runnable onToggle, SwitchType type) {
        super(SWITCH, gui, x, y, type.width, type.height);
        this.type = type;
        this.icon = icon;
        this.stateSupplier = stateSupplier;
        this.tooltip = tooltip;
        this.onToggle = onToggle;
    }

    @Override
    public void m_7428_(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        this.displayTooltips(matrix, mouseX, mouseY, this.tooltip);
    }

    @Override
    public void drawBackground(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getResource());
        boolean state = this.stateSupplier.getAsBoolean();
        GuiDigitalSwitch.m_93133_((PoseStack)matrix, (int)(this.f_93620_ + this.type.switchX), (int)(this.f_93621_ + this.type.switchY), (float)0.0f, (float)(state ? 0.0f : 8.0f), (int)15, (int)8, (int)15, (int)16);
        GuiDigitalSwitch.m_93133_((PoseStack)matrix, (int)(this.f_93620_ + this.type.switchX), (int)(this.f_93621_ + this.type.switchY + 8 + 1), (float)0.0f, (float)(state ? 8.0f : 0.0f), (int)15, (int)8, (int)15, (int)16);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.icon);
        GuiDigitalSwitch.m_93133_((PoseStack)matrix, (int)(this.f_93620_ + this.type.iconX), (int)(this.f_93621_ + this.type.iconY), (float)0.0f, (float)0.0f, (int)5, (int)5, (int)5, (int)5);
    }

    @Override
    public void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.drawScaledCenteredText(matrix, (Component)MekanismLang.ON.translate(new Object[0]), this.relativeX + this.type.switchX + 8, this.relativeY + this.type.switchY, 0x101010, 0.5f);
        this.drawScaledCenteredText(matrix, (Component)MekanismLang.OFF.translate(new Object[0]), this.relativeX + this.type.switchX + 8, this.relativeY + this.type.switchY + 9, 0x101010, 0.5f);
    }

    public void m_5716_(double mouseX, double mouseY) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)MekanismSounds.BEEP.get()), (float)1.0f));
        this.onToggle.run();
    }

    public static enum SwitchType {
        LOWER_ICON(15, 31, 0, 0, 5, 21),
        LEFT_ICON(30, 16, 15, 0, 5, 6);

        private final int iconX;
        private final int iconY;
        private final int width;
        private final int height;
        private final int switchX;
        private final int switchY;

        private SwitchType(int width, int height, int switchX, int switchY, int iconX, int iconY) {
            this.width = width;
            this.height = height;
            this.iconX = iconX;
            this.iconY = iconY;
            this.switchX = switchX;
            this.switchY = switchY;
        }
    }
}

