/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.world.spawner;

import iskallia.ispawner.block.entity.SpawnerBlockEntity;
import iskallia.ispawner.nbt.INBTSerializable;
import iskallia.ispawner.world.spawner.SpawnerUsageContext;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SpawnerAction
implements INBTSerializable<CompoundTag> {
    protected BlockPos pos;
    protected Direction side;
    protected Vec3 hitPos;
    protected InteractionHand hand;
    protected Direction[] directions;

    public SpawnerAction() {
    }

    public SpawnerAction(BlockPos pos, Direction side, Vec3 hitPos, InteractionHand hand, Direction[] directions) {
        this.pos = pos;
        this.side = side;
        this.hitPos = hitPos;
        this.hand = hand;
        this.directions = directions;
    }

    public SpawnerAction toAbsolute(BlockPos pos, Rotation rotation, Mirror mirror) {
        return new SpawnerAction(SpawnerBlockEntity.mirror(this.getPos().m_7954_(rotation), mirror).m_141952_((Vec3i)pos), SpawnerBlockEntity.mirror(rotation.m_55954_(this.getSide()), mirror), SpawnerBlockEntity.mirror(SpawnerAction.rotate(rotation, this.getHitPos()), mirror).m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), this.getHand(), this.getDirections());
    }

    public static Vec3 rotate(Rotation rotation, Vec3 position) {
        switch (rotation) {
            default: {
                return position;
            }
            case CLOCKWISE_90: {
                return new Vec3(-position.m_7094_(), position.m_7098_(), position.m_7096_());
            }
            case CLOCKWISE_180: {
                return new Vec3(-position.m_7096_(), position.m_7098_(), -position.m_7094_());
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new Vec3(position.m_7094_(), position.m_7098_(), -position.m_7096_());
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getSide() {
        return this.side;
    }

    public Vec3 getHitPos() {
        return this.hitPos;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public Direction[] getDirections() {
        return this.directions;
    }

    public boolean execute(Level world, ItemStack stack) {
        if (stack.m_41720_() instanceof ThrowablePotionItem) {
            return this.applyPotionOverride(world, stack);
        }
        if (stack.m_41720_() instanceof SpawnEggItem) {
            return this.applyEggOverride(world, stack);
        }
        stack.m_41661_((UseOnContext)new SpawnerUsageContext(world, stack, this));
        return true;
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128356_("Pos", this.getPos().m_121878_());
        nbt.m_128405_("Side", this.getSide().ordinal());
        nbt.m_128347_("HitPosX", this.getHitPos().f_82479_);
        nbt.m_128347_("HitPosY", this.getHitPos().f_82480_);
        nbt.m_128347_("HitPosZ", this.getHitPos().f_82481_);
        nbt.m_128405_("Hand", this.getHand().ordinal());
        nbt.m_128385_("Directions", Arrays.stream(this.getDirections()).mapToInt(Enum::ordinal).toArray());
        return nbt;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        this.pos = BlockPos.m_122022_((long)nbt.m_128454_("Pos"));
        this.side = Direction.values()[nbt.m_128451_("Side")];
        this.hitPos = new Vec3(nbt.m_128459_("HitPosX"), nbt.m_128459_("HitPosY"), nbt.m_128459_("HitPosZ"));
        this.hand = InteractionHand.values()[nbt.m_128451_("Hand")];
        this.directions = (Direction[])Arrays.stream(nbt.m_128465_("Directions")).mapToObj(i -> Direction.values()[i]).toArray(Direction[]::new);
    }

    public boolean applyPotionOverride(Level world, ItemStack stack) {
        ThrownPotion potion = new ThrownPotion(world, this.getHitPos().m_7096_(), this.getHitPos().m_7098_(), this.getHitPos().m_7094_());
        potion.m_37446_(stack);
        world.m_7967_((Entity)potion);
        return true;
    }

    public boolean applyEggOverride(Level world, ItemStack stack) {
        BlockEntity blockEntity;
        BlockState blockState = world.m_8055_(this.getPos());
        EntityType entityType = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
        if (blockState.m_60713_(Blocks.f_50085_) && (blockEntity = world.m_7702_(this.getPos())) instanceof net.minecraft.world.level.block.entity.SpawnerBlockEntity) {
            BaseSpawner mobSpawnerLogic = ((net.minecraft.world.level.block.entity.SpawnerBlockEntity)blockEntity).m_59801_();
            mobSpawnerLogic.m_45462_(entityType);
            blockEntity.m_6596_();
            world.m_7260_(this.getPos(), blockState, blockState, 3);
            stack.m_41774_(1);
            return true;
        }
        BlockPos blockPos3 = blockState.m_60812_((BlockGetter)world, this.getPos()).m_83281_() ? this.getPos() : this.getPos().m_142300_(this.getSide());
        EntityType entityType2 = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
        Entity entity = entityType2.m_20655_((ServerLevel)world, stack.m_41783_(), stack.m_41788_() ? stack.m_41786_() : null, null, blockPos3, MobSpawnType.SPAWN_EGG, true, !Objects.equals(this.getPos(), blockPos3) && this.getSide() == Direction.UP);
        boolean isMob = entity instanceof Mob;
        if (entity != null && !world.m_45772_(entity.m_142469_())) {
            entity = null;
        }
        if (entity != null) {
            ((ServerLevel)world).m_47205_(entity);
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SpawnerAction)) {
            return false;
        }
        SpawnerAction action = (SpawnerAction)other;
        return this.getPos().equals((Object)action.getPos()) && this.getSide() == action.getSide();
    }

    public int hashCode() {
        return this.getSide().ordinal() * 31 + this.getPos().hashCode();
    }
}

