/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.item;

import iskallia.ispawner.block.SpawnerBlock;
import iskallia.ispawner.block.entity.SpawnerBlockEntity;
import iskallia.ispawner.screen.SpawnerControllerScreen;
import iskallia.ispawner.world.spawner.SpawnerAction;
import iskallia.ispawner.world.spawner.SpawnerController;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpawnerControllerItem
extends Item {
    public SpawnerControllerItem(Item.Properties settings) {
        super(settings);
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player player) {
        if (!world.f_46443_) {
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            SpawnerController controller = new SpawnerController(stack.m_41698_("Controller"));
            BlockHitResult context = SpawnerControllerItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (controller.getMode() == SpawnerController.Mode.SPAWNING_SPACES) {
                controller.getTarget().ifPresent(spawnerPos -> {
                    BlockEntity blockEntity = world.m_7702_(spawnerPos);
                    if (!(blockEntity instanceof SpawnerBlockEntity)) {
                        return;
                    }
                    SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
                    Rotation rotation = spawner.getReverseRotation();
                    BlockPos offset = pos.m_141950_((Vec3i)spawner.getCenterPos());
                    spawner.manager.addAction(new SpawnerAction(SpawnerBlockEntity.mirror(offset, spawner.getMirror()).m_7954_(rotation), SpawnerBlockEntity.mirror(rotation.m_55954_(context.m_82434_()), spawner.getMirror()), context.m_82450_(), InteractionHand.MAIN_HAND, Direction.m_122382_((Entity)player)), -1);
                    spawner.sendClientUpdates();
                });
            }
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (context.m_43725_().f_46443_ || context.m_43723_() == null) {
            return InteractionResult.SUCCESS;
        }
        SpawnerController controller = new SpawnerController(context.m_43722_().m_41698_("Controller"));
        if (state.m_60734_() instanceof SpawnerBlock && !context.m_8083_().equals(controller.getTarget().orElse(null))) {
            controller.setTarget(context.m_8083_());
            if (context.m_43723_() != null) {
                context.m_43723_().m_5661_((Component)new TextComponent("Bound to spawner.").m_130940_(ChatFormatting.GREEN), true);
            }
        } else {
            controller.getTarget().ifPresent(spawnerPos -> {
                BlockEntity blockEntity = context.m_43725_().m_7702_(spawnerPos);
                if (!(blockEntity instanceof SpawnerBlockEntity)) {
                    return;
                }
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
                if (controller.getMode() == SpawnerController.Mode.SPAWNING_SPACES) {
                    Rotation rotation = spawner.getReverseRotation();
                    BlockPos offset = context.m_8083_().m_141950_((Vec3i)spawner.getCenterPos());
                    Vec3 hitPosOffset = context.m_43720_().m_82492_((double)spawner.getCenterPos().m_123341_(), (double)spawner.getCenterPos().m_123342_(), (double)spawner.getCenterPos().m_123343_());
                    spawner.manager.addAction(new SpawnerAction(SpawnerBlockEntity.mirror(offset, spawner.getMirror()).m_7954_(rotation), rotation.m_55954_(SpawnerBlockEntity.mirror(context.m_43719_(), spawner.getMirror())), SpawnerAction.rotate(rotation, SpawnerBlockEntity.mirror(hitPosOffset, spawner.getMirror())), context.m_43724_(), Direction.m_122382_((Entity)context.m_43723_())), 1);
                    spawner.sendClientUpdates();
                } else if (controller.getMode() == SpawnerController.Mode.RELOCATOR) {
                    Rotation rotation = spawner.getReverseRotation();
                    BlockPos offset = context.m_8083_().m_141950_((Vec3i)spawner.m_58899_());
                    spawner.setOffset(SpawnerBlockEntity.mirror(offset.m_7954_(rotation), spawner.getMirror()));
                    spawner.sendClientUpdates();
                }
            });
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        SpawnerController controller = new SpawnerController(stack.m_41698_("Controller"));
        if (player.m_6144_()) {
            if (world.f_46443_) {
                this.openScreen(controller);
            }
        } else if (controller.getMode() == SpawnerController.Mode.SPAWN_REMOTE && !world.f_46443_) {
            controller.getTarget().ifPresent(spawnerPos -> {
                BlockEntity blockEntity = world.m_7702_(spawnerPos);
                if (!(blockEntity instanceof SpawnerBlockEntity)) {
                    return;
                }
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
                spawner.manager.spawn(world, world.m_5822_(), spawner);
                player.m_5661_((Component)new TextComponent("Spawned mobs.").m_130940_(ChatFormatting.GREEN), true);
            });
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openScreen(SpawnerController controller) {
        Minecraft.m_91087_().m_91346_((Screen)new SpawnerControllerScreen((Component)new TextComponent("Spawner Controller"), controller));
    }
}

