/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.block.entity;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import iskallia.ispawner.block.SpawnerBlock;
import iskallia.ispawner.block.entity.BaseBlockEntity;
import iskallia.ispawner.init.ModBlocks;
import iskallia.ispawner.inventory.SimpleInventory;
import iskallia.ispawner.screen.handler.SpawnerScreenHandler;
import iskallia.ispawner.world.spawner.SpawnerManager;
import iskallia.ispawner.world.spawner.SpawnerRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SpawnerBlockEntity
extends BaseBlockEntity
implements ExtendedMenuProvider,
MenuProvider,
ContainerListener {
    public final SimpleInventory inventory;
    public SpawnerManager manager = new SpawnerManager();
    public SpawnerRenderer renderer = new SpawnerRenderer();
    public BlockPos offset = BlockPos.f_121853_;

    public SpawnerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlocks.Entities.SPAWNER.get(), pos, state);
    }

    public SpawnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = this.createInventory();
        this.inventory.addListener(this);
    }

    protected SimpleInventory createInventory() {
        return new SimpleInventory(27);
    }

    public final SimpleInventory getInventory() {
        return this.inventory;
    }

    @Override
    public CompoundTag write(CompoundTag tag, BaseBlockEntity.UpdateType type) {
        tag.m_128365_("Inventory", (Tag)this.getInventory().writeToNBT());
        tag.m_128365_("Manager", (Tag)this.manager.writeToNBT());
        tag.m_128365_("Offset", (Tag)NbtUtils.m_129224_((BlockPos)this.offset));
        return tag;
    }

    @Override
    public void read(CompoundTag tag, BaseBlockEntity.UpdateType type) {
        if (tag.m_128425_("Inventory", 10)) {
            this.getInventory().readFromNBT(tag.m_128469_("Inventory"));
        }
        if (tag.m_128425_("Manager", 10)) {
            this.manager.readFromNBT(tag.m_128469_("Manager"));
        }
        this.offset = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Offset"));
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        buf.m_130064_(this.m_58899_());
    }

    public static void tick(Level world, BlockPos pos, BlockState state, SpawnerBlockEntity spawner) {
        if (world == null || world.m_5776_()) {
            return;
        }
        spawner.manager.tick(world, world.m_5822_(), spawner);
    }

    public void m_5757_(Container sender) {
        this.sendClientUpdates();
    }

    public Component m_5446_() {
        return new TranslatableComponent("container.spawner");
    }

    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return player.m_7500_() ? new SpawnerScreenHandler(syncId, inv, this) : null;
    }

    public boolean canUseCharge(ItemStack stack, int index) {
        return true;
    }

    public void onChargeUsed(ItemStack stack, int index) {
    }

    public BlockPos getOffset() {
        return SpawnerBlockEntity.mirror(this.offset.m_7954_(this.getRotation()), this.getMirror());
    }

    public void setOffset(BlockPos offset) {
        this.offset = offset;
    }

    public BlockPos getCenterPos() {
        return this.m_58899_().m_141952_((Vec3i)this.getOffset());
    }

    public Rotation getRotation() {
        if (this.m_58904_() != null) {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)SpawnerBlock.FACING);
            if (facing == Direction.NORTH) {
                return Rotation.NONE;
            }
            if (facing == Direction.SOUTH) {
                return Rotation.CLOCKWISE_180;
            }
            if (facing == Direction.WEST) {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            if (facing == Direction.EAST) {
                return Rotation.CLOCKWISE_90;
            }
        }
        return null;
    }

    public Rotation getReverseRotation() {
        Rotation rotation = this.getRotation();
        if (rotation == Rotation.NONE) {
            return Rotation.NONE;
        }
        if (rotation == Rotation.CLOCKWISE_90) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return Rotation.CLOCKWISE_180;
        }
        if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            return Rotation.CLOCKWISE_90;
        }
        return null;
    }

    public Mirror getMirror() {
        return ((SpawnerBlock.Mirror)((Object)this.m_58900_().m_61143_(SpawnerBlock.MIRROR))).toBlockMirror();
    }

    public static BlockPos mirror(BlockPos pos, SpawnerBlock.Mirror mirror) {
        return switch (mirror) {
            default -> throw new IncompatibleClassChangeError();
            case SpawnerBlock.Mirror.FRONT_BACK -> new BlockPos(-pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            case SpawnerBlock.Mirror.LEFT_RIGHT -> new BlockPos(pos.m_123341_(), pos.m_123342_(), -pos.m_123343_());
            case SpawnerBlock.Mirror.NONE -> pos;
        };
    }

    public static BlockPos mirror(BlockPos pos, Mirror mirror) {
        return switch (mirror) {
            default -> throw new IncompatibleClassChangeError();
            case Mirror.FRONT_BACK -> new BlockPos(-pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            case Mirror.LEFT_RIGHT -> new BlockPos(pos.m_123341_(), pos.m_123342_(), -pos.m_123343_());
            case Mirror.NONE -> pos;
        };
    }

    public static Direction mirror(Direction facing, Mirror mirror) {
        if (facing.m_122434_() == Direction.Axis.X && mirror == Mirror.FRONT_BACK || facing.m_122434_() == Direction.Axis.Z && mirror == Mirror.LEFT_RIGHT) {
            return facing.m_122424_();
        }
        return facing;
    }

    public static Vec3 mirror(Vec3 pos, Mirror mirror) {
        return switch (mirror) {
            default -> throw new IncompatibleClassChangeError();
            case Mirror.FRONT_BACK -> new Vec3(-pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
            case Mirror.LEFT_RIGHT -> new Vec3(pos.m_7096_(), pos.m_7098_(), -pos.m_7094_());
            case Mirror.NONE -> pos;
        };
    }
}

