/*
 * Decompiled with CFR 0.152.
 */
package iskallia.ispawner.block;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import iskallia.ispawner.block.SpawnerRotation;
import iskallia.ispawner.block.entity.SpawnerBlockEntity;
import iskallia.ispawner.init.ModBlocks;
import iskallia.ispawner.init.ModItems;
import iskallia.ispawner.world.spawner.SpawnerSettings;
import java.util.Locale;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class SpawnerBlock
extends BaseEntityBlock
implements WorldlyContainerHolder {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Mirror> MIRROR = EnumProperty.m_61587_((String)"mirror", Mirror.class);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public SpawnerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(MIRROR, (Comparable)((Object)Mirror.NONE))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, MIRROR, POWERED});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        int index = SpawnerRotation.getIndex(this.toRotation((Direction)state.m_61143_((Property)FACING)), ((Mirror)((Object)state.m_61143_(MIRROR))).toBlockMirror());
        index = SpawnerRotation.multiply(index, rotation, net.minecraft.world.level.block.Mirror.NONE);
        return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)this.toFacing(SpawnerRotation.getRotation(index)))).m_61124_(MIRROR, (Comparable)((Object)Mirror.fromBlockMirror(SpawnerRotation.getMirror(index))));
    }

    public BlockState m_6943_(BlockState state, net.minecraft.world.level.block.Mirror mirror) {
        int index = SpawnerRotation.getIndex(this.toRotation((Direction)state.m_61143_((Property)FACING)), ((Mirror)((Object)state.m_61143_(MIRROR))).toBlockMirror());
        index = SpawnerRotation.multiply(index, Rotation.NONE, mirror);
        return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)this.toFacing(SpawnerRotation.getRotation(index)))).m_61124_(MIRROR, (Comparable)((Object)Mirror.fromBlockMirror(SpawnerRotation.getMirror(index))));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public Rotation toRotation(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> Rotation.NONE;
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            default -> throw new UnsupportedOperationException();
        };
    }

    public Direction toFacing(Rotation rotation) {
        return switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> Direction.NORTH;
            case Rotation.CLOCKWISE_180 -> Direction.SOUTH;
            case Rotation.COUNTERCLOCKWISE_90 -> Direction.WEST;
            case Rotation.CLOCKWISE_90 -> Direction.EAST;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_41720_() == ModItems.SPAWNER_CONTROLLER.get()) {
            return InteractionResult.PASS;
        }
        if (world.m_5776_() || !(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        this.openMenu(state, world, pos, (ServerPlayer)player);
        return InteractionResult.CONSUME;
    }

    protected void openMenu(BlockState state, Level world, BlockPos pos, ServerPlayer player) {
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof ExtendedMenuProvider) {
            MenuRegistry.openExtendedMenu((ServerPlayer)player, (ExtendedMenuProvider)((ExtendedMenuProvider)be));
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SpawnerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return SpawnerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlocks.Entities.SPAWNER.get()), SpawnerBlockEntity::tick);
    }

    public WorldlyContainer m_5840_(BlockState state, LevelAccessor world, BlockPos pos) {
        return null;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        boolean powered = world.m_46753_(pos);
        if (powered != (Boolean)state.m_61143_((Property)POWERED)) {
            if (powered) {
                this.onPowered(world, pos);
            }
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    private void onPowered(Level world, BlockPos pos) {
        if (world.m_5776_()) {
            return;
        }
        world.m_142572_().execute(() -> {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
                if (spawner.manager.settings.getMode() == SpawnerSettings.Mode.REDSTONE_PULSE) {
                    spawner.manager.spawn(world, world.f_46441_, spawner);
                }
            }
        });
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() || blockEntity instanceof SpawnerBlockEntity && ((SpawnerBlockEntity)blockEntity).manager.settings.getMode() == SpawnerSettings.Mode.ALWAYS_ON) {
            for (int i = 0; i < 5; ++i) {
                double x = (double)pos.m_123341_() + world.f_46441_.nextDouble();
                double y = (double)pos.m_123342_() + world.f_46441_.nextDouble();
                double z = (double)pos.m_123343_() + world.f_46441_.nextDouble();
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
        super.m_7100_(state, world, pos, random);
    }

    public static enum Mirror implements StringRepresentable
    {
        NONE,
        LEFT_RIGHT,
        FRONT_BACK;


        public net.minecraft.world.level.block.Mirror toBlockMirror() {
            return net.minecraft.world.level.block.Mirror.values()[this.ordinal()];
        }

        public static Mirror fromBlockMirror(net.minecraft.world.level.block.Mirror blockMirror) {
            return Mirror.values()[blockMirror.ordinal()];
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

