/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.ping.network.packet;

import dmillerw.ping.data.PingWrapper;
import dmillerw.ping.network.PacketHandler;
import dmillerw.ping.network.packet.ServerBroadcastPing;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ClientSendPing {
    private PingWrapper ping;

    public ClientSendPing(PingWrapper ping) {
        this.ping = ping;
    }

    public static void encode(ClientSendPing pingPacket, FriendlyByteBuf buf) {
        pingPacket.ping.writeToBuffer((ByteBuf)buf);
    }

    public static ClientSendPing decode(FriendlyByteBuf buf) {
        return new ClientSendPing(PingWrapper.readFromBuffer((ByteBuf)buf));
    }

    public static class Handler {
        public static void handle(ClientSendPing message, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer playerMP = ctx.get().getSender();
            if (playerMP != null && !(playerMP instanceof FakePlayer)) {
                for (Player player : playerMP.f_19853_.m_6907_()) {
                    if (!(player instanceof ServerPlayer)) continue;
                    PacketHandler.CHANNEL.sendTo((Object)new ServerBroadcastPing(message.ping), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
                ctx.get().setPacketHandled(true);
            }
        }
    }
}

