/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.ping.data;

import dmillerw.ping.data.PingType;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;

public class PingWrapper {
    private static final float OFFSET = 1.0f;
    public final BlockPos pos;
    public final int color;
    public final PingType type;
    public boolean isOffscreen = false;
    public float screenX;
    public float screenY;
    public int animationTimer = 20;
    public int timer;

    public PingWrapper(BlockPos pos, int color, PingType type) {
        this.pos = pos;
        this.color = color;
        this.type = type;
    }

    public AABB getAABB() {
        return new AABB((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), (double)((float)this.pos.m_123341_() + 1.0f), (double)((float)this.pos.m_123342_() + 1.0f), (double)((float)this.pos.m_123343_() + 1.0f));
    }

    public static PingWrapper readFromBuffer(ByteBuf buffer) {
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        int color = buffer.readInt();
        PingType type = PingType.values()[buffer.readInt()];
        return new PingWrapper(new BlockPos(x, y, z), color, type);
    }

    public void writeToBuffer(ByteBuf buffer) {
        buffer.writeInt(this.pos.m_123341_());
        buffer.writeInt(this.pos.m_123342_());
        buffer.writeInt(this.pos.m_123343_());
        buffer.writeInt(this.color);
        buffer.writeInt(this.type.ordinal());
    }
}

