/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.logger;

import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;

public class Logging {
    private static final String NAME = "drippyloadingscreen";
    public static boolean printWarnings = true;
    public static boolean printErrors = true;
    public static boolean printInfos = true;

    public static void init() {
        printWarnings = (Boolean)DrippyLoadingScreen.config.getOrDefault("printwarnings", (Object)true);
    }

    public static void warn(String ... out) {
        if (printWarnings) {
            Logging.printMultiline("WARNING", out);
        }
    }

    public static void error(String ... out) {
        if (printErrors) {
            Logging.printMultiline("ERROR", out);
        }
    }

    public static void info(String ... out) {
        if (printInfos) {
            Logging.printMultiline("INFO", out);
        }
    }

    public static void printMultiline(String type, String ... out) {
        String head = "############# " + type + " : drippyloadingscreen #############";
        Object tail = "";
        for (int i = 0; i < head.length(); ++i) {
            tail = (String)tail + "#";
        }
        System.out.println(head);
        for (String s : out) {
            System.out.println(s);
        }
        System.out.println((String)tail);
    }

    public static void print(String out) {
        System.out.println("[drippyloadingscreen] " + out);
    }
}

