/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items.custombars;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.drippyloadingscreen.customization.items.custombars.CustomBarCustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.SplashCustomizationLayer;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import net.minecraft.resources.ResourceLocation;

public class CustomProgressBarCustomizationItem
extends CustomBarCustomizationItemBase {
    protected int currentPercentWidthHeight = 0;

    public CustomProgressBarCustomizationItem(PropertiesSection item) {
        super(item);
        this.value = "Custom Progress Bar";
    }

    @Override
    public void init(PropertiesSection item) {
        super.init(item);
        boolean b = false;
        if (this.barColorHex == null) {
            this.barColorHex = "#ffffff";
            b = true;
        }
        if (this.backgroundColorHex == null) {
            this.backgroundColorHex = "#5c5c5c80";
            b = true;
        }
        if (b) {
            this.updateItem();
        }
    }

    @Override
    public void render(PoseStack matrix) {
        if (!this.shouldRender()) {
            return;
        }
        float progressPercent = SplashCustomizationLayer.getInstance().currentProgress * 100.0f;
        if (this.isEditor() || SplashCustomizationLayer.isCustomizationHelperScreen()) {
            progressPercent = 50.0f;
        }
        if (this.direction == CustomBarCustomizationItemBase.BarDirection.LEFT || this.direction == CustomBarCustomizationItemBase.BarDirection.RIGHT) {
            this.currentPercentWidthHeight = (int)((float)this.width / 100.0f * progressPercent);
        }
        if (this.direction == CustomBarCustomizationItemBase.BarDirection.UP || this.direction == CustomBarCustomizationItemBase.BarDirection.DOWN) {
            this.currentPercentWidthHeight = (int)((float)this.height / 100.0f * progressPercent);
        }
        this.renderBarBackground(matrix);
        this.renderBar(matrix);
    }

    @Override
    protected void renderBar(PoseStack matrix) {
        if (this.direction == CustomBarCustomizationItemBase.BarDirection.RIGHT) {
            this.progressEndX = this.getPosX() + this.currentPercentWidthHeight;
            this.progressEndY = this.getPosY() + this.height / 2;
        }
        if (this.direction == CustomBarCustomizationItemBase.BarDirection.LEFT) {
            this.progressEndX = this.getPosX() + this.width - this.currentPercentWidthHeight;
            this.progressEndY = this.getPosY() + this.height / 2;
        }
        if (this.direction == CustomBarCustomizationItemBase.BarDirection.UP) {
            this.progressEndX = this.getPosX() + this.width / 2;
            this.progressEndY = this.getPosY() + this.height - this.currentPercentWidthHeight;
        }
        if (this.direction == CustomBarCustomizationItemBase.BarDirection.DOWN) {
            this.progressEndX = this.getPosX() + this.width / 2;
            this.progressEndY = this.getPosY() + this.currentPercentWidthHeight;
        }
        if (this.barTexture == null) {
            RenderSystem.m_69478_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.direction == CustomBarCustomizationItemBase.BarDirection.RIGHT) {
                RenderUtils.fill((PoseStack)matrix, (float)this.getPosX(), (float)this.getPosY(), (float)(this.getPosX() + this.currentPercentWidthHeight), (float)(this.getPosY() + this.height), (int)this.barColor.getRGB(), (float)this.opacity);
            }
            if (this.direction == CustomBarCustomizationItemBase.BarDirection.LEFT) {
                RenderUtils.fill((PoseStack)matrix, (float)(this.getPosX() + this.width - this.currentPercentWidthHeight), (float)this.getPosY(), (float)(this.getPosX() + this.width), (float)(this.getPosY() + this.height), (int)this.barColor.getRGB(), (float)this.opacity);
            }
            if (this.direction == CustomBarCustomizationItemBase.BarDirection.UP) {
                RenderUtils.fill((PoseStack)matrix, (float)this.getPosX(), (float)(this.getPosY() + this.height - this.currentPercentWidthHeight), (float)(this.getPosX() + this.width), (float)(this.getPosY() + this.height), (int)this.barColor.getRGB(), (float)this.opacity);
            }
            if (this.direction == CustomBarCustomizationItemBase.BarDirection.DOWN) {
                RenderUtils.fill((PoseStack)matrix, (float)this.getPosX(), (float)this.getPosY(), (float)(this.getPosX() + this.width), (float)(this.getPosY() + this.currentPercentWidthHeight), (int)this.barColor.getRGB(), (float)this.opacity);
            }
        } else {
            int i;
            RenderUtils.bindTexture((ResourceLocation)this.barTexture);
            RenderSystem.m_69478_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
            if (this.direction == CustomBarCustomizationItemBase.BarDirection.RIGHT) {
                CustomProgressBarCustomizationItem.m_93133_((PoseStack)matrix, (int)this.getPosX(), (int)this.getPosY(), (float)0.0f, (float)0.0f, (int)this.currentPercentWidthHeight, (int)this.height, (int)this.width, (int)this.height);
            }
            if (this.direction == CustomBarCustomizationItemBase.BarDirection.LEFT) {
                i = this.width - this.currentPercentWidthHeight;
                CustomProgressBarCustomizationItem.m_93133_((PoseStack)matrix, (int)(this.getPosX() + i), (int)this.getPosY(), (float)i, (float)0.0f, (int)this.currentPercentWidthHeight, (int)this.height, (int)this.width, (int)this.height);
            }
            if (this.direction == CustomBarCustomizationItemBase.BarDirection.UP) {
                i = this.height - this.currentPercentWidthHeight;
                CustomProgressBarCustomizationItem.m_93133_((PoseStack)matrix, (int)this.getPosX(), (int)(this.getPosY() + i), (float)0.0f, (float)i, (int)this.width, (int)this.currentPercentWidthHeight, (int)this.width, (int)this.height);
            }
            if (this.direction == CustomBarCustomizationItemBase.BarDirection.DOWN) {
                CustomProgressBarCustomizationItem.m_93133_((PoseStack)matrix, (int)this.getPosX(), (int)this.getPosY(), (float)0.0f, (float)0.0f, (int)this.width, (int)this.currentPercentWidthHeight, (int)this.width, (int)this.height);
            }
            RenderSystem.m_69461_();
        }
    }

    @Override
    protected void renderBarBackground(PoseStack matrix) {
        if (this.backgroundTexture == null) {
            RenderSystem.m_69478_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.fill((PoseStack)matrix, (float)this.getPosX(), (float)this.getPosY(), (float)(this.getPosX() + this.width), (float)(this.getPosY() + this.height), (int)this.backgroundColor.getRGB(), (float)this.opacity);
        } else {
            RenderUtils.bindTexture((ResourceLocation)this.backgroundTexture);
            RenderSystem.m_69478_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
            CustomProgressBarCustomizationItem.m_93133_((PoseStack)matrix, (int)this.getPosX(), (int)this.getPosY(), (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
            RenderSystem.m_69461_();
        }
    }
}

