/*
 * Decompiled with CFR 0.152.
 */
package vazkii.akashictome;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import vazkii.akashictome.AkashicTome;
import vazkii.akashictome.ConfigHandler;
import vazkii.akashictome.ModItems;
import vazkii.akashictome.network.MessageUnmorphTome;
import vazkii.arl.util.ItemNBTHelper;

public final class MorphingHandler {
    public static final MorphingHandler INSTANCE = new MorphingHandler();
    public static final String MINECRAFT = "minecraft";
    public static final String TAG_MORPHING = "akashictome:is_morphing";
    public static final String TAG_TOME_DATA = "akashictome:data";
    public static final String TAG_TOME_DISPLAY_NAME = "akashictome:displayName";
    public static final String TAG_ITEM_DEFINED_MOD = "akashictome:definedMod";
    private static final Map<String, String> modNames = new HashMap<String, String>();

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_41619_() && MorphingHandler.isAkashicTome(stack) && stack.m_41720_() != ModItems.tome) {
            AkashicTome.sendToServer(new MessageUnmorphTome());
        }
    }

    @SubscribeEvent
    public void onItemDropped(ItemTossEvent event) {
        if (!event.getPlayer().m_20163_()) {
            return;
        }
        ItemEntity e = event.getEntityItem();
        ItemStack stack = e.m_32055_();
        if (!stack.m_41619_() && MorphingHandler.isAkashicTome(stack) && stack.m_41720_() != ModItems.tome) {
            ItemStack copy;
            CompoundTag copyCmp;
            CompoundTag morphData = stack.m_41783_().m_128469_(TAG_TOME_DATA).m_6426_();
            String currentMod = ItemNBTHelper.getString((ItemStack)stack, (String)TAG_ITEM_DEFINED_MOD, (String)MorphingHandler.getModFromStack(stack));
            ItemStack morph = MorphingHandler.makeMorphedStack(stack, MINECRAFT, morphData);
            CompoundTag newMorphData = morph.m_41783_().m_128469_(TAG_TOME_DATA);
            newMorphData.m_128473_(currentMod);
            if (!e.m_20193_().f_46443_) {
                ItemEntity newItem = new ItemEntity(e.m_20193_(), e.m_20185_(), e.m_20186_(), e.m_20189_(), morph);
                e.m_20193_().m_7967_((Entity)newItem);
            }
            if ((copyCmp = (copy = stack.m_41777_()).m_41783_()) == null) {
                copyCmp = new CompoundTag();
                copy.m_41751_(copyCmp);
            }
            copyCmp.m_128473_("display");
            TextComponent displayName = null;
            CompoundTag nameCmp = (CompoundTag)copyCmp.m_128423_(TAG_TOME_DISPLAY_NAME);
            if (nameCmp != null) {
                displayName = new TextComponent(nameCmp.m_128461_("text"));
            }
            if (displayName != null && !displayName.getString().isEmpty() && displayName != copy.m_41786_()) {
                copy.m_41714_((Component)displayName);
            }
            copyCmp.m_128473_(TAG_MORPHING);
            copyCmp.m_128473_(TAG_TOME_DISPLAY_NAME);
            copyCmp.m_128473_(TAG_TOME_DATA);
            e.m_32045_(copy);
        }
    }

    public static String getModFromState(BlockState state) {
        return MorphingHandler.getModOrAlias(state.m_60734_().getRegistryName().m_135827_());
    }

    public static String getModFromStack(ItemStack stack) {
        return MorphingHandler.getModOrAlias(stack.m_41619_() ? MINECRAFT : stack.m_41720_().getCreatorModId(stack));
    }

    public static String getModOrAlias(String mod) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        for (String s : (List)ConfigHandler.aliasesList.get()) {
            if (!s.matches(".+?=.+")) continue;
            String[] tokens = s.toLowerCase().split("=");
            aliases.put(tokens[0], tokens[1]);
        }
        return aliases.getOrDefault(mod, mod);
    }

    public static boolean doesStackHaveModAttached(ItemStack stack, String mod) {
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag morphData = stack.m_41783_().m_128469_(TAG_TOME_DATA);
        return morphData.m_128441_(mod);
    }

    public static ItemStack getShiftStackForMod(ItemStack stack, String mod) {
        if (!stack.m_41782_()) {
            return stack;
        }
        String currentMod = MorphingHandler.getModFromStack(stack);
        String defined = ItemNBTHelper.getString((ItemStack)stack, (String)TAG_ITEM_DEFINED_MOD, (String)"");
        if (!defined.isEmpty()) {
            currentMod = defined;
        }
        if (mod.equals(currentMod)) {
            return stack;
        }
        CompoundTag morphData = stack.m_41783_().m_128469_(TAG_TOME_DATA);
        return MorphingHandler.makeMorphedStack(stack, mod, morphData);
    }

    public static ItemStack makeMorphedStack(ItemStack currentStack, String targetMod, CompoundTag morphData) {
        ItemStack stack;
        String currentMod = MorphingHandler.getModFromStack(currentStack);
        String defined = ItemNBTHelper.getString((ItemStack)currentStack, (String)TAG_ITEM_DEFINED_MOD, (String)"");
        if (!defined.isEmpty()) {
            currentMod = defined;
        }
        CompoundTag currentCmp = new CompoundTag();
        currentStack.m_41739_(currentCmp);
        currentCmp = currentCmp.m_6426_();
        if (currentCmp.m_128441_("tag")) {
            currentCmp.m_128469_("tag").m_128473_(TAG_TOME_DATA);
        }
        if (!currentMod.equalsIgnoreCase(MINECRAFT) && !currentMod.equalsIgnoreCase("akashictome")) {
            morphData.m_128365_(currentMod, (Tag)currentCmp);
        }
        if (targetMod.equals(MINECRAFT)) {
            stack = new ItemStack((ItemLike)ModItems.tome);
        } else {
            CompoundTag targetCmp = morphData.m_128469_(targetMod);
            morphData.m_128473_(targetMod);
            stack = ItemStack.m_41712_((CompoundTag)targetCmp);
            if (stack.m_41619_()) {
                stack = new ItemStack((ItemLike)ModItems.tome);
            }
        }
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag stackCmp = stack.m_41783_();
        stackCmp.m_128365_(TAG_TOME_DATA, (Tag)morphData);
        stackCmp.m_128379_(TAG_MORPHING, true);
        if (stack.m_41720_() != ModItems.tome) {
            CompoundTag displayName;
            CompoundTag ogDisplayName = displayName = new CompoundTag();
            displayName.m_128359_("text", Component.Serializer.m_130703_((Component)stack.m_41786_()));
            if (stackCmp.m_128441_(TAG_TOME_DISPLAY_NAME)) {
                displayName = (CompoundTag)stackCmp.m_128423_(TAG_TOME_DISPLAY_NAME);
            } else {
                stackCmp.m_128365_(TAG_TOME_DISPLAY_NAME, (Tag)displayName);
            }
            MutableComponent rawComp = Component.Serializer.m_130701_((String)displayName.m_128461_("text"));
            if (rawComp == null) {
                stackCmp.m_128365_(TAG_TOME_DISPLAY_NAME, (Tag)displayName);
                displayName = ogDisplayName;
            }
            MutableComponent stackName = rawComp.m_6270_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GREEN}));
            TranslatableComponent comp = new TranslatableComponent("akashictome.sudo_name", new Object[]{stackName});
            stack.m_41714_((Component)comp);
        }
        stack.m_41764_(1);
        return stack;
    }

    public static String getModNameForId(String modId) {
        modId = modId.toLowerCase(Locale.ENGLISH);
        return modNames.getOrDefault(modId, modId);
    }

    public static boolean isAkashicTome(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_41720_() == ModItems.tome) {
            return true;
        }
        return stack.m_41782_() && stack.m_41783_().m_128471_(TAG_MORPHING);
    }

    static {
        for (IModInfo modEntry : ModList.get().getMods()) {
            modNames.put(modEntry.getModId().toLowerCase(Locale.ENGLISH), modEntry.getDisplayName());
        }
    }
}

