/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.serialization;

import com.davenonymous.libnonymous.helper.BlockStateSerializationHelper;
import com.davenonymous.libnonymous.serialization.MultiblockBlockModel;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiBlockModelSerializer
implements JsonDeserializer<MultiblockBlockModel> {
    private static final Logger LOGGER = LogManager.getLogger();

    public MultiblockBlockModel deserialize(JsonElement root, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!root.isJsonObject()) {
            return null;
        }
        JsonObject rootObj = root.getAsJsonObject();
        int version = rootObj.has("version") ? rootObj.get("version").getAsInt() : 1;
        switch (version) {
            case 1: 
            case 2: {
                LOGGER.warn("Invalid version in shape file: '{}', skipping shape! Shape files below v3 are not supported!", (Object)rootObj.get("version"));
                return null;
            }
            case 3: {
                return this.deserializeV3(rootObj, typeOfT, context);
            }
        }
        LOGGER.warn("Invalid version in shape file: '{}', skipping shape! Maybe the shape file is from a newer mod version?", (Object)rootObj.get("version"));
        return null;
    }

    private Map<String, BlockState> getReferenceMapV3(JsonObject jsonRefMap) {
        HashMap<String, BlockState> refMap = new HashMap<String, BlockState>();
        for (Map.Entry jsonRefEntry : jsonRefMap.entrySet()) {
            JsonObject jsonBlockInfo = ((JsonElement)jsonRefEntry.getValue()).getAsJsonObject();
            BlockState state = BlockStateSerializationHelper.deserializeBlockState(jsonBlockInfo);
            refMap.put((String)jsonRefEntry.getKey(), state);
        }
        return refMap;
    }

    private boolean hasUnknownBlocksInMap(JsonObject jsonRefMap) {
        for (Map.Entry jsonRefEntry : jsonRefMap.entrySet()) {
            JsonObject jsonBlockInfo = ((JsonElement)jsonRefEntry.getValue()).getAsJsonObject();
            if (BlockStateSerializationHelper.isValidBlockState(jsonBlockInfo)) continue;
            return true;
        }
        return false;
    }

    public MultiblockBlockModel deserializeV3(JsonObject root, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!root.has("type")) {
            LOGGER.warn("Missing type name in multiblockmodel json");
            return null;
        }
        ResourceLocation treeType = new ResourceLocation(root.get("type").getAsString());
        if (this.hasUnknownBlocksInMap(root.getAsJsonObject("ref"))) {
            return null;
        }
        Map<String, BlockState> refMap = this.getReferenceMapV3(root.getAsJsonObject("ref"));
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        JsonArray jsonBlocks = root.getAsJsonArray("shape");
        int x = jsonBlocks.size() - 1;
        for (JsonElement zSliceElement : jsonBlocks) {
            int y = zSliceElement.getAsJsonArray().size() - 1;
            for (JsonElement ySliceElement : zSliceElement.getAsJsonArray()) {
                for (int z = 0; z < ySliceElement.getAsString().length(); ++z) {
                    String ref = "" + ySliceElement.getAsString().charAt(z);
                    if (ref.equals(" ")) continue;
                    if (!refMap.containsKey(ref)) {
                        LOGGER.warn("Shape-Entry is using an unknown block reference '%s'! Skipping shape!", (Object)ref);
                        return null;
                    }
                    blocks.put(new BlockPos(x, y, z), refMap.get(ref));
                }
                --y;
            }
            --x;
        }
        MultiblockBlockModel result = new MultiblockBlockModel(treeType);
        result.setBlocks(blocks);
        return result;
    }
}

