/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseDataProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator generator;
    private final Type type;
    private Map<String, JsonObject> values = new HashMap<String, JsonObject>();

    public abstract void addValues();

    public abstract String getModId();

    public void add(String path, JsonObject value) {
        this.values.put(path, value);
    }

    public static float getRounded(double d) {
        DecimalFormat df = new DecimalFormat("#.##");
        DecimalFormatSymbols symbols = df.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(symbols);
        return Float.parseFloat(df.format(d));
    }

    public BaseDataProvider(DataGenerator generator, Type type) {
        this.type = type;
        this.generator = generator;
    }

    public void m_6865_(HashCache cache) throws IOException {
        this.addValues();
        this.values.forEach((s, jsonObject) -> this.saveValue(cache, (String)s, (JsonObject)jsonObject));
    }

    private void saveValue(HashCache cache, String key, JsonObject jsonObject) {
        Path mainOutput = this.generator.m_123916_();
        String pathSuffix = (this.type == Type.ASSETS ? "assets" : "data") + "/" + this.getModId() + "/" + key + ".json";
        Path outputPath = mainOutput.resolve(pathSuffix);
        try {
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)jsonObject, (Path)outputPath);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save {} to {}", (Object)this.m_6055_(), (Object)outputPath, (Object)e);
        }
    }

    public static enum Type {
        ASSETS,
        DATA;

    }
}

