/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tileentities;

import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.tileentities.OurTileEntities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EffectBlockTileEntity
extends BlockEntity {
    private BlockData renderedBlock;
    private BlockData sourceBlock;
    private EffectBlock.Mode mode = null;
    private boolean usePaste;
    private int ticks;

    public EffectBlockTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)OurTileEntities.EFFECT_BLOCK_TILE_ENTITY.get(), pos, state);
    }

    public void initializeData(BlockState curState, @Nullable BlockEntity te, BlockData replacementBlock, EffectBlock.Mode mode, boolean usePaste) {
        this.ticks = 0;
        this.sourceBlock = replacementBlock;
        this.mode = mode;
        this.usePaste = usePaste;
        this.renderedBlock = mode == EffectBlock.Mode.REPLACE ? (te instanceof ConstructionBlockTileEntity ? ((ConstructionBlockTileEntity)te).getConstructionBlockData() : TileSupport.createBlockData(curState, te)) : (te instanceof ConstructionBlockTileEntity ? ((ConstructionBlockTileEntity)te).getConstructionBlockData() : replacementBlock);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, EffectBlockTileEntity blockEntity) {
        ++blockEntity.ticks;
        if (blockEntity.ticks >= blockEntity.getLifespan()) {
            blockEntity.complete();
        }
    }

    private void complete() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.mode == null || this.renderedBlock == null) {
            return;
        }
        this.mode.onBuilderRemoved(this);
    }

    public BlockData getRenderedBlock() {
        return this.renderedBlock;
    }

    public BlockData getSourceBlock() {
        return this.sourceBlock;
    }

    public EffectBlock.Mode getReplacementMode() {
        return this.mode;
    }

    public boolean isUsingPaste() {
        return this.usePaste;
    }

    public int getTicksExisted() {
        return this.ticks;
    }

    public int getLifespan() {
        return 20;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
    }

    @Nonnull
    protected void m_183515_(CompoundTag compound) {
        if (this.mode != null && this.renderedBlock != null && this.sourceBlock != null) {
            compound.m_128405_("ticks", this.ticks);
            compound.m_128405_("mode", this.mode.ordinal());
            compound.m_128365_("replacement_block", (Tag)this.renderedBlock.serialize(true));
            compound.m_128365_("source_block", (Tag)this.sourceBlock.serialize(true));
            compound.m_128379_("use_paste", this.usePaste);
        }
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("ticks", 3) && nbt.m_128425_("mode", 3) && nbt.m_128425_("source_block", 10) && nbt.m_128425_("replacement_block", 10) && nbt.m_128441_("use_paste")) {
            this.ticks = nbt.m_128451_("ticks");
            this.mode = EffectBlock.Mode.VALUES[nbt.m_128451_("mode")];
            this.renderedBlock = BlockData.tryDeserialize(nbt.m_128469_("replacement_block"), true);
            this.sourceBlock = BlockData.tryDeserialize(nbt.m_128469_("source_block"), true);
            this.usePaste = nbt.m_128471_("use_paste");
        }
    }
}

