/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.concurrent;

import com.direwolf20.buildinggadgets.common.blocks.EffectBlock;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.PlacementTarget;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.ServerTickingScheduler;
import com.direwolf20.buildinggadgets.common.tainted.concurrent.SteppedScheduler;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.save.Undo;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public final class UndoScheduler
extends SteppedScheduler {
    private final Spliterator<Map.Entry<BlockPos, Undo.BlockInfo>> spliterator;
    private boolean lastWasSuccess;
    private final BuildContext context;
    private final IItemIndex index;

    public static UndoScheduler scheduleUndo(Undo undo, IItemIndex index, BuildContext context, int steps) {
        Preconditions.checkArgument((steps > 0 ? 1 : 0) != 0);
        UndoScheduler res = new UndoScheduler(Objects.requireNonNull(undo), Objects.requireNonNull(index), Objects.requireNonNull(context), steps);
        ServerTickingScheduler.runTicked(res);
        return res;
    }

    private UndoScheduler(Undo undo, IItemIndex index, BuildContext context, int steps) {
        super(steps);
        assert (context.getPlayer() != null);
        assert (!context.getStack().m_41619_());
        this.spliterator = undo.getUndoData().entrySet().spliterator();
        this.index = index;
        this.context = context;
    }

    @Override
    protected SteppedScheduler.StepResult advance() {
        if (!this.spliterator.tryAdvance(this::undoBlock)) {
            return SteppedScheduler.StepResult.END;
        }
        return this.lastWasSuccess ? SteppedScheduler.StepResult.SUCCESS : SteppedScheduler.StepResult.FAILURE;
    }

    private void undoBlock(Map.Entry<BlockPos, Undo.BlockInfo> entry) {
        BlockEvent.BreakEvent event;
        BlockState state = this.context.getWorld().m_8055_(entry.getKey());
        BlockEntity te = this.context.getWorld().m_7702_(entry.getKey());
        BlockData data = state.m_60734_() == OurBlocks.CONSTRUCTION_BLOCK.get() && te instanceof ConstructionBlockTileEntity ? ((ConstructionBlockTileEntity)te).getConstructionBlockData() : TileSupport.createBlockData(state, te);
        if (data.getState().m_60734_().m_49966_() != entry.getValue().getPlacedData().getState().m_60734_().m_49966_()) {
            this.lastWasSuccess = false;
            return;
        }
        if (!state.m_60795_() && MinecraftForge.EVENT_BUS.post((Event)(event = new BlockEvent.BreakEvent((Level)this.context.getServerWorld(), entry.getKey(), state, this.context.getPlayer())))) {
            this.lastWasSuccess = false;
            return;
        }
        MatchResult matchResult = this.index.tryMatch(entry.getValue().getProducedItems());
        this.lastWasSuccess = matchResult.isSuccess();
        if (this.lastWasSuccess) {
            this.index.applyMatch(matchResult);
            this.index.insert(entry.getValue().getUsedItems());
            EffectBlock.spawnUndoBlock(this.context, new PlacementTarget(entry.getKey(), entry.getValue().getRecordedData()));
        }
    }

    @Override
    protected void onFinish() {
    }
}

