/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork;

import com.lothrazar.storagenetwork.block.cable.export.GuiCableExportFilter;
import com.lothrazar.storagenetwork.block.cable.inputfilter.GuiCableImportFilter;
import com.lothrazar.storagenetwork.block.cable.linkfilter.GuiCableFilter;
import com.lothrazar.storagenetwork.block.collection.GuiCollectionFilter;
import com.lothrazar.storagenetwork.block.inventory.GuiNetworkInventory;
import com.lothrazar.storagenetwork.block.request.GuiNetworkTable;
import com.lothrazar.storagenetwork.item.remote.GuiNetworkCraftingRemote;
import com.lothrazar.storagenetwork.item.remote.GuiNetworkRemote;
import com.lothrazar.storagenetwork.registry.ClientEventRegistry;
import com.lothrazar.storagenetwork.registry.ConfigRegistry;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.lothrazar.storagenetwork.registry.SsnEvents;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypeMessage;

@Mod(value="storagenetwork")
public class StorageNetwork {
    public static final String MODID = "storagenetwork";
    public static final Logger LOGGER = LogManager.getLogger();
    public static ConfigRegistry CONFIG;

    public StorageNetwork() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(StorageNetwork::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        MinecraftForge.EVENT_BUS.register((Object)new SsnRegistry.RegistryEvents());
        MinecraftForge.EVENT_BUS.register((Object)new SsnEvents());
    }

    private static void setup(FMLCommonSetupEvent event) {
        PacketRegistry.init();
        CONFIG = new ConfigRegistry(FMLPaths.CONFIGDIR.get().resolve("storagenetwork.toml"));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("charm").size(2).build());
    }

    private void setupClient(FMLClientSetupEvent event) {
        MenuScreens.m_96206_(SsnRegistry.REQUESTCONTAINER, GuiNetworkTable::new);
        MenuScreens.m_96206_(SsnRegistry.FILTERCONTAINER, GuiCableFilter::new);
        MenuScreens.m_96206_(SsnRegistry.FILTERIMPORTCONTAINER, GuiCableImportFilter::new);
        MenuScreens.m_96206_(SsnRegistry.FILTEREXPORTCONTAINER, GuiCableExportFilter::new);
        MenuScreens.m_96206_(SsnRegistry.REMOTE, GuiNetworkRemote::new);
        MenuScreens.m_96206_(SsnRegistry.CRAFTINGREMOTE, GuiNetworkCraftingRemote::new);
        MenuScreens.m_96206_(SsnRegistry.INVENTORYCONTAINER, GuiNetworkInventory::new);
        MenuScreens.m_96206_(SsnRegistry.COLLECTORCTR, GuiCollectionFilter::new);
        ClientRegistry.registerKeyBinding((KeyMapping)ClientEventRegistry.INVENTORY_KEY);
    }

    public static void log(String s) {
        if (CONFIG.logspam()) {
            LOGGER.info(s);
        }
    }
}

