/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.blocks.tileentity;

import de.maxhenkel.easy_piglins.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easy_piglins.corelib.inventory.ItemListInventory;
import de.maxhenkel.easypiglins.blocks.BartererBlock;
import de.maxhenkel.easypiglins.blocks.ModBlocks;
import de.maxhenkel.easypiglins.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easypiglins.blocks.tileentity.PiglinTileentity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class BartererTileentity
extends PiglinTileentity
implements IServerTickableBlockEntity {
    private NonNullList<ItemStack> inputInventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private NonNullList<ItemStack> outputInventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private IItemHandlerModifiable foodInventoryHandler;
    private IItemHandlerModifiable outputInventoryHandler;

    public BartererTileentity(BlockPos pos, BlockState state) {
        super(ModTileEntities.BARTERER, ModBlocks.BARTERER.m_49966_(), pos, state);
    }

    @Override
    public void tickServer() {
        Piglin p = this.getPiglinEntity();
        if (p == null) {
            return;
        }
        if (this.f_58857_.m_46467_() % 20L == 0L && this.f_58857_.f_46441_.nextInt(40) == 0) {
            BartererBlock.playPiglinSound(this.f_58857_, this.f_58858_, SoundEvents.f_12239_);
        }
        if (this.f_58857_.m_46467_() % 120L == 0L) {
            if (this.removeBarteringItem()) {
                this.addLoot(p);
            }
            this.sync();
        }
    }

    public boolean removeBarteringItem() {
        for (ItemStack stack : this.inputInventory) {
            if (!stack.isPiglinCurrency() || stack.m_41613_() < 1) continue;
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    public ItemStack getBarteringItem() {
        for (ItemStack stack : this.inputInventory) {
            if (!stack.isPiglinCurrency() || stack.m_41613_() < 1) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private void addLoot(Piglin piglin) {
        LootTable loottable = this.f_58857_.m_142572_().m_129898_().m_79217_(BuiltInLootTables.f_78738_);
        List loot = loottable.m_79129_(new LootContext.Builder((ServerLevel)this.f_58857_).m_78972_(LootContextParams.f_81455_, (Object)piglin).m_78977_(this.f_58857_.f_46441_).m_78975_(LootContextParamSets.f_81417_));
        if (this.f_58857_.m_5822_().nextInt(5) == 0) {
            BartererBlock.playPiglinSound(this.f_58857_, this.m_58899_(), SoundEvents.f_12238_);
        }
        IItemHandlerModifiable itemHandler = this.getOutputInventoryItemHandler();
        for (ItemStack drop : loot) {
            for (int i = 0; i < itemHandler.getSlots() && !(drop = itemHandler.insertItem(i, drop, false)).m_41619_(); ++i) {
            }
        }
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("InputInventory", (Tag)ContainerHelper.m_18976_((CompoundTag)new CompoundTag(), this.inputInventory, (boolean)true));
        compound.m_128365_("OutputInventory", (Tag)ContainerHelper.m_18976_((CompoundTag)new CompoundTag(), this.outputInventory, (boolean)true));
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.inputInventory.clear();
        this.outputInventory.clear();
        ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("InputInventory"), this.inputInventory);
        ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("OutputInventory"), this.outputInventory);
        super.m_142466_(compound);
    }

    public Container getInputInventory() {
        return new ItemListInventory(this.inputInventory, () -> ((BartererTileentity)this).m_6596_());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((BartererTileentity)this).m_6596_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side.equals((Object)Direction.DOWN)) {
                return LazyOptional.of(this::getOutputInventoryItemHandler).cast();
            }
            return LazyOptional.of(this::getInputInventoryItemHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public IItemHandlerModifiable getInputInventoryItemHandler() {
        if (this.foodInventoryHandler == null) {
            this.foodInventoryHandler = new ItemStackHandler(this.inputInventory);
        }
        return this.foodInventoryHandler;
    }

    public IItemHandlerModifiable getOutputInventoryItemHandler() {
        if (this.outputInventoryHandler == null) {
            this.outputInventoryHandler = new ItemStackHandler(this.outputInventory);
        }
        return this.outputInventoryHandler;
    }
}

