/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.machine;

import cofh.core.util.helpers.RenderHelper;
import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.recipes.machine.RefineryRecipe;
import cofh.thermal.expansion.client.gui.machine.MachineRefineryScreen;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipeCategory
extends ThermalRecipeCategory<RefineryRecipe> {
    protected IDrawableStatic tankInput;
    protected IDrawableStatic tankOutputA;
    protected IDrawableStatic tankOutputB;
    protected IDrawableStatic inputOverlay;
    protected IDrawableStatic outputOverlayA;
    protected IDrawableStatic outputOverlayB;

    public RefineryRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(MachineRefineryScreen.TEXTURE, 26, 11, 124, 62).addPadding(0, 0, 16, 24).build();
        this.name = StringHelper.getTextComponent((String)TExpReferences.MACHINE_REFINERY_BLOCK.m_7705_());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(2);
        this.progressFluidBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(2);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(4);
        this.tankInput = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(2);
        this.tankOutputA = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOutputB = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.inputOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(2);
        this.outputOverlayA = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.outputOverlayB = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(2), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(2), 200, IDrawableAnimated.StartDirection.LEFT, true);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(4), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends RefineryRecipe> getRecipeClass() {
        return RefineryRecipe.class;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RefineryRecipe recipe, IFocusGroup focuses) {
        List inputFluids = recipe.getInputFluids();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(recipe.getOutputItems().size());
        List outputFluids = recipe.getOutputFluids();
        for (ItemStack stack : recipe.getOutputItems()) {
            outputs.add(ItemHelper.cloneStack((ItemStack)stack));
        }
        for (int i = 0; i < outputs.size(); ++i) {
            float chance = ((Float)recipe.getOutputItemChances().get(i)).floatValue();
            if (!(chance > 1.0f)) continue;
            ((ItemStack)outputs.get(i)).m_41764_((int)chance);
        }
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 24);
        if (!outputs.isEmpty()) {
            ((IRecipeSlotBuilder)outputSlot.addItemStack((ItemStack)outputs.get(0))).addTooltipCallback(TCoreJeiPlugin.defaultOutputTooltip((float)((Float)recipe.getOutputItemChances().get(0)).floatValue()));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 29, 6).addIngredients(VanillaTypes.FLUID, List.of(((FluidIngredient)inputFluids.get(0)).getFluids()))).setFluidRenderer(TCoreJeiPlugin.tankSize((int)4000), false, 16, 32).setOverlay((IDrawable)this.inputOverlay, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 126, 12).addIngredients(VanillaTypes.FLUID, outputFluids.isEmpty() ? Collections.emptyList() : List.of((FluidStack)outputFluids.get(0)))).setFluidRenderer(TCoreJeiPlugin.tankSize((int)8000), false, 16, 40).setOverlay((IDrawable)this.outputOverlayA, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 144, 12).addIngredients(VanillaTypes.FLUID, outputFluids.size() < 2 ? Collections.emptyList() : List.of((FluidStack)outputFluids.get(1)))).setFluidRenderer(TCoreJeiPlugin.tankSize((int)8000), false, 16, 40).setOverlay((IDrawable)this.outputOverlayB, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
    }

    public void draw(RefineryRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, recipeSlotsView, matrixStack, mouseX, mouseY);
        this.progressBackground.draw(matrixStack, 57, 22);
        this.tankInput.draw(matrixStack, 28, 5);
        this.tankOutputA.draw(matrixStack, 125, 11);
        this.tankOutputB.draw(matrixStack, 143, 11);
        this.speedBackground.draw(matrixStack, 29, 40);
        if (!recipe.getInputFluids().isEmpty()) {
            RenderHelper.drawFluid((PoseStack)matrixStack, (int)57, (int)22, (FluidStack)((FluidIngredient)recipe.getInputFluids().get(0)).getFluids()[0], (int)24, (int)16);
            this.progressFluidBackground.draw(matrixStack, 57, 22);
            this.progressFluid.draw(matrixStack, 57, 22);
        } else {
            this.progress.draw(matrixStack, 57, 22);
        }
        this.speed.draw(matrixStack, 29, 40);
    }
}

