/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.config;

import mezz.jei.forge.config.ClientConfig;
import mezz.jei.forge.config.IngredientFilterConfig;
import mezz.jei.forge.config.IngredientGridConfig;
import mezz.jei.forge.config.ModIdFormattingConfig;
import mezz.jei.forge.events.PermanentEventSubscriptions;
import mezz.jei.gui.overlay.HorizontalAlignment;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class JEIClientConfigs {
    private final ClientConfig clientConfig;
    private final IngredientFilterConfig filterConfig;
    private final ModIdFormattingConfig modNameFormat;
    private final IngredientGridConfig ingredientListConfig;
    private final IngredientGridConfig bookmarkListConfig;
    private final ForgeConfigSpec config;

    public JEIClientConfigs() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.clientConfig = new ClientConfig(builder);
        this.filterConfig = new IngredientFilterConfig(builder);
        this.modNameFormat = new ModIdFormattingConfig(builder);
        this.ingredientListConfig = new IngredientGridConfig("IngredientList", builder, HorizontalAlignment.RIGHT);
        this.bookmarkListConfig = new IngredientGridConfig("BookmarkList", builder, HorizontalAlignment.LEFT);
        this.config = builder.build();
    }

    public void register(PermanentEventSubscriptions subscriptions) {
        subscriptions.register(ModConfigEvent.class, this::reload);
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.config);
    }

    public void reload(ModConfigEvent event) {
        if (event.getConfig().getSpec() != this.config) {
            return;
        }
        this.clientConfig.reload();
        this.modNameFormat.reload();
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public IngredientFilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public IngredientGridConfig getIngredientListConfig() {
        return this.ingredientListConfig;
    }

    public IngredientGridConfig getBookmarkListConfig() {
        return this.bookmarkListConfig;
    }

    public ModIdFormattingConfig getModNameFormat() {
        return this.modNameFormat;
    }
}

