/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11;
import xaero.map.WorldMap;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.element.MapElementReader;
import xaero.map.element.MapElementRenderProvider;
import xaero.map.element.MapElementRenderer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.GuiMap;
import xaero.map.mods.SupportMods;

public class MapElementRenderHandler {
    private final List<MapElementRenderer<?, ?, ?>> renderers;
    protected final int location;

    private MapElementRenderHandler(List<MapElementRenderer<?, ?, ?>> renderers, int location) {
        this.renderers = renderers;
        this.location = location;
    }

    public void add(MapElementRenderer<?, ?, ?> renderer) {
        this.renderers.add(renderer);
    }

    public static <E, C> HoveredMapElementHolder<E, C> createResult(E hovered, MapElementRenderer<?, ?, ?> hoveredRenderer) {
        MapElementRenderer<?, ?, ?> rendererCast = hoveredRenderer;
        return new HoveredMapElementHolder(hovered, rendererCast);
    }

    private <E> MapElementRenderer<E, ?, ?> getRenderer(HoveredMapElementHolder<E, ?> holder) {
        return holder.getRenderer();
    }

    public HoveredMapElementHolder<?, ?> render(GuiMap mapScreen, PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double scale, double mouseX, double mouseZ, float brightness, boolean cave, HoveredMapElementHolder<?, ?> oldHovered, Minecraft mc, float partialTicks) {
        HoveredMapElementHolder<?, ?> hoveredToReturn;
        Object hovered = null;
        MapElementRenderer<?, ?, ?> hoveredRenderer = null;
        TextureManager textureManager = mc.m_91097_();
        Font fontRenderer = mc.f_91062_;
        textureManager.m_174784_(WorldMap.guiTextures);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        double baseScale = 1.0 / scale;
        Collections.sort(this.renderers);
        for (int i = this.renderers.size() - 1; i >= 0; --i) {
            MapElementRenderer<?, ?, ?> renderer = this.renderers.get(i);
            Object obj = this.getRendererHovered(renderer, mapScreen, mouseX, mouseZ, scale, guiBasedScale, partialTicks);
            if (obj == null) continue;
            hovered = obj;
            hoveredRenderer = renderer;
            break;
        }
        HoveredMapElementHolder<Object, Object> hoveredMapElementHolder = oldHovered != null && oldHovered.is(hovered) ? oldHovered : (hoveredToReturn = hovered == null ? null : MapElementRenderHandler.createResult(hovered, hoveredRenderer));
        if (hovered == null && oldHovered != null) {
            hovered = oldHovered.getElement();
            hoveredRenderer = this.getRenderer(oldHovered);
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, -980.0);
        matrixStack.m_85841_((float)baseScale, (float)baseScale, 1.0f);
        for (MapElementRenderer mapElementRenderer : this.renderers) {
            this.renderWithRenderer(mapElementRenderer, hovered, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, cave, oldHovered, mc, true, partialTicks, 0, 0);
        }
        if (hovered != null) {
            this.renderHoveredWithRenderer(hoveredRenderer, hovered, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, cave, mc, true, partialTicks, 0, 0);
        }
        int indexLimit = 19490;
        for (MapElementRenderer<?, ?, ?> renderer : this.renderers) {
            int elementIndex = 0;
            elementIndex = this.renderWithRenderer(renderer, hovered, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, cave, oldHovered, mc, false, partialTicks, elementIndex, indexLimit);
            matrixStack.m_85837_(0.0, 0.0, this.getElementIndexDepth(elementIndex, indexLimit));
            if ((indexLimit -= elementIndex) >= 0) continue;
            indexLimit = 0;
        }
        if (hovered != null) {
            this.renderHoveredWithRenderer(hoveredRenderer, hovered, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, cave, mc, false, partialTicks, 0, indexLimit);
        }
        matrixStack.m_85849_();
        textureManager.m_174784_(WorldMap.guiTextures);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        return hoveredToReturn;
    }

    private <E, C, R extends MapElementRenderer<E, C, R>> E getRendererHovered(MapElementRenderer<E, C, R> renderer, GuiMap mapScreen, double mouseX, double mouseZ, double scale, double guiBasedScale, float partialTicks) {
        if (!renderer.shouldRender(this.location, false) && !renderer.shouldRender(this.location, true)) {
            return null;
        }
        MapElementReader reader = renderer.reader;
        MapElementRenderProvider provider = renderer.provider;
        Object context = renderer.context;
        int location = this.location;
        E result = null;
        provider.begin(location, context);
        while (provider.hasNext(location, context)) {
            Object e = provider.getNext(location, context);
            if (e == null || reader.isHidden(e, context) || !reader.isInteractable(location, e) || !reader.isHoveredOnMap(location, e, mouseX, mouseZ, scale, guiBasedScale, context, partialTicks)) continue;
            result = e;
        }
        provider.end(location, context);
        return result;
    }

    private <E, C, R extends MapElementRenderer<E, C, R>> int renderHoveredWithRenderer(MapElementRenderer<E, C, R> renderer, Object hovered, GuiMap mapScreen, PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, TextureManager textureManager, Font font, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double baseScale, double scale, double mouseX, double mouseZ, float brightness, boolean cave, Minecraft mc, boolean pre, float partialTicks, int elementIndex, int indexLimit) {
        if (!renderer.shouldRenderHovered(pre)) {
            return elementIndex;
        }
        renderer.beforeRender(this.location, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, guiBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        Object hoveredCast = hovered;
        matrixStack.m_85836_();
        if (!pre) {
            matrixStack.m_85837_(0.0, 0.0, 1.0);
        }
        if (this.transformAndRenderElement(renderer, hoveredCast, hovered, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, font, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, cave, mc, pre, partialTicks, elementIndex, indexLimit) && !pre) {
            ++elementIndex;
        }
        matrixStack.m_85849_();
        renderer.afterRender(this.location, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, guiBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        return elementIndex;
    }

    private <E, C, R extends MapElementRenderer<E, C, R>> int renderWithRenderer(MapElementRenderer<E, C, R> renderer, Object hovered, GuiMap mapScreen, PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, TextureManager textureManager, Font font, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double baseScale, double scale, double mouseX, double mouseZ, float brightness, boolean cave, HoveredMapElementHolder<?, ?> oldHovered, Minecraft mc, boolean pre, float partialTicks, int elementIndex, int indexLimit) {
        int location = this.location;
        if (!renderer.shouldRender(location, pre)) {
            return elementIndex;
        }
        MapElementReader reader = renderer.reader;
        MapElementRenderProvider provider = renderer.provider;
        Object context = renderer.context;
        renderer.beforeRender(location, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, guiBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        provider.begin(location, context);
        while (provider.hasNext(location, context)) {
            Object e = provider.setupContextAndGetNext(location, context);
            if (e == null || reader.isHidden(e, context) || e == hovered || !reader.isOnScreen(e, cameraX, cameraZ, width, height, scale, guiBasedScale, context, partialTicks) || !this.transformAndRenderElement(renderer, e, hovered, mapScreen, matrixStack, renderTypeBuffers, rendererProvider, textureManager, font, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, cave, mc, pre, partialTicks, elementIndex, indexLimit) || pre) continue;
            ++elementIndex;
        }
        provider.end(location, context);
        renderer.afterRender(location, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, guiBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        return elementIndex;
    }

    private <E, C, R extends MapElementRenderer<E, C, R>> boolean transformAndRenderElement(MapElementRenderer<E, C, R> renderer, E e, Object hovered, GuiMap mapScreen, PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, TextureManager textureManager, Font font, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double baseScale, double scale, double mouseX, double mouseZ, float brightness, boolean cave, Minecraft mc, boolean pre, float partialTicks, int elementIndex, int indexLimit) {
        MapElementReader reader = renderer.reader;
        Object context = renderer.context;
        matrixStack.m_85836_();
        double offX = (reader.getRenderX(e, context, partialTicks) - cameraX) / baseScale;
        double offZ = (reader.getRenderZ(e, context, partialTicks) - cameraZ) / baseScale;
        long roundedOffX = Math.round(offX);
        long roundedOffZ = Math.round(offZ);
        double partialX = offX - (double)roundedOffX;
        double partialY = offZ - (double)roundedOffZ;
        matrixStack.m_85837_((double)roundedOffX, (double)roundedOffZ, 0.0);
        boolean result = false;
        if (pre) {
            renderer.renderElementPre(this.location, e, e == hovered, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, guiBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, (float)guiBasedScale, partialX, partialY, cave, partialTicks);
        } else {
            double optionalDepth = this.getElementIndexDepth(elementIndex, indexLimit);
            result = renderer.renderElement(this.location, e, e == hovered, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, guiBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, elementIndex, optionalDepth, (float)guiBasedScale, partialX, partialY, cave, partialTicks);
        }
        matrixStack.m_85849_();
        return result;
    }

    private double getElementIndexDepth(int elementIndex, int indexLimit) {
        return (double)(elementIndex >= indexLimit ? indexLimit : elementIndex) * 0.1;
    }

    public static final class Builder {
        private Builder() {
        }

        public MapElementRenderHandler build() {
            ArrayList renderers = new ArrayList();
            if (SupportMods.minimap()) {
                renderers.add(SupportMods.xaeroMinimap.getWaypointRenderer());
            }
            if (SupportMods.pac()) {
                renderers.add(SupportMods.xaeroPac.getPlayerRenderer());
                renderers.add(SupportMods.xaeroPac.getCaimResultElementRenderer());
            }
            return new MapElementRenderHandler(renderers, 3);
        }

        public static Builder begin() {
            return new Builder();
        }
    }
}

