/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.network;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.map.MapDecorationRegistry;
import net.mehvahdjukaar.selene.map.type.SimpleDecorationType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundSyncMapDecorationTypesPacket {
    private final Collection<SimpleDecorationType> simpleTypes;

    public ClientBoundSyncMapDecorationTypesPacket(Collection<SimpleDecorationType> simpleTypes) {
        this.simpleTypes = simpleTypes;
    }

    public ClientBoundSyncMapDecorationTypesPacket(FriendlyByteBuf pBuffer) {
        int size = pBuffer.m_130242_();
        this.simpleTypes = new ArrayList<SimpleDecorationType>();
        for (int i = 0; i < size; ++i) {
            DataResult r = SimpleDecorationType.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)pBuffer.m_130261_());
            r.result().ifPresent(this.simpleTypes::add);
        }
    }

    public static void buffer(ClientBoundSyncMapDecorationTypesPacket message, FriendlyByteBuf buffer) {
        ArrayList<CompoundTag> encoded = new ArrayList<CompoundTag>();
        for (SimpleDecorationType f : message.simpleTypes) {
            try {
                Optional r = SimpleDecorationType.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)f).resultOrPartial(e -> Selene.LOGGER.error("Failed encoding Simple Map Decoration {} : {}", (Object)f, e));
                encoded.add((CompoundTag)r.get());
            }
            catch (Exception e2) {
                Selene.LOGGER.error("Failed encoding Soft Fluid {} : {}", (Object)f, (Object)e2);
            }
        }
        buffer.m_130130_(encoded.size());
        encoded.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130079_(arg_0));
    }

    public static void handler(ClientBoundSyncMapDecorationTypesPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                MapDecorationRegistry.DATA_DRIVEN_REGISTRY.acceptClientTypes(message.simpleTypes);
            }
        });
        context.setPacketHandled(true);
    }
}

