/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.map.type;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.map.CustomMapDecoration;
import net.mehvahdjukaar.selene.map.markers.MapBlockMarker;
import net.mehvahdjukaar.selene.map.type.IMapDecorationType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;

public class CustomDecorationType<D extends CustomMapDecoration, M extends MapBlockMarker<D>>
implements IMapDecorationType<D, M> {
    protected final ResourceLocation id;
    protected final Supplier<M> markerFactory;
    protected final BiFunction<BlockGetter, BlockPos, M> markerFromWorldFactory;
    protected final BiFunction<IMapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory;
    protected final boolean hasMarker;

    public CustomDecorationType(ResourceLocation id, Supplier<M> markerFactory, BiFunction<BlockGetter, BlockPos, M> markerFromWorldFactory, BiFunction<IMapDecorationType<?, ?>, FriendlyByteBuf, D> decorationFactory) {
        this.id = id;
        this.markerFactory = markerFactory;
        this.markerFromWorldFactory = markerFromWorldFactory;
        this.decorationFactory = decorationFactory;
        this.hasMarker = true;
    }

    public CustomDecorationType(ResourceLocation id, BiFunction<IMapDecorationType<?, ?>, FriendlyByteBuf, D> decoFromBuffer) {
        this.id = id;
        this.markerFactory = () -> null;
        this.markerFromWorldFactory = (s, d) -> null;
        this.decorationFactory = decoFromBuffer;
        this.hasMarker = false;
    }

    @Override
    public boolean hasMarker() {
        return this.hasMarker;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    public String toString() {
        return this.getId().toString();
    }

    @Override
    @Nullable
    public D loadDecorationFromBuffer(FriendlyByteBuf buffer) {
        try {
            return (D)((CustomMapDecoration)this.decorationFactory.apply(this, buffer));
        }
        catch (Exception e) {
            Selene.LOGGER.warn("Failed to load custom map decoration for decoration type" + this.getId() + ": " + e);
            return null;
        }
    }

    @Override
    @Nullable
    public M loadMarkerFromNBT(CompoundTag compound) {
        if (this.hasMarker) {
            MapBlockMarker marker = (MapBlockMarker)this.markerFactory.get();
            try {
                marker.loadFromNBT(compound);
                return (M)marker;
            }
            catch (Exception e) {
                Selene.LOGGER.warn("Failed to load world map marker for decoration type" + this.getId() + ": " + e);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public M getWorldMarkerFromWorld(BlockGetter reader, BlockPos pos) {
        return (M)(this.hasMarker ? (MapBlockMarker)this.markerFromWorldFactory.apply(reader, pos) : null);
    }
}

