/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.registry.util;

import architectspalette.content.blocks.VerticalSlabBlock;
import architectspalette.core.registry.util.DataUtils;
import architectspalette.core.registry.util.RegistryUtils;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.RegistryObject;

public class StoneBlockSet {
    public RegistryObject<Block> slab;
    public RegistryObject<Block> verticalSlab;
    public RegistryObject<Block> stairs;
    public RegistryObject<Block> wall;
    public RegistryObject<Block> block;
    private final String material_name;

    public StoneBlockSet(RegistryObject<Block> base_block) {
        this(base_block, true);
    }

    public StoneBlockSet(RegistryObject<Block> base_block, Boolean auto_fill) {
        this.block = base_block;
        this.material_name = this.getMaterialFromBlock(base_block.getId().m_135815_());
        if (auto_fill.booleanValue()) {
            this.addAll();
        }
    }

    private String getMaterialFromBlock(String block) {
        return block.replace("bricks", "brick").replace("_planks", "").replace("_block", "").replace("tiles", "tile");
    }

    private BlockBehaviour.Properties properties() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)this.block.get()));
    }

    public Block get() {
        return (Block)this.block.get();
    }

    public StoneBlockSet addSlabs() {
        this.slab = RegistryUtils.createBlock(this.material_name + "_slab", () -> new SlabBlock(this.properties()));
        this.verticalSlab = RegistryUtils.createBlock(this.material_name + "_vertical_slab", () -> new VerticalSlabBlock(this.properties()));
        return this;
    }

    public StoneBlockSet addStairs() {
        this.stairs = RegistryUtils.createBlock(this.material_name + "_stairs", () -> new StairBlock(() -> ((Block)this.block.get()).m_49966_(), this.properties()));
        return this;
    }

    public StoneBlockSet addWalls() {
        this.wall = RegistryUtils.createBlock(this.material_name + "_wall", () -> new WallBlock(this.properties()), CreativeModeTab.f_40750_);
        return this;
    }

    public StoneBlockSet addAll() {
        this.addSlabs();
        this.addStairs();
        this.addWalls();
        return this;
    }

    private Stream<Block> blockStream() {
        return Stream.of(this.slab, this.verticalSlab, this.stairs, this.wall, this.block).filter(Objects::nonNull).map(RegistryObject::get);
    }

    public void forEach(Consumer<? super Block> action) {
        this.blockStream().forEach(action);
    }

    public void registerFlammable(int encouragement, int flammability) {
        this.forEach(b -> DataUtils.registerFlammable(b, encouragement, flammability));
    }
}

