/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.registry;

import architectspalette.content.blocks.BigBrickBlock;
import architectspalette.content.blocks.BoardBlock;
import architectspalette.content.blocks.CageLanternBlock;
import architectspalette.content.blocks.CustomTorchBlock;
import architectspalette.content.blocks.CustomWallTorchBlock;
import architectspalette.content.blocks.GlassLikePillarBlock;
import architectspalette.content.blocks.GreenFireBlock;
import architectspalette.content.blocks.PipeBlock;
import architectspalette.content.blocks.RailingBlock;
import architectspalette.content.blocks.StrippableLogBlock;
import architectspalette.content.blocks.SunstoneBlock;
import architectspalette.content.blocks.TotemBlock;
import architectspalette.content.blocks.TotemWingBlock;
import architectspalette.content.blocks.abyssaline.AbyssalineLampBlock;
import architectspalette.content.blocks.abyssaline.AbyssalinePillarBlock;
import architectspalette.content.blocks.abyssaline.AbyssalineSlabBlock;
import architectspalette.content.blocks.abyssaline.AbyssalineVerticalSlabBlock;
import architectspalette.content.blocks.abyssaline.ChiseledAbyssalineBlock;
import architectspalette.content.blocks.abyssaline.NewAbyssalineBlock;
import architectspalette.content.blocks.entrails.DrippyBlock;
import architectspalette.content.blocks.entrails.DrippySlabBlock;
import architectspalette.content.blocks.entrails.DrippyVerticalSlabBlock;
import architectspalette.content.blocks.flint.FlintBlock;
import architectspalette.content.blocks.flint.FlintPillarBlock;
import architectspalette.content.worldgen.features.TwistedTree;
import architectspalette.core.registry.APBlockProperties;
import architectspalette.core.registry.MiscRegistry;
import architectspalette.core.registry.util.RegistryUtils;
import architectspalette.core.registry.util.StoneBlockSet;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class APBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"architects_palette");
    public static final RegistryObject<NewAbyssalineBlock> ABYSSALINE = RegistryUtils.createBlock("abyssaline", () -> new NewAbyssalineBlock(APBlockProperties.ABYSSALINE));
    public static final RegistryObject<NewAbyssalineBlock> ABYSSALINE_BRICKS = RegistryUtils.createBlock("abyssaline_bricks", () -> new NewAbyssalineBlock(APBlockProperties.ABYSSALINE));
    public static final RegistryObject<ChiseledAbyssalineBlock> CHISELED_ABYSSALINE_BRICKS = RegistryUtils.createBlock("chiseled_abyssaline_bricks", () -> new ChiseledAbyssalineBlock(APBlockProperties.CHISELED_ABYSSALINE));
    public static final RegistryObject<AbyssalinePillarBlock> ABYSSALINE_PILLAR = RegistryUtils.createBlock("abyssaline_pillar", () -> new AbyssalinePillarBlock(APBlockProperties.ABYSSALINE));
    public static final RegistryObject<AbyssalineSlabBlock> ABYSSALINE_BRICK_SLAB = RegistryUtils.createBlock("abyssaline_brick_slab", () -> new AbyssalineSlabBlock(APBlockProperties.ABYSSALINE));
    public static final RegistryObject<NewAbyssalineBlock> ABYSSALINE_TILES = RegistryUtils.createBlock("abyssaline_tiles", () -> new NewAbyssalineBlock(APBlockProperties.ABYSSALINE));
    public static final RegistryObject<AbyssalineSlabBlock> ABYSSALINE_TILE_SLAB = RegistryUtils.createBlock("abyssaline_tile_slab", () -> new AbyssalineSlabBlock(APBlockProperties.ABYSSALINE));
    public static final RegistryObject<AbyssalineLampBlock> ABYSSALINE_LAMP_BLOCK = RegistryUtils.createBlock("abyssaline_lamp", () -> new AbyssalineLampBlock(APBlockProperties.ABYSSALINE_LAMP.m_60918_(SoundType.f_56744_)));
    public static final RegistryObject<AbyssalineVerticalSlabBlock> ABYSSALINE_BRICK_VERTICAL_SLAB = RegistryUtils.createBlock("abyssaline_brick_vertical_slab", () -> new AbyssalineVerticalSlabBlock(APBlockProperties.ABYSSALINE));
    public static final RegistryObject<AbyssalineVerticalSlabBlock> ABYSSALINE_TILE_VERTICAL_SLAB = RegistryUtils.createBlock("abyssaline_tile_vertical_slab", () -> new AbyssalineVerticalSlabBlock(APBlockProperties.ABYSSALINE));
    public static final RegistryObject<Block> SALMON_LOG = RegistryUtils.createBlock("salmon_log", () -> new RotatedPillarBlock(APBlockProperties.Meat(MaterialColor.f_76386_)), CreativeModeTab.f_40749_);
    public static final RegistryObject<Block> COD_LOG = RegistryUtils.createBlock("cod_log", () -> new RotatedPillarBlock(APBlockProperties.Meat(MaterialColor.f_76376_)), CreativeModeTab.f_40749_);
    public static final RegistryObject<Block> SALMON_SCALES = RegistryUtils.createBlock("salmon_scales", () -> new RotatedPillarBlock(APBlockProperties.Meat(MaterialColor.f_76386_)), CreativeModeTab.f_40749_);
    public static final RegistryObject<Block> COD_SCALES = RegistryUtils.createBlock("cod_scales", () -> new RotatedPillarBlock(APBlockProperties.Meat(MaterialColor.f_76376_)), CreativeModeTab.f_40749_);
    public static final RegistryObject<Block> ENTRAILS = RegistryUtils.createBlock("entrails", () -> new DrippyBlock(APBlockProperties.Meat(MaterialColor.f_76378_)));
    public static final RegistryObject<Block> ENTRAILS_SLAB = RegistryUtils.createBlock("entrails_slab", () -> new DrippySlabBlock(APBlockProperties.Meat(MaterialColor.f_76378_)));
    public static final RegistryObject<Block> ENTRAILS_VERTICAL_SLAB = RegistryUtils.createBlock("entrails_vertical_slab", () -> new DrippyVerticalSlabBlock(APBlockProperties.Meat(MaterialColor.f_76378_)));
    public static final RegistryObject<Block> ENTRAILS_STAIRS = RegistryUtils.createBlock("entrails_stairs", () -> new StairBlock(() -> ((Block)ENTRAILS.get()).m_49966_(), APBlockProperties.Meat(MaterialColor.f_76378_)));
    public static final StoneBlockSet PLATING_BLOCK = new StoneBlockSet(RegistryUtils.createBlock("plating_block", () -> new Block(APBlockProperties.PLATING)));
    public static final RegistryObject<Block> PIPE = RegistryUtils.createBlock("pipe", () -> new PipeBlock(APBlockProperties.PLATING.m_60955_()));
    public static final RegistryObject<Block> SPOOL = RegistryUtils.createBlock("spool", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_)));
    public static final RegistryObject<Block> CHARCOAL_BLOCK = RegistryUtils.createBlockNoItem("charcoal_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50353_)));
    public static final StoneBlockSet MYONITE = new StoneBlockSet(RegistryUtils.createBlock("myonite", () -> new Block(APBlockProperties.MYONITE)));
    public static final StoneBlockSet MYONITE_BRICK = new StoneBlockSet(RegistryUtils.createBlock("myonite_bricks", () -> new Block(APBlockProperties.MYONITE)));
    public static final StoneBlockSet MUSHY_MYONITE_BRICK = new StoneBlockSet(RegistryUtils.createBlock("mushy_myonite_bricks", () -> new Block(APBlockProperties.MYONITE)));
    public static final StoneBlockSet OLIVESTONE_BRICK = new StoneBlockSet(RegistryUtils.createBlock("olivestone_bricks", () -> new Block(APBlockProperties.OLIVESTONE)));
    public static final StoneBlockSet OLIVESTONE_TILE = new StoneBlockSet(RegistryUtils.createBlock("olivestone_tiles", () -> new Block(APBlockProperties.OLIVESTONE)));
    public static final RegistryObject<Block> OLIVESTONE_PILLAR = RegistryUtils.createBlock("olivestone_pillar", () -> new RotatedPillarBlock(APBlockProperties.OLIVESTONE));
    public static final RegistryObject<Block> CRACKED_OLIVESTONE_BRICKS = RegistryUtils.createBlock("cracked_olivestone_bricks", () -> new Block(APBlockProperties.OLIVESTONE));
    public static final RegistryObject<Block> CRACKED_OLIVESTONE_TILES = RegistryUtils.createBlock("cracked_olivestone_tiles", () -> new Block(APBlockProperties.OLIVESTONE));
    public static final RegistryObject<Block> CHISELED_OLIVESTONE = RegistryUtils.createBlock("chiseled_olivestone", () -> new Block(APBlockProperties.OLIVESTONE));
    public static final RegistryObject<Block> ILLUMINATED_OLIVESTONE = RegistryUtils.createBlock("illuminated_olivestone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)OLIVESTONE_BRICK.get()).m_60953_(state -> 15)));
    public static final StoneBlockSet ALGAL_BRICK = new StoneBlockSet(RegistryUtils.createBlock("algal_bricks", () -> new Block(APBlockProperties.ALGAL_BRICK)));
    public static final RegistryObject<Block> CRACKED_ALGAL_BRICKS = RegistryUtils.createBlock("cracked_algal_bricks", () -> new Block(APBlockProperties.ALGAL_BRICK));
    public static final RegistryObject<Block> CHISELED_ALGAL_BRICKS = RegistryUtils.createBlock("chiseled_algal_bricks", () -> new Block(APBlockProperties.ALGAL_BRICK));
    public static final StoneBlockSet OVERGROWN_ALGAL_BRICK = new StoneBlockSet(RegistryUtils.createBlock("overgrown_algal_bricks", () -> new Block(APBlockProperties.ALGAL_BRICK)));
    public static final RegistryObject<Block> ALGAL_LAMP = RegistryUtils.createBlock("algal_lamp", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50386_)));
    public static final List<StoneBlockSet> ORE_BRICKS = APBlocks.addOreBricks();
    public static final RegistryObject<Block> FLINT_BLOCK = RegistryUtils.createBlock("flint_block", () -> new FlintBlock(APBlockProperties.FLINT));
    public static final StoneBlockSet FLINT_TILES = new StoneBlockSet(RegistryUtils.createBlock("flint_tiles", () -> new FlintBlock(APBlockProperties.FLINT)));
    public static final RegistryObject<Block> FLINT_PILLAR = RegistryUtils.createBlock("flint_pillar", () -> new FlintPillarBlock(APBlockProperties.FLINT));
    public static final StoneBlockSet POLISHED_PACKED_ICE = new StoneBlockSet(RegistryUtils.createBlock("polished_packed_ice", () -> new Block(APBlockProperties.BUILDING_ICE)));
    public static final RegistryObject<Block> CHISELED_PACKED_ICE = RegistryUtils.createBlock("chiseled_packed_ice", () -> new Block(APBlockProperties.BUILDING_ICE));
    public static final RegistryObject<Block> PACKED_ICE_PILLAR = RegistryUtils.createBlock("packed_ice_pillar", () -> new RotatedPillarBlock(APBlockProperties.BUILDING_ICE));
    public static final StoneBlockSet SUNMETAL = new StoneBlockSet(RegistryUtils.createBlock("sunmetal_block", () -> new Block(APBlockProperties.SUNMETAL)), false).addSlabs().addStairs();
    public static final RegistryObject<Block> CHISELED_SUNMETAL_BLOCK = RegistryUtils.createBlock("chiseled_sunmetal_block", () -> new Block(APBlockProperties.SUNMETAL));
    public static final RegistryObject<Block> SUNMETAL_PILLAR = RegistryUtils.createBlock("sunmetal_pillar", () -> new RotatedPillarBlock(APBlockProperties.SUNMETAL));
    public static final RegistryObject<Block> SUNMETAL_BARS = RegistryUtils.createBlock("sunmetal_bars", () -> new IronBarsBlock(APBlockProperties.SUNMETAL.m_60955_()));
    public static final StoneBlockSet OSSEOUS_BRICK = new StoneBlockSet(RegistryUtils.createBlock("osseous_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50453_))));
    public static final RegistryObject<Block> OSSEOUS_PILLAR = RegistryUtils.createBlock("osseous_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50453_)));
    public static final RegistryObject<Block> OSSEOUS_SKULL = RegistryUtils.createBlock("osseous_skull", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50453_)));
    public static final RegistryObject<Block> LIT_OSSEOUS_SKULL = RegistryUtils.createBlock("lit_osseous_skull", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50453_).m_60953_(e -> 12)));
    public static final RegistryObject<Block> WITHERED_BONE_BLOCK = RegistryUtils.createBlock("withered_bone_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50453_)));
    public static final StoneBlockSet WITHERED_OSSEOUS_BRICK = new StoneBlockSet(RegistryUtils.createBlock("withered_osseous_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50453_))));
    public static final RegistryObject<Block> WITHERED_OSSEOUS_PILLAR = RegistryUtils.createBlock("withered_osseous_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50453_)));
    public static final RegistryObject<Block> WITHERED_OSSEOUS_SKULL = RegistryUtils.createBlock("withered_osseous_skull", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50453_)));
    public static final RegistryObject<Block> LIT_WITHERED_OSSEOUS_SKULL = RegistryUtils.createBlock("lit_withered_osseous_skull", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50453_).m_60953_(e -> 12)));
    public static final RegistryObject<Block> WITHER_LAMP = RegistryUtils.createBlock("wither_lamp", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50386_)));
    public static final StoneBlockSet ENTWINE = new StoneBlockSet(RegistryUtils.createBlock("entwine_block", () -> new Block(APBlockProperties.ENTWINE)), false).addSlabs().addStairs();
    public static final RegistryObject<Block> ENTWINE_PILLAR = RegistryUtils.createBlock("entwine_pillar", () -> new RotatedPillarBlock(APBlockProperties.ENTWINE));
    public static final RegistryObject<Block> CHISELED_ENTWINE = RegistryUtils.createBlock("chiseled_entwine", () -> new Block(APBlockProperties.ENTWINE));
    public static final RegistryObject<Block> ENTWINE_BARS = RegistryUtils.createBlock("entwine_bars", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)ENTWINE.get()).m_60955_()));
    public static final RegistryObject<Block> HEAVY_STONE_BRICKS = RegistryUtils.createBlock("heavy_stone_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50222_)));
    public static final RegistryObject<Block> HEAVY_MOSSY_STONE_BRICKS = RegistryUtils.createBlock("heavy_mossy_stone_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50223_)));
    public static final RegistryObject<Block> HEAVY_CRACKED_STONE_BRICKS = RegistryUtils.createBlock("heavy_cracked_stone_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50224_)));
    public static final StoneBlockSet POLISHED_GLOWSTONE = new StoneBlockSet(RegistryUtils.createBlock("polished_glowstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50141_))), false).addSlabs().addWalls();
    public static final RegistryObject<Block> RUNIC_GLOWSTONE = RegistryUtils.createBlock("runic_glowstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50141_)));
    public static final RegistryObject<Block> SCUTE_BLOCK = RegistryUtils.createBlock("scute_block", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76417_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56718_)));
    public static final RegistryObject<Block> ROTTEN_FLESH_BLOCK = RegistryUtils.createBlock("rotten_flesh_block", () -> new Block(APBlockProperties.Meat(MaterialColor.f_76413_)));
    public static final StoneBlockSet GILDED_SANDSTONE = new StoneBlockSet(RegistryUtils.createBlock("gilded_sandstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_))), false).addSlabs().addStairs();
    public static final RegistryObject<Block> GILDED_SANDSTONE_PILLAR = RegistryUtils.createBlock("gilded_sandstone_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final RegistryObject<Block> CHISELED_GILDED_SANDSTONE = RegistryUtils.createBlock("chiseled_gilded_sandstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50062_)));
    public static final RegistryObject<Block> WEEPING_BLACKSTONE = RegistryUtils.createBlock("weeping_blackstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50730_)));
    public static final RegistryObject<Block> TWISTING_BLACKSTONE = RegistryUtils.createBlock("twisting_blackstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50730_)));
    public static final RegistryObject<Block> WEEPING_BLACKSTONE_BRICKS = RegistryUtils.createBlock("weeping_blackstone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50735_)));
    public static final RegistryObject<Block> TWISTING_BLACKSTONE_BRICKS = RegistryUtils.createBlock("twisting_blackstone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50735_)));
    public static final RegistryObject<Block> CHORAL_END_STONE_BRICKS = RegistryUtils.createBlock("choral_end_stone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50443_)));
    public static final RegistryObject<Block> CRACKED_END_STONE_BRICKS = RegistryUtils.createBlock("cracked_end_stone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50443_)));
    public static final RegistryObject<Block> CHISELED_END_STONE_BRICKS = RegistryUtils.createBlock("chiseled_end_stone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50443_)));
    public static final StoneBlockSet WARPSTONE = new StoneBlockSet(RegistryUtils.createBlock("warpstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_))));
    public static final StoneBlockSet TWISTED_PLANKS = new StoneBlockSet(RegistryUtils.createBlock("twisted_planks", () -> new Block(APBlockProperties.TwistedWood())), false).addSlabs().addStairs();
    public static final RegistryObject<Block> STRIPPED_TWISTED_LOG = RegistryUtils.createBlock("stripped_twisted_log", () -> new RotatedPillarBlock(APBlockProperties.TwistedWood()));
    public static final RegistryObject<Block> STRIPPED_TWISTED_WOOD = RegistryUtils.createBlock("stripped_twisted_wood", () -> new RotatedPillarBlock(APBlockProperties.TwistedWood()));
    public static final RegistryObject<Block> TWISTED_LOG = RegistryUtils.createBlock("twisted_log", () -> new StrippableLogBlock(APBlockProperties.TwistedWood(), (Block)STRIPPED_TWISTED_LOG.get()));
    public static final RegistryObject<Block> TWISTED_WOOD = RegistryUtils.createBlock("twisted_wood", () -> new StrippableLogBlock(APBlockProperties.TwistedWood(), (Block)STRIPPED_TWISTED_WOOD.get()));
    public static final RegistryObject<Block> TWISTED_LEAVES = RegistryUtils.createBlock("twisted_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_)));
    public static final RegistryObject<Block> TWISTED_FENCE = RegistryUtils.createBlock("twisted_fence", () -> new FenceBlock(APBlockProperties.TwistedWood()), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> TWISTED_FENCE_GATE = RegistryUtils.createBlock("twisted_fence_gate", () -> new FenceGateBlock(APBlockProperties.TwistedWood()), CreativeModeTab.f_40751_);
    public static final RegistryObject<Block> TWISTED_DOOR = RegistryUtils.createBlock("twisted_door", () -> new DoorBlock(APBlockProperties.TwistedWood().m_60955_()), CreativeModeTab.f_40751_);
    public static final RegistryObject<Block> TWISTED_TRAPDOOR = RegistryUtils.createBlock("twisted_trapdoor", () -> new TrapDoorBlock(APBlockProperties.TwistedWood().m_60955_()), CreativeModeTab.f_40751_);
    public static final RegistryObject<Block> TWISTED_BUTTON = RegistryUtils.createBlock("twisted_button", () -> new WoodButtonBlock(APBlockProperties.TwistedWood(true)), CreativeModeTab.f_40751_);
    public static final RegistryObject<Block> TWISTED_PRESSURE_PLATE = RegistryUtils.createBlock("twisted_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, APBlockProperties.TwistedWood(true)), CreativeModeTab.f_40751_);
    public static final RegistryObject<Block> TWISTED_SAPLING = RegistryUtils.createBlock("twisted_sapling", () -> new SaplingBlock((AbstractTreeGrower)new TwistedTree(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> POTTED_TWISTED_SAPLING = APBlocks.createPottedPlant(TWISTED_SAPLING);
    public static final StoneBlockSet BASALT_TILES = new StoneBlockSet(RegistryUtils.createBlock("basalt_tiles", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50137_))));
    public static final RegistryObject<Block> CRACKED_BASALT_TILES = RegistryUtils.createBlock("cracked_basalt_tiles", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50137_)));
    public static final RegistryObject<Block> CHISELED_BASALT_TILES = RegistryUtils.createBlock("chiseled_basalt_tiles", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50137_)));
    public static final RegistryObject<Block> SUNSTONE = RegistryUtils.createBlock("sunstone", () -> new SunstoneBlock(APBlockProperties.SUNSTONE, SunstoneBlock::sunstoneLight));
    public static final RegistryObject<Block> MOONSTONE = RegistryUtils.createBlock("moonstone", () -> new SunstoneBlock(APBlockProperties.SUNSTONE, SunstoneBlock::moonstoneLight));
    public static final RegistryObject<Block> MOLTEN_NETHER_BRICKS = RegistryUtils.createBlock("molten_nether_bricks", () -> new Block(APBlockProperties.MOLTEN_BRICK));
    public static final RegistryObject<Block> COARSE_SNOW = RegistryUtils.createBlock("coarse_snow", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50127_)));
    public static final RegistryObject<Block> HEAVY_END_STONE_BRICKS = RegistryUtils.createBlock("heavy_end_stone_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50443_), BigBrickBlock.BrickType.END_STONE));
    public static final RegistryObject<Block> HEAVY_CRACKED_END_STONE_BRICKS = RegistryUtils.createBlock("heavy_cracked_end_stone_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50443_), BigBrickBlock.BrickType.END_STONE));
    public static final RegistryObject<Block> REDSTONE_CAGE_LANTERN = RegistryUtils.createBlock("redstone_cage_lantern", () -> new CageLanternBlock(APBlockProperties.CAGE_LANTERN, 3), CreativeModeTab.f_40751_);
    public static final RegistryObject<Block> GLOWSTONE_CAGE_LANTERN = RegistryUtils.createBlock("glowstone_cage_lantern", () -> new CageLanternBlock(APBlockProperties.CAGE_LANTERN, 3), CreativeModeTab.f_40751_);
    public static final RegistryObject<Block> ALGAL_CAGE_LANTERN = RegistryUtils.createBlock("algal_cage_lantern", () -> new CageLanternBlock(APBlockProperties.CAGE_LANTERN, 3), CreativeModeTab.f_40751_);
    public static final RegistryObject<TotemWingBlock> ACACIA_TOTEM_WING = RegistryUtils.createBlock("acacia_totem_wing", () -> new TotemWingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_).m_60955_().m_60993_().m_60918_(SoundType.f_56756_).m_60910_()), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> GRINNING_ACACIA_TOTEM = RegistryUtils.createBlock("grinning_acacia_totem", () -> new TotemBlock(APBlockProperties.ACACIA_TOTEM, (TotemWingBlock)((Object)((Object)ACACIA_TOTEM_WING.get())), TotemBlock.TotemFace.GRINNING));
    public static final RegistryObject<Block> PLACID_ACACIA_TOTEM = RegistryUtils.createBlock("placid_acacia_totem", () -> new TotemBlock(APBlockProperties.ACACIA_TOTEM, (TotemWingBlock)((Object)((Object)ACACIA_TOTEM_WING.get())), TotemBlock.TotemFace.PLACID));
    public static final RegistryObject<Block> SHOCKED_ACACIA_TOTEM = RegistryUtils.createBlock("shocked_acacia_totem", () -> new TotemBlock(APBlockProperties.ACACIA_TOTEM, (TotemWingBlock)((Object)((Object)ACACIA_TOTEM_WING.get())), TotemBlock.TotemFace.SHOCKED));
    public static final RegistryObject<Block> BLANK_ACACIA_TOTEM = RegistryUtils.createBlock("blank_acacia_totem", () -> new TotemBlock(APBlockProperties.ACACIA_TOTEM, (TotemWingBlock)((Object)((Object)ACACIA_TOTEM_WING.get())), TotemBlock.TotemFace.BLANK));
    public static final RegistryObject<Block> ENDER_PEARL_BLOCK = RegistryUtils.createBlock("ender_pearl_block", () -> new Block(APBlockProperties.ENDER_PEARL));
    public static final RegistryObject<Block> OAK_BOARDS = RegistryUtils.createBlock("oak_boards", () -> new BoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)));
    public static final RegistryObject<Block> BIRCH_BOARDS = RegistryUtils.createBlock("birch_boards", () -> new BoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50742_)));
    public static final RegistryObject<Block> SPRUCE_BOARDS = RegistryUtils.createBlock("spruce_boards", () -> new BoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50741_)));
    public static final RegistryObject<Block> JUNGLE_BOARDS = RegistryUtils.createBlock("jungle_boards", () -> new BoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50743_)));
    public static final RegistryObject<Block> DARK_OAK_BOARDS = RegistryUtils.createBlock("dark_oak_boards", () -> new BoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50745_)));
    public static final RegistryObject<Block> ACACIA_BOARDS = RegistryUtils.createBlock("acacia_boards", () -> new BoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_)));
    public static final RegistryObject<Block> CRIMSON_BOARDS = RegistryUtils.createBlock("crimson_boards", () -> new BoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50655_)));
    public static final RegistryObject<Block> WARPED_BOARDS = RegistryUtils.createBlock("warped_boards", () -> new BoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50656_)));
    public static final RegistryObject<Block> TWISTED_BOARDS = RegistryUtils.createBlock("twisted_boards", () -> new BoardBlock(APBlockProperties.TwistedWood()));
    public static final RegistryObject<Block> OAK_RAILING = RegistryUtils.createBlock("oak_railing", () -> new RailingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> BIRCH_RAILING = RegistryUtils.createBlock("birch_railing", () -> new RailingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50742_)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> SPRUCE_RAILING = RegistryUtils.createBlock("spruce_railing", () -> new RailingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50741_)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> JUNGLE_RAILING = RegistryUtils.createBlock("jungle_railing", () -> new RailingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50743_)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> DARK_OAK_RAILING = RegistryUtils.createBlock("dark_oak_railing", () -> new RailingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50745_)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> ACACIA_RAILING = RegistryUtils.createBlock("acacia_railing", () -> new RailingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50744_)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> CRIMSON_RAILING = RegistryUtils.createBlock("crimson_railing", () -> new RailingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50655_)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> WARPED_RAILING = RegistryUtils.createBlock("warped_railing", () -> new RailingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50656_)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> TWISTED_RAILING = RegistryUtils.createBlock("twisted_railing", () -> new RailingBlock(APBlockProperties.TwistedWood()), CreativeModeTab.f_40750_);
    public static final StoneBlockSet DRIPSTONE_BRICKS = new StoneBlockSet(RegistryUtils.createBlock("dripstone_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152537_))));
    public static final RegistryObject<Block> DRIPSTONE_PILLAR = RegistryUtils.createBlock("dripstone_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152537_)));
    public static final RegistryObject<Block> CHISELED_DRIPSTONE = RegistryUtils.createBlock("chiseled_dripstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152537_)));
    public static final RegistryObject<Block> HEAVY_DRIPSTONE_BRICKS = RegistryUtils.createBlock("heavy_dripstone_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152537_), BigBrickBlock.BrickType.DRIPSTONE));
    public static final RegistryObject<Block> DRIPSTONE_LAMP = RegistryUtils.createBlock("dripstone_lamp", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152537_).m_60953_(e -> 8)));
    public static final StoneBlockSet CALCITE_BRICKS = new StoneBlockSet(RegistryUtils.createBlock("calcite_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152497_))));
    public static final RegistryObject<Block> CALCITE_PILLAR = RegistryUtils.createBlock("calcite_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152497_)));
    public static final RegistryObject<Block> CHISELED_CALCITE = RegistryUtils.createBlock("chiseled_calcite", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152497_)));
    public static final RegistryObject<Block> HEAVY_CALCITE_BRICKS = RegistryUtils.createBlock("heavy_calcite_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152497_), BigBrickBlock.BrickType.CALCITE));
    public static final RegistryObject<Block> CALCITE_LAMP = RegistryUtils.createBlock("calcite_lamp", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152497_).m_60953_(e -> 8)));
    public static final StoneBlockSet TUFF_BRICKS = new StoneBlockSet(RegistryUtils.createBlock("tuff_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152496_))));
    public static final RegistryObject<Block> TUFF_PILLAR = RegistryUtils.createBlock("tuff_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152496_)));
    public static final RegistryObject<Block> CHISELED_TUFF = RegistryUtils.createBlock("chiseled_tuff", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152496_)));
    public static final RegistryObject<Block> HEAVY_TUFF_BRICKS = RegistryUtils.createBlock("heavy_tuff_bricks", () -> new BigBrickBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152496_), BigBrickBlock.BrickType.TUFF));
    public static final RegistryObject<Block> TUFF_LAMP = RegistryUtils.createBlock("tuff_lamp", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152496_).m_60953_(e -> 8)));
    public static final RegistryObject<Block> HELIODOR_ROD = RegistryUtils.createBlock("heliodor_rod", () -> new GlassLikePillarBlock(APBlockProperties.NETHER_CRYSTAL));
    public static final RegistryObject<Block> EKANITE_ROD = RegistryUtils.createBlock("ekanite_rod", () -> new GlassLikePillarBlock(APBlockProperties.NETHER_CRYSTAL));
    public static final RegistryObject<Block> MONAZITE_ROD = RegistryUtils.createBlock("monazite_rod", () -> new GlassLikePillarBlock(APBlockProperties.NETHER_CRYSTAL));
    public static final RegistryObject<Block> UNOBTANIUM_BLOCK = RegistryUtils.createBlock("unobtanium_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50721_)));
    public static final StoneBlockSet NETHER_BRASS = new StoneBlockSet(RegistryUtils.createBlock("nether_brass_block", () -> new Block(APBlockProperties.NETHER_BRASS)));
    public static final StoneBlockSet CUT_NETHER_BRASS = new StoneBlockSet(RegistryUtils.createBlock("cut_nether_brass", () -> new Block(APBlockProperties.NETHER_BRASS)));
    public static final RegistryObject<Block> NETHER_BRASS_PILLAR = RegistryUtils.createBlock("nether_brass_pillar", () -> new RotatedPillarBlock(APBlockProperties.NETHER_BRASS));
    public static final StoneBlockSet SMOOTH_NETHER_BRASS = new StoneBlockSet(RegistryUtils.createBlock("smooth_nether_brass", () -> new Block(APBlockProperties.NETHER_BRASS)), false).addSlabs().addStairs();
    public static final RegistryObject<Block> NETHER_BRASS_FIRE = RegistryUtils.createBlockNoItem("nether_brass_fire", () -> new GreenFireBlock(APBlockProperties.GREEN_FIRE));
    public static final RegistryObject<Block> NETHER_BRASS_CHAIN = RegistryUtils.createBlock("nether_brass_chain", () -> new ChainBlock(APBlockProperties.NETHER_BRASS.m_60918_(SoundType.f_56728_)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> NETHER_BRASS_LANTERN = RegistryUtils.createBlock("nether_brass_lantern", () -> new LanternBlock(APBlockProperties.NETHER_BRASS.m_60918_(SoundType.f_56762_).m_60953_(a -> 13)), CreativeModeTab.f_40750_);
    public static final RegistryObject<Block> NETHER_BRASS_TORCH = RegistryUtils.createBlockNoItem("nether_brass_torch", () -> new CustomTorchBlock(APBlockProperties.BRASS_TORCH, (Supplier<SimpleParticleType>)MiscRegistry.GREEN_FLAME));
    public static final RegistryObject<Block> NETHER_BRASS_WALL_TORCH = RegistryUtils.createBlockNoItem("nether_brass_wall_torch", () -> new CustomWallTorchBlock(APBlockProperties.BRASS_TORCH.m_60916_((Block)NETHER_BRASS_TORCH.get()), (Supplier<SimpleParticleType>)MiscRegistry.GREEN_FLAME));

    private static List<StoneBlockSet> addOreBricks() {
        List<String> ores = Arrays.asList("coal", "lapis", "redstone", "iron", "gold", "emerald", "diamond");
        LinkedList<StoneBlockSet> l = new LinkedList<StoneBlockSet>();
        ores.forEach(ore -> {
            StoneBlockSet set = new StoneBlockSet(RegistryUtils.createBlock(ore + "_ore_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50222_))));
            RegistryUtils.createBlock("cracked_" + ore + "_ore_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50224_)));
            RegistryUtils.createBlock("chiseled_" + ore + "_ore_bricks", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50225_)));
            l.add(set);
        });
        return l;
    }

    private static RegistryObject<Block> createPottedPlant(RegistryObject<Block> plant) {
        String name = plant.getId().m_135815_();
        RegistryObject pot = BLOCKS.register("potted_" + name, () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_.delegate.get(), (Supplier)plant, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50236_)));
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(plant.getId(), (Supplier)pot);
        return pot;
    }
}

