/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.worldgen.features;

import architectspalette.content.worldgen.features.configs.CrystalClusterConfig;
import architectspalette.core.registry.MiscRegistry;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class CrystalClusterFeature
extends Feature<CrystalClusterConfig> {
    public CrystalClusterFeature(Codec<CrystalClusterConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<CrystalClusterConfig> context) {
        if (!context.m_159774_().m_46859_(context.m_159777_())) {
            return false;
        }
        if (((CrystalClusterConfig)context.m_159778_()).hanging ? context.m_159774_().m_46859_(context.m_159777_().m_7494_()) : context.m_159774_().m_46859_(context.m_159777_().m_7495_())) {
            return false;
        }
        CrystalClusterConfig config = (CrystalClusterConfig)context.m_159778_();
        Random random = context.m_159776_();
        Vector3f shelfAngle = Vector3f.f_122222_.m_122281_();
        shelfAngle.m_122251_(Vector3f.f_122225_.m_122240_(random.nextFloat(360.0f)));
        Vector3f formationAngle = shelfAngle.m_122281_();
        formationAngle.m_122251_(Vector3f.f_122225_.m_122240_(CrystalClusterFeature.fRandomRange(random, -15.0f, 15.0f) + 90.0f));
        Vector3f placePos = new Vector3f((float)context.m_159777_().m_123341_(), (float)context.m_159777_().m_123342_(), (float)context.m_159777_().m_123343_());
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>(List.of());
        int shelves = CrystalClusterFeature.iRandomRange(random, 4, 7);
        for (int i = 0; i < shelves; ++i) {
            float scale = ((float)i + 1.0f) / (float)shelves;
            int pillars = CrystalClusterFeature.iRandomRange(random, 1, 7);
            CrystalClusterFeature.placeShelf(new BlockPos((double)placePos.m_122239_(), (double)placePos.m_122260_(), (double)placePos.m_122269_()), pillars, shelfAngle, scale, context, posList);
            formationAngle.m_122278_();
            formationAngle.m_122261_(CrystalClusterFeature.fRandomRange(random, 0.5f, 2.0f));
            placePos.m_122253_(formationAngle);
        }
        for (BlockPos pos : posList) {
            CrystalClusterFeature.tryPlaceExtrusion(pos, context.m_159774_(), config.extrusionState, config.crystalState.m_60734_(), config.hanging ? 1 : -1, random);
        }
        return true;
    }

    private static void placeShelf(BlockPos startPos, int crystals, Vector3f shelfAngle, float shelfScale, FeaturePlaceContext<CrystalClusterConfig> context, List<BlockPos> crystalList) {
        Random random = context.m_159776_();
        CrystalClusterConfig config = (CrystalClusterConfig)context.m_159778_();
        WorldGenLevel world = context.m_159774_();
        int flip = config.hanging ? 1 : -1;
        Vector3f placePos = new Vector3f((float)startPos.m_123341_(), (float)startPos.m_123342_(), (float)startPos.m_123343_());
        placePos.m_122272_(0.0f, (float)(-2 * flip), 0.0f);
        for (int i = 0; i < crystals; ++i) {
            Vector3f offset = shelfAngle.m_122281_();
            offset.m_122261_(CrystalClusterFeature.fRandomRange(random, 0.5f, 2.5f));
            placePos.m_122253_(offset);
            int pillarLength = config.minLength + random.nextInt((int)Math.floor((float)(config.maxLength - config.minLength) * shelfScale) + 1);
            CrystalClusterFeature.placePillar(new BlockPos.MutableBlockPos((double)placePos.m_122239_(), (double)placePos.m_122260_(), (double)placePos.m_122269_()), pillarLength, world, context, flip, crystalList);
            if (pillarLength <= (config.maxLength - config.minLength) / 2 || !random.nextBoolean()) continue;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos((double)(placePos.m_122239_() + (float)CrystalClusterFeature.iRandomRange(random, -1, 1)), (double)(placePos.m_122260_() + (float)CrystalClusterFeature.iRandomRange(random, -1, 1)), (double)(placePos.m_122269_() + (float)CrystalClusterFeature.iRandomRange(random, -1, 1)));
            CrystalClusterFeature.placePillar(pos, pillarLength / 2, world, context, flip, crystalList);
        }
    }

    private static void placePillar(BlockPos.MutableBlockPos placePos, int length, WorldGenLevel world, FeaturePlaceContext<CrystalClusterConfig> context, int flip, List<BlockPos> crystalList) {
        CrystalClusterConfig config = (CrystalClusterConfig)context.m_159778_();
        int tries = 10;
        while (CrystalClusterFeature.canReplaceAt(world, (BlockPos)placePos)) {
            placePos.m_142448_(placePos.m_123342_() + flip);
            if (world.m_8055_((BlockPos)placePos).m_60713_(Blocks.f_49991_)) {
                return;
            }
            if (tries-- != 0) continue;
            return;
        }
        tries = 5;
        while (!CrystalClusterFeature.canReplaceAt(world, (BlockPos)placePos)) {
            placePos.m_142448_(placePos.m_123342_() - flip);
            if (tries-- != 0) continue;
            return;
        }
        boolean doExtrusion = true;
        while (--length >= 0) {
            if (!CrystalClusterFeature.canReplaceAt(world, (BlockPos)placePos)) {
                return;
            }
            if (doExtrusion) {
                crystalList.add(placePos.m_7949_());
                doExtrusion = false;
            }
            world.m_7731_((BlockPos)placePos, config.crystalState, 2);
            placePos.m_142448_(placePos.m_123342_() - flip);
        }
    }

    private static void tryPlaceExtrusion(BlockPos startPos, WorldGenLevel level, BlockState placeState, Block avoidBlock, int flip, Random random) {
        for (Direction dir : Direction.values()) {
            if (dir.m_122434_() == Direction.Axis.Y || random.nextInt(3) != 1) continue;
            BlockPos pos = startPos.m_5484_(dir, 1);
            while (level.m_8055_(pos).m_60713_(placeState.m_60734_()) && Math.abs(startPos.m_123342_() - pos.m_123342_()) <= 4) {
                pos = pos.m_6625_(flip);
            }
            BlockPos above = pos.m_7494_();
            BlockPos below = pos.m_7495_();
            if (!(CrystalClusterFeature.canReplaceAt(level, above) ^ CrystalClusterFeature.canReplaceAt(level, below)) || level.m_8055_(above).m_60713_(avoidBlock) || level.m_8055_(below).m_60713_(avoidBlock)) continue;
            for (int i = CrystalClusterFeature.iRandomRange(random, 1, 2); i > 0 && CrystalClusterFeature.canReplaceAt(level, pos); --i) {
                level.m_7731_(pos, placeState, 2);
                pos = pos.m_6625_(flip);
            }
        }
    }

    private static int iRandomRange(Random random, int min, int max) {
        return min + random.nextInt(max - min + 1);
    }

    private static float fRandomRange(Random random, float min, float max) {
        return min + random.nextFloat(max - min);
    }

    private static boolean canReplaceAt(WorldGenLevel level, BlockPos pos) {
        return CrystalClusterFeature.canReplace(level.m_8055_(pos));
    }

    private static boolean canReplace(BlockState state) {
        return state.m_60795_() || state.m_60767_().m_76336_() || state.m_204336_(MiscRegistry.CRYSTAL_REPLACEABLE);
    }
}

