/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks.abyssaline;

import architectspalette.content.blocks.abyssaline.AbyssalineHelper;
import architectspalette.content.blocks.abyssaline.IAbyssalineChargeable;
import architectspalette.content.blocks.abyssaline.NewAbyssalineBlock;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class AbyssalinePillarBlock
extends RotatedPillarBlock
implements IAbyssalineChargeable {
    public AbyssalinePillarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NewAbyssalineBlock.CHARGE_SOURCE, (Comparable)Direction.NORTH)).m_61124_((Property)NewAbyssalineBlock.CHARGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_55923_, NewAbyssalineBlock.CHARGED, NewAbyssalineBlock.CHARGE_SOURCE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        context.m_43725_().m_186460_(context.m_8083_(), (Block)this, 1);
        return super.m_5573_(context);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        AbyssalineHelper.abyssalineNeighborUpdate(this, state, worldIn, pos, blockIn, fromPos);
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        AbyssalineHelper.abyssalineTick(state, worldIn, pos);
    }

    @Override
    public boolean acceptsChargeFrom(BlockState stateIn, Direction faceIn) {
        return faceIn.m_122434_() == stateIn.m_61143_((Property)f_55923_);
    }

    @Override
    public boolean outputsChargeFrom(BlockState stateIn, Direction faceIn) {
        return this.isCharged(stateIn) && faceIn != this.getSourceDirection(stateIn) && faceIn.m_122434_() == stateIn.m_61143_((Property)f_55923_);
    }

    @Override
    public boolean pushesPower(BlockState stateIn) {
        return true;
    }

    @Override
    public boolean pullsPowerFrom(BlockState stateIn, Direction faceIn) {
        return faceIn.m_122434_() == stateIn.m_61143_((Property)f_55923_);
    }

    private static Direction directionFromAxis(Direction.Axis axis, Integer i) {
        switch (axis) {
            case X: {
                return i > 0 ? Direction.EAST : Direction.WEST;
            }
            case Y: {
                return i > 0 ? Direction.UP : Direction.DOWN;
            }
            case Z: {
                return i > 0 ? Direction.SOUTH : Direction.NORTH;
            }
        }
        return Direction.UP;
    }

    private PillarSide fromScalar(int integer) {
        return integer > 0 ? PillarSide.FRONT : PillarSide.BACK;
    }

    private static enum PillarSide implements StringRepresentable
    {
        FRONT,
        BACK;


        public int toScalar() {
            return this == FRONT ? 1 : -1;
        }

        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return this == FRONT ? "front" : "back";
        }
    }
}

