/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.content.blocks.abyssaline;

import architectspalette.core.registry.APBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class AbyssalineBlock
extends Block {
    public static final BooleanProperty CHARGED = BooleanProperty.m_61465_((String)"charged");

    public AbyssalineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CHARGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)this.m_49966_().m_61124_((Property)CHARGED, (Comparable)Boolean.valueOf(AbyssalineBlock.checkForNearbyChargedBlocks(worldIn, currentPos)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)CHARGED, (Comparable)Boolean.valueOf(AbyssalineBlock.checkForNearbyChargedBlocks((LevelAccessor)context.m_43725_(), context.m_8083_())));
    }

    public static boolean checkForNearbyChargedBlocks(LevelAccessor world, BlockPos pos) {
        BlockState state;
        BlockPos offset;
        boolean powered = false;
        for (Direction sides : Direction.values()) {
            offset = pos.m_142300_(sides);
            state = world.m_8055_(offset);
            if (state.m_60734_() != APBlocks.CHISELED_ABYSSALINE_BRICKS.get() || !((Boolean)state.m_61143_((Property)CHARGED)).booleanValue()) continue;
            powered = true;
            break;
        }
        if (!powered) {
            for (Direction sides : Direction.values()) {
                offset = pos.m_142300_(sides);
                state = world.m_8055_(offset);
                if (!AbyssalineBlock.isChargedBlock(state)) continue;
                return AbyssalineBlock.checkForNearbySource(world, offset, sides.m_122424_(), 1);
            }
        }
        return powered;
    }

    private static boolean checkForNearbySource(LevelAccessor world, BlockPos pos, Direction blacklistedDirection, int cycles) {
        BlockPos offset;
        BlockState state;
        if (cycles == 2) {
            return false;
        }
        boolean powered = false;
        for (Direction sides : Direction.values()) {
            if (sides == blacklistedDirection || (state = world.m_8055_(offset = pos.m_142300_(sides))).m_60734_() != APBlocks.CHISELED_ABYSSALINE_BRICKS.get() || !((Boolean)state.m_61143_((Property)CHARGED)).booleanValue()) continue;
            powered = true;
            break;
        }
        if (!powered) {
            for (Direction sides : Direction.values()) {
                offset = pos.m_142300_(sides);
                state = world.m_8055_(offset);
                if (!AbyssalineBlock.isChargedBlock(state)) continue;
                return AbyssalineBlock.checkForNearbySource(world, offset, sides.m_122424_(), cycles + 1);
            }
        }
        return powered;
    }

    public static boolean isChargedBlock(BlockState state) {
        return state.m_60734_() != APBlocks.CHISELED_ABYSSALINE_BRICKS.get() && state.m_61138_((Property)CHARGED) && (Boolean)state.m_61143_((Property)CHARGED) != false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CHARGED});
    }
}

