/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.compat;

import architectspalette.compat.WarpingRecipeCategory;
import architectspalette.content.blocks.BigBrickBlock;
import architectspalette.content.blocks.CageLanternBlock;
import architectspalette.core.crafting.WarpingRecipe;
import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.util.StoneBlockSet;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = new ResourceLocation("architects_palette", "jei_plugin");
    public static final RecipeType<WarpingRecipe> WARPING = RecipeType.create((String)"architects_palette", (String)"warping", WarpingRecipe.class);

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new WarpingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(WARPING, Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)WarpingRecipe.TYPE));
        JEIPlugin.addItemInfo(registration, APBlocks.CHISELED_ABYSSALINE_BRICKS, "chiseled_chargeable");
        Stream.of(APBlocks.ABYSSALINE, APBlocks.ABYSSALINE_BRICKS, APBlocks.ABYSSALINE_PILLAR, APBlocks.ABYSSALINE_BRICK_SLAB, APBlocks.ABYSSALINE_TILES, APBlocks.ABYSSALINE_TILE_SLAB, APBlocks.ABYSSALINE_LAMP_BLOCK, APBlocks.ABYSSALINE_BRICK_VERTICAL_SLAB, APBlocks.ABYSSALINE_TILE_VERTICAL_SLAB).forEach(i -> JEIPlugin.addItemInfo(registration, (RegistryObject<? extends ItemLike>)i, "chargeable"));
        Stream.of(APBlocks.PLACID_ACACIA_TOTEM, APBlocks.GRINNING_ACACIA_TOTEM, APBlocks.SHOCKED_ACACIA_TOTEM, APBlocks.BLANK_ACACIA_TOTEM).forEach(i -> JEIPlugin.addItemInfo(registration, (RegistryObject<? extends ItemLike>)i, "totem_carving"));
        Stream.of(APBlocks.FLINT_BLOCK, APBlocks.FLINT_PILLAR).forEach(i -> JEIPlugin.addItemInfo(registration, (RegistryObject<? extends ItemLike>)i, "flint_damage"));
        JEIPlugin.addItemInfo(registration, APBlocks.FLINT_TILES, "flint_damage");
        Stream.of(APBlocks.MOONSTONE, APBlocks.SUNSTONE).forEach(i -> JEIPlugin.addItemInfo(registration, (RegistryObject<? extends ItemLike>)i, "celestial_stones"));
        Stream.of(APBlocks.NETHER_BRASS, APBlocks.CUT_NETHER_BRASS, APBlocks.SMOOTH_NETHER_BRASS).forEach(i -> JEIPlugin.addItemInfo(registration, i, "nether_brass"));
        JEIPlugin.addItemInfo(registration, APBlocks.NETHER_BRASS_PILLAR, "nether_brass");
        APBlocks.BLOCKS.getEntries().forEach(block -> {
            if (block.get() instanceof BigBrickBlock) {
                JEIPlugin.addItemInfo(registration, (RegistryObject<? extends ItemLike>)block, "heavy_bricks");
            } else if (block.get() instanceof CageLanternBlock) {
                JEIPlugin.addItemInfo(registration, (RegistryObject<? extends ItemLike>)block, "cage_lanterns");
            }
        });
    }

    private static void addItemInfo(IRecipeRegistration register, RegistryObject<? extends ItemLike> item, String infoString) {
        JEIPlugin.addItemInfo(register, (ItemLike)item.get(), infoString);
    }

    private static void addItemInfo(IRecipeRegistration register, StoneBlockSet stoneSet, String infoString) {
        stoneSet.forEach(block -> JEIPlugin.addItemInfo(register, (ItemLike)block, infoString));
    }

    private static void addItemInfo(IRecipeRegistration register, ItemLike item, String infoString) {
        register.addIngredientInfo((Object)new ItemStack(item), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("architects_palette.info." + infoString)});
    }
}

