/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.IntegerEnterEvent;
import mcjty.lib.gui.events.IntegerEvent;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import org.lwjgl.glfw.GLFW;

public class IntegerField
extends AbstractWidget<IntegerField> {
    public static final String TYPE_INTEGERFIELD = "integerfield";
    public static final Key<Integer> PARAM_INTEGER = new Key<Integer>("integer", Type.INTEGER);
    public static final boolean DEFAULT_EDITABLE = true;
    private String text = "";
    private int cursor = 0;
    private int startOffset = 0;
    private int selection = -1;
    private List<IntegerEvent> integerEvents = null;
    private List<IntegerEnterEvent> integerEnterEvents = null;
    private boolean editable = true;

    public boolean isEditable() {
        return this.editable;
    }

    public IntegerField editable(boolean editable) {
        this.editable = editable;
        return this;
    }

    public int getInt() {
        try {
            return Integer.parseInt(this.text);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public IntegerField integer(int value) {
        if (this.getInt() == value) {
            return this;
        }
        this.text = Integer.toString(value);
        if (this.cursor > this.text.length()) {
            this.cursor = this.text.length();
        }
        if (this.startOffset >= this.cursor) {
            this.startOffset = this.cursor - 1;
            if (this.startOffset < 0) {
                this.startOffset = 0;
            }
        }
        return this;
    }

    @Override
    public Widget<?> mouseClick(double x, double y, int button) {
        if (this.isEnabledAndVisible() && this.editable) {
            this.window.setTextFocus(this);
            if (button == 1) {
                this.integer(0);
                this.fireIntegerEvents(0);
            }
            return this;
        }
        return null;
    }

    private static boolean isControlDown() {
        long handle = Minecraft.m_91087_().m_91268_().m_85439_();
        return InputConstants.m_84830_((long)handle, (int)341) || InputConstants.m_84830_((long)handle, (int)345);
    }

    @Override
    public boolean keyTyped(int keyCode, int scanCode) {
        boolean rc = super.keyTyped(keyCode, scanCode);
        if (rc) {
            return true;
        }
        if (this.isEnabledAndVisible() && this.editable) {
            long handle = Minecraft.m_91087_().m_91268_().m_85439_();
            if (IntegerField.isControlDown()) {
                if (keyCode == 86) {
                    String data = GLFW.glfwGetClipboardString((long)handle);
                    if (data != null) {
                        if (this.isRegionSelected()) {
                            this.replaceSelectedRegion(data);
                        } else {
                            this.text = this.text.substring(0, this.cursor) + data + this.text.substring(this.cursor);
                        }
                        this.cursor += data.length();
                        this.fireIntegerEvents(this.getInt());
                    }
                } else if (keyCode == 67) {
                    if (this.isRegionSelected()) {
                        GLFW.glfwSetClipboardString((long)handle, (CharSequence)this.getSelectedText());
                    }
                } else if (keyCode == 88) {
                    if (this.isRegionSelected()) {
                        GLFW.glfwSetClipboardString((long)handle, (CharSequence)this.getSelectedText());
                        this.replaceSelectedRegion("");
                        this.fireIntegerEvents(this.getInt());
                    }
                } else if (keyCode == 65) {
                    this.selectAll();
                } else if (keyCode == 263) {
                    this.updateSelection();
                    if (this.cursor > 0) {
                        this.cursor = this.findNextWord(true);
                    }
                } else if (keyCode == 262) {
                    this.updateSelection();
                    if (this.cursor < this.text.length()) {
                        this.cursor = this.findNextWord(false);
                    }
                }
            } else {
                if (keyCode == 257) {
                    this.fireIntegerEnterEvents(this.getInt());
                    return false;
                }
                if (keyCode == 256) {
                    return false;
                }
                if (keyCode == 259) {
                    if (this.isRegionSelected()) {
                        this.replaceSelectedRegion("");
                        this.fireIntegerEvents(this.getInt());
                    } else if (!this.text.isEmpty() && this.cursor > 0) {
                        this.text = this.text.substring(0, this.cursor - 1) + this.text.substring(this.cursor);
                        --this.cursor;
                        this.fireIntegerEvents(this.getInt());
                    }
                } else if (keyCode == 261) {
                    if (this.isRegionSelected()) {
                        this.replaceSelectedRegion("");
                        this.fireIntegerEvents(this.getInt());
                    } else if (this.cursor < this.text.length()) {
                        this.text = this.text.substring(0, this.cursor) + this.text.substring(this.cursor + 1);
                        this.fireIntegerEvents(this.getInt());
                    }
                } else if (keyCode == 268) {
                    this.updateSelection();
                    this.cursor = 0;
                } else if (keyCode == 269) {
                    this.updateSelection();
                    this.cursor = this.text.length();
                } else if (keyCode == 263) {
                    this.updateSelection();
                    if (this.cursor > 0) {
                        --this.cursor;
                    }
                } else if (keyCode == 262) {
                    this.updateSelection();
                    if (this.cursor < this.text.length()) {
                        ++this.cursor;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean charTyped(char codePoint) {
        if (this.isEnabledAndVisible() && this.editable) {
            if (this.isRegionSelected()) {
                this.replaceSelectedRegion(Character.toString(codePoint));
                ++this.cursor;
                this.fireIntegerEvents(this.getInt());
                return true;
            }
            if (Character.isDigit(codePoint) || codePoint == '-') {
                this.text = this.text.substring(0, this.cursor) + codePoint + this.text.substring(this.cursor);
                ++this.cursor;
                this.fireIntegerEvents(this.getInt());
                return true;
            }
        }
        return false;
    }

    private int calculateVerticalOffset() {
        Objects.requireNonNull(this.mc.f_91062_);
        int h = 9;
        return (this.bounds.height - h) / 2;
    }

    private void ensureVisible() {
        if (this.cursor > this.text.length()) {
            this.cursor = this.text.length();
        }
        if (this.cursor < this.startOffset) {
            this.startOffset = this.cursor;
        } else {
            int w = this.mc.f_91062_.m_92895_(this.text.substring(this.startOffset, this.cursor));
            while (w > this.bounds.width - 12) {
                ++this.startOffset;
                w = this.mc.f_91062_.m_92895_(this.text.substring(this.startOffset, this.cursor));
            }
        }
    }

    public void selectAll() {
        this.setSelection(0, this.text.length());
    }

    public void setSelection(int start, int end) {
        this.selection = start;
        this.cursor = end;
    }

    public void clearSelection() {
        this.selection = -1;
    }

    public boolean isRegionSelected() {
        return this.selection != -1;
    }

    public int getSelectionStart() {
        return Math.min(this.cursor, this.selection);
    }

    public int getSelectionEnd() {
        return Math.max(this.cursor, this.selection);
    }

    public String getSelectedText() {
        return this.text.substring(this.getSelectionStart(), this.getSelectionEnd());
    }

    public void replaceSelectedRegion(String replacement) {
        int selectionStart = this.getSelectionStart();
        this.text = this.text.substring(0, selectionStart) + replacement + this.text.substring(this.getSelectionEnd());
        this.cursor = selectionStart;
        this.clearSelection();
    }

    private void updateSelection() {
        if (Screen.m_96638_()) {
            if (!this.isRegionSelected()) {
                this.selection = this.cursor;
            }
        } else {
            this.clearSelection();
        }
    }

    private int findNextWord(boolean reversed) {
        char c;
        int change = reversed ? -1 : 1;
        int i = this.cursor;
        int last = 32;
        while ((i += change) >= 0 && i < this.text.length() && ((c = this.text.charAt(i)) != ' ' || last == 32)) {
            last = c;
        }
        if (reversed) {
            return i - change;
        }
        return i;
    }

    @Override
    public void draw(Screen gui, PoseStack matrixStack, int x, int y) {
        super.draw(gui, matrixStack, x, y);
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        this.ensureVisible();
        int col = StyleConfig.colorTextFieldFiller;
        if (this.window.getTextFocus() == this) {
            col = StyleConfig.colorTextFieldFocusedFiller;
        } else if (this.isHovering()) {
            col = StyleConfig.colorTextFieldHoveringFiller;
        }
        RenderHelper.drawThickBeveledBox(matrixStack, xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1, 1, StyleConfig.colorTextFieldTopLeft, StyleConfig.colorTextFieldBottomRight, col);
        String renderedText = this.mc.f_91062_.m_92834_(this.text.substring(this.startOffset), this.bounds.width - 10);
        int textX = x + 5 + this.bounds.x;
        int textY = y + this.calculateVerticalOffset() + this.bounds.y;
        if (this.isEnabled()) {
            if (this.isEditable()) {
                this.mc.f_91062_.m_92883_(matrixStack, renderedText, (float)textX, (float)textY, -16777216);
            } else {
                this.mc.f_91062_.m_92883_(matrixStack, renderedText, (float)textX, (float)textY, -13421773);
            }
            if (this.isRegionSelected()) {
                int selectionStart = this.getSelectionStart();
                int selectionEnd = this.getSelectionEnd();
                int renderedStart = Mth.m_14045_((int)(selectionStart - this.startOffset), (int)0, (int)renderedText.length());
                int renderedEnd = Mth.m_14045_((int)(selectionEnd - this.startOffset), (int)0, (int)renderedText.length());
                String renderedSelection = renderedText.substring(renderedStart, renderedEnd);
                String renderedPreSelection = renderedText.substring(0, renderedStart);
                int selectionX = textX + this.mc.f_91062_.m_92895_(renderedPreSelection);
                int selectionWidth = this.mc.f_91062_.m_92895_(renderedSelection);
                Objects.requireNonNull(this.mc.f_91062_);
                RenderHelper.drawColorLogic(selectionX - 1, textY, selectionWidth + 1, 9, 60, 147, 242, GlStateManager.LogicOp.OR_REVERSE);
            }
        } else {
            this.mc.f_91062_.m_92883_(matrixStack, renderedText, (float)textX, (float)textY, -6250336);
        }
        if (this.window.getTextFocus() == this) {
            int w = this.mc.f_91062_.m_92895_(this.text.substring(this.startOffset, this.cursor));
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)(xx + 5 + w), (int)(yy + 2), (int)(xx + 5 + w + 1), (int)(yy + this.bounds.height - 3), (int)StyleConfig.colorTextFieldCursor);
        }
    }

    public IntegerField event(IntegerEvent event) {
        if (this.integerEvents == null) {
            this.integerEvents = new ArrayList<IntegerEvent>();
        }
        this.integerEvents.add(event);
        return this;
    }

    public void removeIntegerEvent(IntegerEvent event) {
        if (this.integerEvents != null) {
            this.integerEvents.remove(event);
        }
    }

    private void fireIntegerEvents(int newValue) {
        this.fireChannelEvents(TypedMap.builder().put(Window.PARAM_ID, "integer").put(PARAM_INTEGER, newValue).build());
        if (this.integerEvents != null) {
            for (IntegerEvent event : this.integerEvents) {
                event.intChanged(newValue);
            }
        }
    }

    public IntegerField addIntegerEnterEvent(IntegerEnterEvent event) {
        if (this.integerEnterEvents == null) {
            this.integerEnterEvents = new ArrayList<IntegerEnterEvent>();
        }
        this.integerEnterEvents.add(event);
        return this;
    }

    public void removeIntegerEnterEvent(IntegerEnterEvent event) {
        if (this.integerEnterEvents != null) {
            this.integerEnterEvents.remove(event);
        }
    }

    private void fireIntegerEnterEvents(int newValue) {
        this.fireChannelEvents(TypedMap.builder().put(Window.PARAM_ID, "enter").put(PARAM_INTEGER, newValue).build());
        if (this.integerEnterEvents != null) {
            for (IntegerEnterEvent event : this.integerEnterEvents) {
                event.integerEntered(newValue);
            }
        }
    }

    @Override
    public void readFromGuiCommand(GuiParser.GuiCommand command) {
        super.readFromGuiCommand(command);
        this.editable = GuiParser.get(command, "editable", true);
    }

    @Override
    public void fillGuiCommand(GuiParser.GuiCommand command) {
        super.fillGuiCommand(command);
        GuiParser.put(command, "editable", this.editable, true);
    }

    @Override
    public GuiParser.GuiCommand createGuiCommand() {
        return new GuiParser.GuiCommand(TYPE_INTEGERFIELD);
    }

    @Override
    public <T> void setGenericValue(T value) {
        if (value == null) {
            this.integer(0);
        } else {
            try {
                this.integer(Integer.parseInt(value.toString()));
            }
            catch (NumberFormatException e) {
                this.integer(0);
            }
        }
    }

    @Override
    public Object getGenericValue(Type<?> type) {
        if (Type.INTEGER.equals(type)) {
            return this.getInt();
        }
        if (Type.STRING.equals(type)) {
            return this.text;
        }
        if (Type.DOUBLE.equals(type)) {
            try {
                return Double.parseDouble(this.text);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        if (Type.FLOAT.equals(type)) {
            try {
                return Float.valueOf(Float.parseFloat(this.text));
            }
            catch (NumberFormatException e) {
                return Float.valueOf(0.0f);
            }
        }
        return this.getInt();
    }
}

