/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.compat.theoneprobe;

import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.compat.theoneprobe.TOPInfoProvider;
import mcjty.lib.multipart.MultipartBlock;
import mcjty.lib.multipart.MultipartHelper;
import mcjty.lib.multipart.MultipartTE;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class McJtyLibTOPDriver
implements TOPDriver {
    public static final McJtyLibTOPDriver DRIVER = new McJtyLibTOPDriver();

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        if (blockState.m_60734_() == Registration.MULTIPART_BLOCK) {
            MultipartTE.Part part = MultipartBlock.getHitPart(blockState, (BlockGetter)world, data.getPos(), MultipartHelper.getPlayerEyes(player), data.getHitVec());
            if (part != null) {
                if (part.getTileEntity() instanceof TOPInfoProvider) {
                    TOPDriver driver = ((TOPInfoProvider)part.getTileEntity()).getProbeDriver();
                    if (driver != null) {
                        driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
                    }
                } else if (part.getState().m_60734_() instanceof TOPInfoProvider) {
                    TOPDriver driver = ((TOPInfoProvider)part.getState().m_60734_()).getProbeDriver();
                    driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
                }
            }
        } else if (blockState.m_60734_() instanceof BaseBlock) {
            this.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }

    public void addStandardProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        BlockEntity te;
        if (mode == ProbeMode.EXTENDED && (te = world.m_7702_(data.getPos())) instanceof GenericTileEntity) {
            GenericTileEntity generic = (GenericTileEntity)te;
            te.getCapability(CapabilityInfusable.INFUSABLE_CAPABILITY).ifPresent(h -> {
                int infused = h.getInfused();
                int pct = infused * 100 / (Integer)GeneralConfig.maxInfuse.get();
                probeInfo.text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text("Infused: " + pct + "%"));
            });
            if (((Boolean)GeneralConfig.manageOwnership.get()).booleanValue() && generic.getOwnerName() != null && !generic.getOwnerName().isEmpty()) {
                int securityChannel = generic.getSecurityChannel();
                if (securityChannel == -1) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text("Owned by: " + generic.getOwnerName()));
                } else {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text("Owned by: " + generic.getOwnerName() + " (channel " + securityChannel + ")"));
                }
                if (generic.getOwnerUUID() == null) {
                    probeInfo.text(CompoundText.create().style(TextStyleClass.ERROR).text("Warning! Ownership not correctly set! Please place block again!"));
                }
            }
        }
    }
}

