/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import org.apache.commons.lang3.mutable.MutableInt;

public class InventoryHelper {
    private InventoryHelper() {
    }

    public static Optional<ItemStack> getItemFromEitherHand(Player player, Item item) {
        ItemStack mainHandItem = player.m_21205_();
        if (mainHandItem.m_41720_() == item) {
            return Optional.of(mainHandItem);
        }
        ItemStack offhandItem = player.m_21206_();
        if (offhandItem.m_41720_() == item) {
            return Optional.of(offhandItem);
        }
        return Optional.empty();
    }

    public static boolean hasItem(IItemHandler inventory, Predicate<ItemStack> matches) {
        AtomicBoolean result = new AtomicBoolean(false);
        InventoryHelper.iterate(inventory, (slot, stack) -> {
            if (!stack.m_41619_() && matches.test((ItemStack)stack)) {
                result.set(true);
            }
        }, result::get);
        return result.get();
    }

    public static Set<Integer> getItemSlots(IItemHandler inventory, Predicate<ItemStack> matches) {
        HashSet<Integer> slots = new HashSet<Integer>();
        InventoryHelper.iterate(inventory, (slot, stack) -> {
            if (!stack.m_41619_() && matches.test((ItemStack)stack)) {
                slots.add((Integer)slot);
            }
        });
        return slots;
    }

    public static void copyTo(IItemHandlerModifiable handlerA, IItemHandlerModifiable handlerB) {
        int slotsA = handlerA.getSlots();
        int slotsB = handlerB.getSlots();
        for (int slot = 0; slot < slotsA && slot < slotsB; ++slot) {
            ItemStack slotStack = handlerA.getStackInSlot(slot);
            if (slotStack.m_41619_()) continue;
            handlerB.setStackInSlot(slot, slotStack);
        }
    }

    public static List<ItemStack> insertIntoInventory(List<ItemStack> stacks, IItemHandler inventory, boolean simulate) {
        if (stacks.isEmpty()) {
            return stacks;
        }
        IItemHandler targetInventory = inventory;
        if (simulate) {
            targetInventory = InventoryHelper.cloneInventory(inventory);
        }
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            ItemStack result = InventoryHelper.insertIntoInventory(stack, targetInventory, false);
            if (result.m_41619_()) continue;
            remaining.add(result);
        }
        return remaining;
    }

    public static IItemHandler cloneInventory(IItemHandler inventory) {
        ItemStackHandler cloned = new ItemStackHandler(inventory.getSlots());
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            cloned.insertItem(slot, inventory.getStackInSlot(slot).m_41777_(), false);
        }
        return cloned;
    }

    public static ItemStack insertIntoInventory(ItemStack stack, IItemHandler inventory, boolean simulate) {
        if (inventory instanceof IItemHandlerSimpleInserter) {
            IItemHandlerSimpleInserter itemHandlerSimpleInserter = (IItemHandlerSimpleInserter)inventory;
            return itemHandlerSimpleInserter.insertItem(stack, simulate);
        }
        ItemStack remainingStack = stack.m_41777_();
        int slots = inventory.getSlots();
        for (int slot = 0; slot < slots && !remainingStack.m_41619_(); ++slot) {
            remainingStack = inventory.insertItem(slot, remainingStack, simulate);
        }
        return remainingStack;
    }

    public static ItemStack extractFromInventory(Item item, int count, IItemHandler inventory, boolean simulate) {
        ItemStack ret = ItemStack.f_41583_;
        int slots = inventory.getSlots();
        for (int slot = 0; slot < slots && ret.m_41613_() < count; ++slot) {
            ItemStack slotStack = inventory.getStackInSlot(slot);
            if (slotStack.m_41720_() != item || !ret.m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)ret, (ItemStack)slotStack)) continue;
            int toExtract = Math.min(slotStack.m_41613_(), count - ret.m_41613_());
            ItemStack extractedStack = inventory.extractItem(slot, toExtract, simulate);
            if (ret.m_41619_()) {
                ret = extractedStack;
                continue;
            }
            ret.m_41764_(ret.m_41613_() + extractedStack.m_41613_());
        }
        return ret;
    }

    public static ItemStack extractFromInventory(ItemStack stack, IItemHandler inventory, boolean simulate) {
        int extractedCount = 0;
        int slots = inventory.getSlots();
        for (int slot = 0; slot < slots && extractedCount < stack.m_41613_(); ++slot) {
            ItemStack slotStack = inventory.getStackInSlot(slot);
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)slotStack)) continue;
            int toExtract = Math.min(slotStack.m_41613_(), stack.m_41613_() - extractedCount);
            extractedCount += inventory.extractItem(slot, toExtract, simulate).m_41613_();
        }
        if (extractedCount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack result = stack.m_41777_();
        result.m_41764_(extractedCount);
        return result;
    }

    public static ItemStack runPickupOnPickupResponseUpgrades(Level world, UpgradeHandler upgradeHandler, ItemStack remainingStack, boolean simulate) {
        return InventoryHelper.runPickupOnPickupResponseUpgrades(world, null, upgradeHandler, remainingStack, simulate);
    }

    public static ItemStack runPickupOnPickupResponseUpgrades(Level world, @Nullable Player player, UpgradeHandler upgradeHandler, ItemStack remainingStack, boolean simulate) {
        List<IPickupResponseUpgrade> pickupUpgrades = upgradeHandler.getWrappersThatImplement(IPickupResponseUpgrade.class);
        for (IPickupResponseUpgrade pickupUpgrade : pickupUpgrades) {
            int countBeforePickup = remainingStack.m_41613_();
            remainingStack = pickupUpgrade.pickup(world, remainingStack, simulate);
            if (!simulate && player != null && remainingStack.m_41613_() != countBeforePickup) {
                InventoryHelper.playPickupSound(world, player);
            }
            if (!remainingStack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return remainingStack;
    }

    private static void playPickupSound(Level world, @Nonnull Player player) {
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 1.4f + 2.0f);
    }

    public static void iterate(IItemHandler handler, BiConsumer<Integer, ItemStack> actOn) {
        InventoryHelper.iterate(handler, actOn, () -> false);
    }

    public static void iterate(IItemHandler handler, BiConsumer<Integer, ItemStack> actOn, BooleanSupplier shouldExit) {
        int slots = handler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            actOn.accept(slot, stack);
            if (shouldExit.getAsBoolean()) break;
        }
    }

    public static int getCountMissingInHandler(IItemHandler itemHandler, ItemStack filter, int expectedCount) {
        MutableInt missingCount = new MutableInt(expectedCount);
        InventoryHelper.iterate(itemHandler, (slot, stack) -> {
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)filter)) {
                missingCount.subtract(Math.min(stack.m_41613_(), missingCount.getValue()));
            }
        }, () -> missingCount.getValue() == 0);
        return missingCount.getValue();
    }

    public static <T> T iterate(IItemHandler handler, BiFunction<Integer, ItemStack, T> getFromSlotStack, Supplier<T> supplyDefault, Predicate<T> shouldExit) {
        T ret = supplyDefault.get();
        int slots = handler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            ret = getFromSlotStack.apply(slot, stack);
            if (shouldExit.test(ret)) break;
        }
        return ret;
    }

    public static void transfer(IItemHandler handlerA, IItemHandler handlerB, Consumer<Supplier<ItemStack>> onInserted) {
        InventoryHelper.transfer(handlerA, handlerB, onInserted, s -> true);
    }

    public static void transfer(IItemHandler handlerA, IItemHandler handlerB, Consumer<Supplier<ItemStack>> onInserted, Predicate<ItemStack> canTransferStack) {
        InventoryHelper.transfer(handlerA, handlerB, -1, onInserted, canTransferStack);
    }

    private static void transfer(IItemHandler handlerA, IItemHandler handlerB, int slotB, Consumer<Supplier<ItemStack>> onInserted, Predicate<ItemStack> canTransferStack) {
        int slotsA = handlerA.getSlots();
        for (int slot = 0; slot < slotsA; ++slot) {
            ItemStack slotStack = handlerA.getStackInSlot(slot);
            if (slotStack.m_41619_() || !canTransferStack.test(slotStack)) continue;
            ItemStack resultStack = slotB == -1 ? InventoryHelper.insertIntoInventory(slotStack, handlerB, true) : handlerB.insertItem(slotB, slotStack, true);
            int countToExtract = slotStack.m_41613_() - resultStack.m_41613_();
            if (countToExtract <= 0 || handlerA.extractItem(slot, countToExtract, true).m_41613_() != countToExtract) continue;
            if (slotB == -1) {
                InventoryHelper.insertIntoInventory(handlerA.extractItem(slot, countToExtract, false), handlerB, false);
            } else {
                handlerB.insertItem(slotB, handlerA.extractItem(slot, countToExtract, false), false);
            }
            onInserted.accept(() -> {
                ItemStack copiedStack = slotStack.m_41777_();
                copiedStack.m_41764_(countToExtract);
                return copiedStack;
            });
        }
    }

    public static void transferIntoSlot(IItemHandler handlerA, IItemHandler handlerB, int slotB, Predicate<ItemStack> canTransferStack) {
        InventoryHelper.transfer(handlerA, handlerB, slotB, s -> {}, canTransferStack);
    }

    public static boolean isEmpty(IItemHandler itemHandler) {
        int slots = itemHandler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            if (itemHandler.getStackInSlot(slot).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static ItemStack getAndRemove(IItemHandler itemHandler, int slot) {
        if (slot >= itemHandler.getSlots()) {
            return ItemStack.f_41583_;
        }
        return itemHandler.extractItem(slot, itemHandler.getStackInSlot(slot).m_41613_(), false);
    }

    public static void insertOrDropItem(Player player, ItemStack stack, IItemHandler ... inventories) {
        ItemStack ret = stack;
        for (IItemHandler inventory : inventories) {
            if (!(ret = InventoryHelper.insertIntoInventory(ret, inventory, false)).m_41619_()) continue;
            return;
        }
        if (!ret.m_41619_()) {
            player.m_36176_(ret, true);
        }
    }

    static Map<ItemStackKey, Integer> getCompactedStacks(IItemHandler handler) {
        return InventoryHelper.getCompactedStacks(handler, new HashSet<Integer>());
    }

    static Map<ItemStackKey, Integer> getCompactedStacks(IItemHandler handler, Set<Integer> ignoreSlots) {
        HashMap<ItemStackKey, Integer> ret = new HashMap<ItemStackKey, Integer>();
        InventoryHelper.iterate(handler, (slot, stack) -> {
            if (stack.m_41619_() || ignoreSlots.contains(slot)) {
                return;
            }
            ItemStackKey itemStackKey = new ItemStackKey((ItemStack)stack);
            ret.put(itemStackKey, ret.computeIfAbsent(itemStackKey, fs -> 0) + stack.m_41613_());
        });
        return ret;
    }

    public static List<ItemStack> getCompactedStacksSortedByCount(IItemHandler handler) {
        Map<ItemStackKey, Integer> compactedStacks = InventoryHelper.getCompactedStacks(handler);
        ArrayList<Map.Entry<ItemStackKey, Integer>> sortedList = new ArrayList<Map.Entry<ItemStackKey, Integer>>(compactedStacks.entrySet());
        sortedList.sort(InventorySorter.BY_COUNT);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        sortedList.forEach(e -> {
            ItemStack stackCopy = ((ItemStackKey)e.getKey()).getStack().m_41777_();
            stackCopy.m_41764_(((Integer)e.getValue()).intValue());
            ret.add(stackCopy);
        });
        return ret;
    }

    public static Set<ItemStackKey> getUniqueStacks(IItemHandler handler) {
        HashSet<ItemStackKey> uniqueStacks = new HashSet<ItemStackKey>();
        InventoryHelper.iterate(handler, (slot, stack) -> {
            if (stack.m_41619_()) {
                return;
            }
            ItemStackKey itemStackKey = new ItemStackKey((ItemStack)stack);
            uniqueStacks.add(itemStackKey);
        });
        return uniqueStacks;
    }

    public static List<Integer> getEmptySlotsRandomized(IItemHandler inventory, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!inventory.getStackInSlot(i).m_41619_()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }

    public static void shuffleItems(List<ItemStack> stacks, int emptySlotsCount, Random rand) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.m_41619_()) {
                iterator.remove();
                continue;
            }
            if (itemstack.m_41613_() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (emptySlotsCount - stacks.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)list.remove(Mth.m_14072_((Random)rand, (int)0, (int)(list.size() - 1)));
            int i = Mth.m_14072_((Random)rand, (int)1, (int)(itemstack2.m_41613_() / 2));
            ItemStack itemstack1 = itemstack2.m_41620_(i);
            if (itemstack2.m_41613_() > 1 && rand.nextBoolean()) {
                list.add(itemstack2);
            } else {
                stacks.add(itemstack2);
            }
            if (itemstack1.m_41613_() > 1 && rand.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            stacks.add(itemstack1);
        }
        stacks.addAll(list);
        Collections.shuffle(stacks, rand);
    }

    public static void dropItems(ItemStackHandler inventoryHandler, Level level, BlockPos pos) {
        InventoryHelper.dropItems(inventoryHandler, level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static void dropItems(ItemStackHandler inventoryHandler, Level level, double x, double y, double z) {
        InventoryHelper.iterate((IItemHandler)inventoryHandler, (slot, stack) -> {
            while (!stack.m_41619_()) {
                Containers.m_18992_((Level)level, (double)x, (double)y, (double)z, (ItemStack)stack.m_41620_(Math.min(stack.m_41613_(), stack.m_41741_())));
                inventoryHandler.setStackInSlot(slot.intValue(), ItemStack.f_41583_);
            }
        });
    }

    public static int getAnalogOutputSignal(IItemHandler handler) {
        AtomicDouble totalFilled = new AtomicDouble(0.0);
        AtomicBoolean isEmpty = new AtomicBoolean(true);
        InventoryHelper.iterate(handler, (slot, stack) -> {
            if (!stack.m_41619_()) {
                int slotLimit = handler.getSlotLimit(slot.intValue());
                totalFilled.addAndGet((double)((float)stack.m_41613_() / ((float)slotLimit / (64.0f / (float)stack.m_41741_()))));
                isEmpty.set(false);
            }
        });
        double percentFilled = totalFilled.get() / (double)handler.getSlots();
        return Mth.m_14107_((double)(percentFilled * 14.0)) + (isEmpty.get() ? 0 : 1);
    }
}

