/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.memory;

import java.util.Map;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsTemplateStorage;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class MemorySettingsContainer
extends SettingsContainerBase<MemorySettingsCategory> {
    private static final String ACTION_TAG = "action";
    private static final String SELECT_ALL_ACTION = "selectAll";
    private static final String UNSELECT_ALL_ACTION = "unselectAll";
    private static final String UNSELECT_SLOT_TAG = "unselectSlot";
    private static final String SELECT_SLOT_TAG = "selectSlot";
    private static final String IGNORE_NBT_TAG = "ignoreNbt";
    private static final int TOTAL_SAVE_SLOTS = 10;
    private static final String SAVE_SLOT_TAG = "saveSlot";
    private static final String LOAD_SLOT_TAG = "loadSlot";
    private int saveSlot = 1;
    private int loadSlot = -1;

    public MemorySettingsContainer(SettingsContainerMenu<?> settingsContainer, String categoryName, MemorySettingsCategory category) {
        super(settingsContainer, categoryName, category);
        if (this.getNumberOfSaves() >= 1) {
            this.selectLoadSlot(1);
        }
    }

    @Override
    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(ACTION_TAG)) {
            switch (data.m_128461_(ACTION_TAG)) {
                case "selectAll": {
                    this.selectAllSlots();
                    break;
                }
                case "unselectAll": {
                    this.unselectAllSlots();
                    break;
                }
            }
        } else if (data.m_128441_(SELECT_SLOT_TAG)) {
            this.selectSlot(data.m_128451_(SELECT_SLOT_TAG));
        } else if (data.m_128441_(UNSELECT_SLOT_TAG)) {
            this.unselectSlot(data.m_128451_(UNSELECT_SLOT_TAG));
        } else if (data.m_128441_(IGNORE_NBT_TAG)) {
            this.setIgnoreNbt(data.m_128471_(IGNORE_NBT_TAG));
        } else if (data.m_128441_(LOAD_SLOT_TAG)) {
            this.selectLoadSlot(data.m_128451_(LOAD_SLOT_TAG));
        } else if (data.m_128441_(SAVE_SLOT_TAG)) {
            this.saveSlot = data.m_128451_(SAVE_SLOT_TAG);
        }
    }

    public void unselectSlot(int slotNumber) {
        if (!this.isSlotSelected(slotNumber)) {
            return;
        }
        if (this.isServer()) {
            ((MemorySettingsCategory)this.getCategory()).unselectSlot(slotNumber);
            this.getSettingsContainer().onMemorizedStackRemoved(slotNumber);
        } else {
            this.sendIntToServer(UNSELECT_SLOT_TAG, slotNumber);
        }
    }

    public void selectSlot(int slotNumber) {
        if (this.isSlotSelected(slotNumber)) {
            return;
        }
        if (this.isServer()) {
            ((MemorySettingsCategory)this.getCategory()).selectSlot(slotNumber);
        } else {
            this.sendIntToServer(SELECT_SLOT_TAG, slotNumber);
        }
    }

    public void unselectAllSlots() {
        if (this.isServer()) {
            ((MemorySettingsCategory)this.getCategory()).unselectAllSlots();
        } else {
            this.sendStringToServer(ACTION_TAG, UNSELECT_ALL_ACTION);
        }
    }

    public void selectAllSlots() {
        if (this.isServer()) {
            ((MemorySettingsCategory)this.getCategory()).selectSlots(0, this.getSettingsContainer().getNumberOfSlots());
        } else {
            this.sendStringToServer(ACTION_TAG, SELECT_ALL_ACTION);
        }
    }

    public boolean isSlotSelected(int slotNumber) {
        return ((MemorySettingsCategory)this.getCategory()).isSlotSelected(slotNumber);
    }

    public boolean ignoresNbt() {
        return ((MemorySettingsCategory)this.getCategory()).ignoresNbt();
    }

    public void setIgnoreNbt(boolean ignoreNbt) {
        if (this.isServer()) {
            ((MemorySettingsCategory)this.getCategory()).setIgnoreNbt(ignoreNbt);
            this.getSettingsContainer().onMemorizedItemsChanged();
        } else {
            this.sendBooleanToServer(IGNORE_NBT_TAG, ignoreNbt);
        }
    }

    public ItemStack getMemorizedStack(int slotNumber) {
        return ((MemorySettingsCategory)this.getCategory()).getSlotFilterStack(slotNumber, false).orElse(ItemStack.f_41583_);
    }

    public void saveTemplate() {
        this.getSettingsContainer().saveTemplate(this.saveSlot);
        this.getSettingsContainer().getPlayer().m_6352_((Component)new TranslatableComponent(TranslationHelper.INSTANCE.translSettingsMessage("save_template"), new Object[]{this.saveSlot}), Util.f_137441_);
        if (this.saveSlot == 1 && this.getNumberOfSaves() == 1) {
            this.selectLoadSlot(1);
        }
    }

    public void loadTemplate() {
        this.getSettingsContainer().loadTemplate();
        this.getSettingsContainer().getPlayer().m_6352_((Component)new TranslatableComponent(TranslationHelper.INSTANCE.translSettingsMessage("load_template"), new Object[]{this.loadSlot}), Util.f_137441_);
    }

    public void scrollSaveSlot(boolean next) {
        int size = this.getNumberOfSaves();
        if (size == 0) {
            this.saveSlot = 1;
            return;
        }
        this.saveSlot += next ? 1 : -1;
        int maxSlot = Math.min(10, size + 1);
        if (this.saveSlot < 1) {
            this.saveSlot = maxSlot;
        }
        if (this.saveSlot > maxSlot) {
            this.saveSlot = 1;
        }
        this.sendDataToServer(() -> NBTHelper.putInt(new CompoundTag(), SAVE_SLOT_TAG, this.saveSlot));
    }

    private int getNumberOfSaves() {
        return SettingsTemplateStorage.get().getPlayerTemplates(this.getSettingsContainer().getPlayer()).size();
    }

    private void selectLoadSlot(int loadSlot) {
        this.loadSlot = loadSlot;
        this.updateSelectedTemplate(SettingsTemplateStorage.get().getPlayerTemplates(this.getSettingsContainer().getPlayer()));
    }

    public void scrollLoadSlot(boolean next) {
        Map<Integer, CompoundTag> playerTemplates = SettingsTemplateStorage.get().getPlayerTemplates(this.getSettingsContainer().getPlayer());
        int size = playerTemplates.size();
        if (size == 0) {
            this.loadSlot = -1;
            return;
        }
        if (size == 1) {
            this.loadSlot = 1;
        } else {
            this.loadSlot += next ? 1 : -1;
            if (this.loadSlot < 1) {
                this.loadSlot = size;
            }
            if (this.loadSlot > size) {
                this.loadSlot = 1;
            }
        }
        this.updateSelectedTemplate(playerTemplates);
        this.sendDataToServer(() -> NBTHelper.putInt(new CompoundTag(), LOAD_SLOT_TAG, this.loadSlot));
    }

    private void updateSelectedTemplate(Map<Integer, CompoundTag> playerTemplates) {
        this.getSettingsContainer().updateSelectedTemplate(playerTemplates.get(this.loadSlot));
    }

    public int getSaveSlot() {
        return this.saveSlot;
    }

    public int getLoadSlot() {
        return this.loadSlot;
    }

    public ItemStack getSelectedTemplatesMemorizedStack(int slotNumber) {
        return this.getSettingsContainer().getSelectedTemplatesCategory(MemorySettingsCategory.class).flatMap(cat -> cat.getSlotFilterStack(slotNumber, false)).orElse(ItemStack.f_41583_);
    }
}

