/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class TranslationHelper {
    public static final String TOOLTIP_SUFFIX = ".tooltip";
    private static final String BUTTONS_SUFFIX = "buttons.";
    private static final String MESSAGE_SUFFIX = "message.";
    private static final String CONTROLS_SUFFIX = "controls.";
    public static final TranslationHelper INSTANCE = new TranslationHelper("sophisticatedcore");
    private final String guiPrefix;
    private final String guiUpgradePrefix;
    private final String guiSettingsPrefix;
    private final String guiStatusPrefix;
    private final String buttonsPrefix;
    private final String itemUpgradePrefix;
    private final String blockPrefix;
    private final String upgradeButtonsPrefix;
    private final String upgradeControlsPrefix;
    private final String keybindPrefix;

    public TranslationHelper(String modId) {
        this.guiPrefix = "gui." + modId + ".";
        this.keybindPrefix = "keybind." + modId + ".";
        this.itemUpgradePrefix = "item." + modId + ".";
        this.blockPrefix = "block." + modId + ".";
        this.guiUpgradePrefix = this.guiPrefix + "upgrades.";
        this.guiSettingsPrefix = this.guiPrefix + "settings.";
        this.guiStatusPrefix = this.guiPrefix + "status.";
        this.buttonsPrefix = this.guiPrefix + BUTTONS_SUFFIX;
        this.upgradeButtonsPrefix = this.guiUpgradePrefix + BUTTONS_SUFFIX;
        this.upgradeControlsPrefix = this.guiUpgradePrefix + CONTROLS_SUFFIX;
    }

    public Component translStatusMessage(String statusMessage, Object ... params) {
        return new TranslatableComponent(this.guiStatusPrefix + statusMessage, params);
    }

    public Component translUpgrade(String upgradeName) {
        return new TranslatableComponent(this.translUpgradeKey(upgradeName));
    }

    public Component translUpgradeSlotTooltip(String tooltipName) {
        return new TranslatableComponent(this.guiUpgradePrefix + "slots." + tooltipName + TOOLTIP_SUFFIX);
    }

    public String translUpgradeKey(String upgradeName) {
        return this.guiUpgradePrefix + upgradeName;
    }

    public String translBlockTooltipKey(String blockName) {
        return this.blockPrefix + blockName + TOOLTIP_SUFFIX;
    }

    public String translSettings(String categoryName) {
        return this.guiSettingsPrefix + categoryName;
    }

    public String translSettingsButton(String buttonName) {
        return this.translSettings(BUTTONS_SUFFIX + buttonName);
    }

    public String translSettingsMessage(String messageName) {
        return this.translSettings(MESSAGE_SUFFIX + messageName);
    }

    public Component translUpgradeTooltip(String upgradeName) {
        return new TranslatableComponent(this.translUpgradeKey(upgradeName) + TOOLTIP_SUFFIX);
    }

    public String translSettingsTooltip(String categoryName) {
        return this.translSettings(categoryName) + TOOLTIP_SUFFIX;
    }

    public Component translColoredButton(String buttonName, ChatFormatting color) {
        return new TranslatableComponent(this.translButton(buttonName)).m_130940_(color);
    }

    public String translButton(String buttonName) {
        return this.buttonsPrefix + buttonName;
    }

    public Component translError(String key, Object ... params) {
        return new TranslatableComponent(this.guiPrefix + "error." + key, params);
    }

    public String translUpgradeButton(String buttonName) {
        return this.upgradeButtonsPrefix + buttonName;
    }

    public String translUpgradeControl(String controlName) {
        return this.upgradeControlsPrefix + controlName;
    }

    public String translItemTooltip(String itemName) {
        return this.itemUpgradePrefix + itemName + TOOLTIP_SUFFIX;
    }

    public List<Component> getTranslatedLines(String translateKey, @Nullable Object parameters, ChatFormatting ... textFormattings) {
        ArrayList<Component> ret = new ArrayList<Component>();
        for (Component translatedLine : this.getTranslatedLines(translateKey, parameters)) {
            if (!(translatedLine instanceof MutableComponent)) continue;
            MutableComponent mutableComponent = (MutableComponent)translatedLine;
            mutableComponent.m_130944_(textFormattings);
            ret.add(translatedLine);
        }
        return ret;
    }

    public List<Component> getTranslatedLines(String translateKey) {
        return this.getTranslatedLines(translateKey, null);
    }

    public List<Component> getTranslatedLines(String translateKey, @Nullable Object parameters) {
        String text = this.translate(translateKey, parameters);
        String[] lines = text.split("\n");
        ArrayList<Component> ret = new ArrayList<Component>();
        for (String line : lines) {
            ret.add((Component)new TextComponent(line));
        }
        return ret;
    }

    public String translate(String translateKey, Object ... parameters) {
        return I18n.m_118938_((String)translateKey, (Object[])parameters);
    }

    public String translKeybind(String keybindName) {
        return this.keybindPrefix + keybindName;
    }

    public String translGui(String guiTranslateKey) {
        return this.guiPrefix + guiTranslateKey;
    }
}

