/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.network;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.common.IConfigWrapper;
import shetiphian.core.common.PlayerConfigs;
import shetiphian.core.common.network.PacketBase;

public class PacketPlayerConfig
extends PacketBase {
    private final ResourceLocation identifier;
    private final Object object;
    private final byte type;

    private PacketPlayerConfig(ResourceLocation identifier, Object value, int type) {
        this.identifier = identifier;
        this.object = value;
        this.type = (byte)type;
    }

    public static PacketPlayerConfig syncCustom(ResourceLocation identifier, Object value) {
        return new PacketPlayerConfig(identifier, value, 0);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, boolean value) {
        return new PacketPlayerConfig(identifier, value, 1);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, byte value) {
        return new PacketPlayerConfig(identifier, value, 2);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, short value) {
        return new PacketPlayerConfig(identifier, value, 3);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, int value) {
        return new PacketPlayerConfig(identifier, value, 4);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, long value) {
        return new PacketPlayerConfig(identifier, value, 5);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, double value) {
        return new PacketPlayerConfig(identifier, value, 6);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, float value) {
        return new PacketPlayerConfig(identifier, Float.valueOf(value), 7);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, String value) {
        return new PacketPlayerConfig(identifier, value, 8);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, ResourceLocation value) {
        return new PacketPlayerConfig(identifier, value, 9);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, ItemStack value) {
        return new PacketPlayerConfig(identifier, value, 10);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, UUID value) {
        return new PacketPlayerConfig(identifier, value, 11);
    }

    public static PacketPlayerConfig sync(ResourceLocation identifier, CompoundTag value) {
        return new PacketPlayerConfig(identifier, value, 12);
    }

    public static void writeData(PacketPlayerConfig packet, FriendlyByteBuf buffer) {
        buffer.m_130085_(packet.identifier);
        buffer.writeByte((int)packet.type);
        switch (packet.type) {
            case 0: {
                IConfigWrapper wrapper = PlayerConfigs.getConfigWrapper(packet.identifier);
                if (wrapper != null) {
                    wrapper.toBytes(packet.identifier, packet.object, buffer);
                    break;
                }
                ShetiPhianCore.LOGGER.error("Error syncing config; Client missing IConfigWrapper registration for: " + packet.identifier);
                break;
            }
            case 1: {
                buffer.writeBoolean(((Boolean)packet.object).booleanValue());
                break;
            }
            case 2: {
                buffer.writeByte((int)((Byte)packet.object).byteValue());
                break;
            }
            case 3: {
                buffer.writeShort((int)((Short)packet.object).shortValue());
                break;
            }
            case 4: {
                buffer.m_130130_(((Integer)packet.object).intValue());
                break;
            }
            case 5: {
                buffer.m_130103_(((Long)packet.object).longValue());
                break;
            }
            case 6: {
                buffer.writeDouble(((Double)packet.object).doubleValue());
                break;
            }
            case 7: {
                buffer.writeFloat(((Float)packet.object).floatValue());
                break;
            }
            case 8: {
                PacketPlayerConfig.writeString(buffer, (String)packet.object);
                break;
            }
            case 9: {
                buffer.m_130085_((ResourceLocation)packet.object);
                break;
            }
            case 10: {
                buffer.m_130055_((ItemStack)packet.object);
                break;
            }
            case 11: {
                buffer.m_130077_((UUID)packet.object);
                break;
            }
            case 12: {
                buffer.m_130079_((CompoundTag)packet.object);
            }
        }
    }

    public static PacketPlayerConfig readData(FriendlyByteBuf buffer) {
        ResourceLocation identifier = buffer.m_130281_();
        byte type = buffer.readByte();
        Object object = null;
        switch (type) {
            case 0: {
                IConfigWrapper wrapper = PlayerConfigs.getConfigWrapper(identifier);
                if (wrapper != null) {
                    object = wrapper.fromBytes(identifier, buffer);
                    break;
                }
                ShetiPhianCore.LOGGER.error("Error syncing config; Server missing IConfigWrapper registration for: " + identifier);
                break;
            }
            case 1: {
                object = buffer.readBoolean();
                break;
            }
            case 2: {
                object = buffer.readByte();
                break;
            }
            case 3: {
                object = buffer.readShort();
                break;
            }
            case 4: {
                object = buffer.m_130242_();
                break;
            }
            case 5: {
                object = buffer.m_130258_();
                break;
            }
            case 6: {
                object = buffer.readDouble();
                break;
            }
            case 7: {
                object = Float.valueOf(buffer.readFloat());
                break;
            }
            case 8: {
                object = PacketPlayerConfig.readString(buffer);
                break;
            }
            case 9: {
                object = buffer.m_130281_();
                break;
            }
            case 10: {
                object = buffer.m_130267_();
                break;
            }
            case 11: {
                object = buffer.m_130259_();
                break;
            }
            case 12: {
                object = buffer.m_130260_();
            }
        }
        return new PacketPlayerConfig(identifier, object, type);
    }

    @Override
    public void handleClientSide(Player player) {
    }

    @Override
    public void handleServerSide(Player player) {
        PlayerConfigs.setConfigs(player, this.identifier, this.object);
    }
}

