/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Strings;
import com.mojang.datafixers.types.Type;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHelper {
    public static Block register(IForgeRegistry<Block> registry, Block block, String id) {
        if (registry != null && block != null && !Strings.isNullOrEmpty((String)id)) {
            registry.register((IForgeRegistryEntry)((Block)block.setRegistryName(id)));
            return block;
        }
        return null;
    }

    public static BlockItem register(IForgeRegistry<Item> registry, BlockItem item) {
        return RegistryHelper.register(registry, item, null);
    }

    public static BlockItem register(IForgeRegistry<Item> registry, BlockItem item, String id) {
        if (registry != null && item != null) {
            Block block;
            if (Strings.isNullOrEmpty((String)id) && (block = item.m_40614_()) != null && block.getRegistryName() != null) {
                id = block.getRegistryName().toString();
            }
            if (!Strings.isNullOrEmpty((String)id)) {
                registry.register((IForgeRegistryEntry)((Item)item.setRegistryName(id)));
                return item;
            }
        }
        return null;
    }

    public static Item register(IForgeRegistry<Item> registry, Item item, String id) {
        if (registry != null && item != null && !Strings.isNullOrEmpty((String)id)) {
            registry.register((IForgeRegistryEntry)((Item)item.setRegistryName(id)));
            return item;
        }
        return null;
    }

    public static Potion register(IForgeRegistry<Potion> registry, Potion potion, String id) {
        if (registry != null && potion != null && !Strings.isNullOrEmpty((String)id)) {
            registry.register((IForgeRegistryEntry)((Potion)potion.setRegistryName(id)));
        }
        return potion;
    }

    public static SoundEvent register(IForgeRegistry<SoundEvent> registry, SoundEvent sound, String id) {
        if (registry != null && sound != null && !Strings.isNullOrEmpty((String)id)) {
            registry.register((IForgeRegistryEntry)((SoundEvent)sound.setRegistryName(id)));
            return sound;
        }
        return null;
    }

    public static MobEffect register(IForgeRegistry<MobEffect> registry, MobEffect effect, String id) {
        if (registry != null && effect != null && !Strings.isNullOrEmpty((String)id)) {
            registry.register((IForgeRegistryEntry)((MobEffect)effect.setRegistryName(id)));
            return effect;
        }
        return null;
    }

    public static Enchantment register(IForgeRegistry<Enchantment> registry, Enchantment enchantment, String id) {
        if (registry != null && enchantment != null && !Strings.isNullOrEmpty((String)id)) {
            registry.register((IForgeRegistryEntry)((Enchantment)enchantment.setRegistryName(id)));
            return enchantment;
        }
        return null;
    }

    public static <T extends Entity> EntityType register(IForgeRegistry<EntityType<?>> registry, EntityType.EntityFactory<T> entity, MobCategory type, String id) {
        if (registry != null && entity != null && !Strings.isNullOrEmpty((String)id)) {
            EntityType entityType = (EntityType)EntityType.Builder.m_20704_(entity, (MobCategory)type).m_20712_(id).setRegistryName(id);
            registry.register((IForgeRegistryEntry)entityType);
            return entityType;
        }
        return null;
    }

    public static BlockEntityType register(IForgeRegistry<BlockEntityType<?>> registry, BlockEntityType.BlockEntitySupplier<? extends BlockEntity> tile, String id, Block ... validBlocks) {
        return RegistryHelper.register(registry, tile, id, null, validBlocks);
    }

    public static BlockEntityType register(IForgeRegistry<BlockEntityType<?>> registry, BlockEntityType.BlockEntitySupplier<? extends BlockEntity> tile, String id, Type<?> datafixerType, Block ... validBlocks) {
        if (registry != null && tile != null && !Strings.isNullOrEmpty((String)id)) {
            BlockEntityType type = (BlockEntityType)BlockEntityType.Builder.m_155273_(tile, (Block[])validBlocks).m_58966_(datafixerType).setRegistryName(id);
            registry.register((IForgeRegistryEntry)type);
            return type;
        }
        return null;
    }
}

