/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.jei;

import com.google.common.collect.Lists;
import ironfurnaces.Config;
import ironfurnaces.init.Registration;
import ironfurnaces.jei.RecipeCategoryGeneratorBlasting;
import ironfurnaces.jei.RecipeCategoryGeneratorRegular;
import ironfurnaces.jei.RecipeCategoryGeneratorSmoking;
import ironfurnaces.recipes.GeneratorRecipe;
import ironfurnaces.recipes.SimpleGeneratorRecipe;
import ironfurnaces.tileentity.furnaces.BlockIronFurnaceTileBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class IronFurnacesJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("ironfurnaces", "plugin_ironfurnaces");
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (((Boolean)Config.enableJeiPlugin.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new RecipeCategoryGeneratorBlasting(registration.getJeiHelpers().getGuiHelper())});
            registration.addRecipeCategories(new IRecipeCategory[]{new RecipeCategoryGeneratorSmoking(registration.getJeiHelpers().getGuiHelper())});
            registration.addRecipeCategories(new IRecipeCategory[]{new RecipeCategoryGeneratorRegular(registration.getJeiHelpers().getGuiHelper())});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (((Boolean)Config.enableJeiPlugin.get()).booleanValue()) {
            ArrayList recipes = Lists.newArrayList();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                if (BlockIronFurnaceTileBase.getBurnTime(new ItemStack((ItemLike)item)) <= 0) continue;
                ItemStack stack = new ItemStack((ItemLike)item);
                recipes.add(new SimpleGeneratorRecipe(BlockIronFurnaceTileBase.getBurnTime(new ItemStack((ItemLike)item)) * 20, stack));
            }
            registration.addRecipes((Collection)recipes, RecipeCategoryGeneratorRegular.UID);
            ArrayList recipes1 = Lists.newArrayList();
            List list = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_(Registration.RecipeTypes.GENERATOR).stream().toList();
            for (GeneratorRecipe item : list) {
                recipes1.add(item);
            }
            registration.addRecipes((Collection)recipes1, RecipeCategoryGeneratorBlasting.UID);
            ArrayList recipes2 = Lists.newArrayList();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                if (item.m_41473_() == null || item.m_41473_().m_38744_() <= 0) continue;
                ItemStack stack = new ItemStack((ItemLike)item);
                recipes2.add(new SimpleGeneratorRecipe(BlockIronFurnaceTileBase.getSmokingBurn(stack) * 20, stack));
            }
            registration.addRecipes((Collection)recipes2, RecipeCategoryGeneratorSmoking.UID);
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        if (((Boolean)Config.enableJeiPlugin.get()).booleanValue() && ((Boolean)Config.enableJeiCatalysts.get()).booleanValue()) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.BLASTING_AUGMENT.get()), new ResourceLocation[]{RecipeCategoryGeneratorBlasting.UID});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.SMOKING_AUGMENT.get()), new ResourceLocation[]{RecipeCategoryGeneratorSmoking.UID});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GENERATOR_AUGMENT.get()), new ResourceLocation[]{RecipeCategoryGeneratorRegular.UID});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GENERATOR_AUGMENT.get()), new ResourceLocation[]{RecipeCategoryGeneratorSmoking.UID});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GENERATOR_AUGMENT.get()), new ResourceLocation[]{RecipeCategoryGeneratorBlasting.UID});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.FACTORY_AUGMENT.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.IRON_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GOLD_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.DIAMOND_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.EMERALD_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.OBSIDIAN_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.CRYSTAL_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.NETHERITE_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.COPPER_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.SILVER_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
            if (((Boolean)Config.enableRainbowContent.get()).booleanValue()) {
                registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.MILLION_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
            }
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.IRON_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.GOLD_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.DIAMOND_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.EMERALD_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.OBSIDIAN_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.CRYSTAL_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.NETHERITE_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.COPPER_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.SILVER_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
            if (((Boolean)Config.enableRainbowContent.get()).booleanValue()) {
                registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.MILLION_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
            }
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.BLASTING_AUGMENT.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.BLASTING});
            registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.SMOKING_AUGMENT.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.SMOKING});
            if (ModList.get().isLoaded("allthemodium")) {
                registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.ALLTHEMODIUM_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
                registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.VIBRANIUM_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
                registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.UNOBTAINIUM_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
                registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.ALLTHEMODIUM_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
                registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.VIBRANIUM_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
                registry.addRecipeCatalyst(new ItemStack((ItemLike)Registration.UNOBTAINIUM_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
            }
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
    }
}

