/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.mixin.forge;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import samebutdifferent.ecologics.registry.ModMobEffects;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getFriction(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;)F"))
    private float onTravel(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        LivingEntity living;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_(ModMobEffects.SLIPPERY.get())) {
            return 0.98f;
        }
        return state.getFriction(level, pos, entity);
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetBlockSpeedFactor(CallbackInfoReturnable<Float> cir) {
        LivingEntity living;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof LivingEntity && (living = (LivingEntity)livingEntityMixin).m_21023_(ModMobEffects.SLIPPERY.get())) {
            cir.setReturnValue((Object)Float.valueOf(1.05f));
        }
    }
}

