/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.entity;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModItems;
import samebutdifferent.ecologics.registry.ModSoundEvents;
import samebutdifferent.ecologics.registry.ModTags;

public class Penguin
extends Animal {
    private static final EntityDataAccessor<Boolean> PREGNANT = SynchedEntityData.m_135353_(Penguin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(ModTags.ItemTags.PENGUIN_TEMPT_ITEMS);
    private float slideAnimationProgress;
    private float lastSlideAnimationProgress;
    private float swimAnimationProgress;
    private float lastSwimAnimationProgress;
    private int ticksSinceEaten;

    public Penguin(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.4f, 1.0f, true);
        this.f_21365_ = new PenguinLookControl((Mob)this, 20);
        this.f_19793_ = 1.0f;
        this.m_21553_(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new PenguinSearchForItemsGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new PenguinMeleeAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new PenguinRandomSwimmingGoal(this, 1.0, 60));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, new PenguinAttackTargetGoal<AbstractFish>(this, AbstractFish.class, 10, true, false, living -> living.m_6095_().m_204039_(ModTags.EntityTypeTags.PENGUIN_HUNT_TARGETS)));
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new PenguinPathNavigation(this, pLevel);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)ModEntityTypes.PENGUIN.get().m_20615_((Level)level);
    }

    public boolean m_6898_(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    public boolean isPregnant() {
        return (Boolean)this.f_19804_.m_135370_(PREGNANT);
    }

    public void setPregnant(boolean isPregnant) {
        this.f_19804_.m_135381_(PREGNANT, (Object)isPregnant);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PREGNANT, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsPregnant", this.isPregnant());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setPregnant(pCompound.m_128471_("IsPregnant"));
    }

    public void m_27563_(ServerLevel level, Animal otherParent) {
        ServerPlayer serverplayer = this.m_27592_();
        if (serverplayer == null && otherParent.m_27592_() != null) {
            serverplayer = otherParent.m_27592_();
        }
        if (serverplayer != null) {
            serverplayer.m_36220_(Stats.f_12937_);
            CriteriaTriggers.f_10581_.m_147278_(serverplayer, (Animal)this, otherParent, null);
        }
        this.m_146762_(6000);
        otherParent.m_146762_(6000);
        this.m_27594_();
        otherParent.m_27594_();
        level.m_7605_((Entity)this, (byte)18);
        this.setPregnant(true);
        if (level.m_46469_().m_46207_(GameRules.f_46135_)) {
            level.m_7967_((Entity)new ExperienceOrb((Level)level, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_21187_().nextInt(7) + 1));
        }
    }

    protected void m_142669_() {
        super.m_142669_();
        if (!this.m_6162_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_20000_((ItemLike)ModItems.PENGUIN_FEATHER.get(), 1);
        }
    }

    public void m_8107_() {
        if (this.isPregnant() && this.f_19796_.nextInt(3000) == 0 && !this.f_19853_.f_46443_) {
            ServerLevel level = (ServerLevel)this.f_19853_;
            this.setPregnant(false);
            Penguin penguin = (Penguin)ModEntityTypes.PENGUIN.get().m_20615_((Level)level);
            penguin.m_6863_(true);
            penguin.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            level.m_47205_((Entity)penguin);
            level.m_7605_((Entity)this, (byte)18);
        }
        if (this.f_19853_.m_46467_() % 80L == 0L && this.f_19853_.m_45976_(Penguin.class, this.m_142469_().m_82400_(20.0)).size() > 4) {
            for (Player player : this.f_19853_.m_45976_(Player.class, this.m_142469_().m_82400_(10.0))) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 0, true, true));
            }
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.m_6142_()) {
            ++this.ticksSinceEaten;
            ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (this.canEat(stack)) {
                if (this.ticksSinceEaten > 600) {
                    ItemStack finishedStack = stack.m_41671_(this.f_19853_, (LivingEntity)this);
                    if (!finishedStack.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, finishedStack);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.f_19796_.nextFloat() < 0.1f) {
                    this.m_5496_(this.m_7866_(stack), 1.0f, 1.0f);
                    this.f_19853_.m_7605_((Entity)this, (byte)45);
                }
            }
        }
        super.m_8107_();
    }

    private boolean canEat(ItemStack itemStack) {
        return itemStack.m_41720_().m_41472_() && this.m_5448_() == null && this.f_19861_;
    }

    public void m_7822_(byte id) {
        if (id == 45) {
            ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemStack.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3 = new Vec3(((double)this.f_19796_.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_7066_(ItemStack pItemstack) {
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)pItemstack);
        if (!this.m_6844_(equipmentslot).m_41619_() || this.m_6162_()) {
            return false;
        }
        return equipmentslot == EquipmentSlot.MAINHAND && super.m_7066_(pItemstack);
    }

    public boolean m_7252_(ItemStack pStack) {
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemstack.m_41619_() && pStack.m_204117_(ModTags.ItemTags.PENGUIN_TEMPT_ITEMS) && !this.m_6162_();
    }

    protected void m_7581_(ItemEntity pItemEntity) {
        ItemStack itemstack = pItemEntity.m_32055_();
        if (this.m_7252_(itemstack)) {
            int count = itemstack.m_41613_();
            if (count > 1) {
                this.dropItemStack(itemstack.m_41620_(count - 1));
            }
            this.m_21053_(pItemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)pItemEntity, itemstack.m_41613_());
            pItemEntity.m_146870_();
            this.ticksSinceEaten = 0;
        }
    }

    private void dropItemStack(ItemStack pStack) {
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), pStack);
        this.f_19853_.m_7967_((Entity)itementity);
    }

    protected SoundEvent m_7515_() {
        return ModSoundEvents.PENGUIN_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return ModSoundEvents.PENGUIN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return ModSoundEvents.PENGUIN_DEATH.get();
    }

    private boolean babyIsNearAdult() {
        Iterator iterator;
        if (this.m_6162_() && (iterator = this.f_19853_.m_45976_(Penguin.class, this.m_142469_().m_82377_(2.0, 5.0, 2.0)).iterator()).hasNext()) {
            Penguin penguin = (Penguin)((Object)iterator.next());
            return !penguin.m_6162_();
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && (this.slideAnimationProgress != this.lastSlideAnimationProgress || this.swimAnimationProgress != this.lastSwimAnimationProgress)) {
            this.m_6210_();
        }
        this.updateSwimmingAnimation();
        this.updateSlidingAnimation();
    }

    public boolean canSlide() {
        return this.f_19853_.m_8055_(this.m_142538_().m_7495_()).m_60713_(Blocks.f_50126_) && !this.m_27593_() && !this.isPregnant() && this.m_20184_().m_165925_() > 1.0E-6;
    }

    private void updateSlidingAnimation() {
        this.lastSlideAnimationProgress = this.slideAnimationProgress;
        this.slideAnimationProgress = this.canSlide() ? Math.min(1.0f, this.slideAnimationProgress + 0.15f) : Math.max(0.0f, this.slideAnimationProgress - 0.15f);
    }

    public float getSlidingAnimationProgress(float ticks) {
        return Mth.m_14179_((float)ticks, (float)this.lastSlideAnimationProgress, (float)this.slideAnimationProgress);
    }

    private void updateSwimmingAnimation() {
        this.lastSwimAnimationProgress = this.swimAnimationProgress;
        this.swimAnimationProgress = this.m_20069_() ? Math.min(1.0f, this.swimAnimationProgress + 0.15f) : Math.max(0.0f, this.swimAnimationProgress - 0.15f);
    }

    public float getSwimmingAnimationProgress(float ticks) {
        return Mth.m_14179_((float)ticks, (float)this.lastSwimAnimationProgress, (float)this.swimAnimationProgress);
    }

    public void m_8024_() {
        if (this.swimAnimationProgress > 0.0f) {
            this.m_20124_(Pose.SWIMMING);
        } else if (this.slideAnimationProgress > 0.0f) {
            this.m_20124_(Pose.CROUCHING);
        } else {
            this.m_20124_(Pose.STANDING);
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        float progress;
        float f = this.slideAnimationProgress > 0.0f ? this.slideAnimationProgress : (progress = this.swimAnimationProgress > 0.0f ? this.swimAnimationProgress : 0.0f);
        if (progress > 0.0f) {
            return super.m_6972_(pose).m_20390_(this.m_6162_() ? 1.0f + progress : 1.0f + progress * 0.3f, 1.0f - progress / 2.0f);
        }
        return super.m_6972_(pose).m_20390_(1.0f, this.m_6162_() ? 1.4f : 1.0f);
    }

    public int m_8085_() {
        return 40;
    }

    static class PenguinLookControl
    extends LookControl {
        private final int maxYRotFromCenter;

        public PenguinLookControl(Mob mob, int maxYRotFromCenter) {
            super(mob);
            this.maxYRotFromCenter = maxYRotFromCenter;
        }

        public void m_8128_() {
            if (this.f_186068_ > 0) {
                --this.f_186068_;
                this.m_180896_().ifPresent(yHeadRot -> {
                    this.f_24937_.f_20885_ = this.m_24956_(this.f_24937_.f_20885_, yHeadRot.floatValue(), this.f_24938_);
                });
                this.m_180897_().ifPresent(xRot -> this.f_24937_.m_146926_(this.m_24956_(this.f_24937_.m_146909_(), xRot.floatValue(), this.f_24939_)));
            } else {
                if (this.f_24937_.m_21573_().m_26571_()) {
                    this.f_24937_.m_146926_(this.m_24956_(this.f_24937_.m_146909_(), 0.0f, 5.0f));
                }
                this.f_24937_.f_20885_ = this.m_24956_(this.f_24937_.f_20885_, this.f_24937_.f_20883_, this.f_24938_);
            }
            float f = Mth.m_14177_((float)(this.f_24937_.f_20885_ - this.f_24937_.f_20883_));
            if (f < (float)(-this.maxYRotFromCenter)) {
                this.f_24937_.f_20883_ -= 4.0f;
            } else if (f > (float)this.maxYRotFromCenter) {
                this.f_24937_.f_20883_ += 4.0f;
            }
        }
    }

    static class PenguinSearchForItemsGoal
    extends Goal {
        private final Penguin penguin;

        public PenguinSearchForItemsGoal(Penguin penguin) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.penguin = penguin;
        }

        public boolean m_8036_() {
            if (!this.penguin.m_6844_(EquipmentSlot.MAINHAND).m_41619_() || this.penguin.m_6162_() || this.penguin.isPregnant()) {
                return false;
            }
            List list = this.penguin.f_19853_.m_6443_(ItemEntity.class, this.penguin.m_142469_().m_82377_(8.0, 8.0, 8.0), itemEntity -> itemEntity.m_32055_().m_204117_(ModTags.ItemTags.PENGUIN_TEMPT_ITEMS));
            return !list.isEmpty() && this.penguin.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
        }

        public void m_8037_() {
            List list = this.penguin.f_19853_.m_6443_(ItemEntity.class, this.penguin.m_142469_().m_82377_(8.0, 8.0, 8.0), itemEntity -> itemEntity.m_32055_().m_204117_(ModTags.ItemTags.PENGUIN_TEMPT_ITEMS));
            ItemStack itemstack = this.penguin.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_() && !list.isEmpty()) {
                this.penguin.m_21573_().m_5624_((Entity)list.get(0), 1.0);
            }
        }

        public void m_8056_() {
            List list = this.penguin.f_19853_.m_6443_(ItemEntity.class, this.penguin.m_142469_().m_82377_(8.0, 8.0, 8.0), itemEntity -> itemEntity.m_32055_().m_204117_(ModTags.ItemTags.PENGUIN_TEMPT_ITEMS));
            if (!list.isEmpty()) {
                this.penguin.m_21573_().m_5624_((Entity)list.get(0), 1.0);
            }
        }
    }

    static class PenguinMeleeAttackGoal
    extends MeleeAttackGoal {
        private final Penguin penguin;

        public PenguinMeleeAttackGoal(Penguin pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.penguin = pMob;
        }

        public boolean m_8036_() {
            if (!this.penguin.m_6844_(EquipmentSlot.MAINHAND).m_41619_() || this.penguin.m_6162_() || this.penguin.isPregnant()) {
                return false;
            }
            return super.m_8036_();
        }
    }

    static class PenguinRandomSwimmingGoal
    extends RandomSwimmingGoal {
        private final Penguin penguin;

        public PenguinRandomSwimmingGoal(Penguin pMob, double pSpeedModifier, int pInterval) {
            super((PathfinderMob)pMob, pSpeedModifier, pInterval);
            this.penguin = pMob;
        }

        public boolean m_8036_() {
            if (this.penguin.m_6162_() || this.penguin.isPregnant() || !this.penguin.m_21205_().m_41619_()) {
                return false;
            }
            return super.m_8036_();
        }
    }

    static class PenguinAttackTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        private final Penguin penguin;

        public PenguinAttackTargetGoal(Penguin pMob, Class<T> pTargetType, int pRandomInterval, boolean pMustSee, boolean pMustReach, @Nullable Predicate<LivingEntity> pPredicate) {
            super((Mob)pMob, pTargetType, pRandomInterval, pMustSee, pMustReach, pPredicate);
            this.penguin = pMob;
        }

        public boolean m_8036_() {
            if (this.penguin.m_6162_() || this.penguin.isPregnant() || !this.penguin.m_21205_().m_41619_()) {
                return false;
            }
            return super.m_8036_();
        }
    }

    static class PenguinPathNavigation
    extends WaterBoundPathNavigation {
        public PenguinPathNavigation(Penguin penguin, Level level) {
            super((Mob)penguin, level);
        }

        protected boolean m_7632_() {
            return true;
        }

        protected PathFinder m_5532_(int p_149222_) {
            this.f_26508_ = new AmphibiousNodeEvaluator(false);
            return new PathFinder(this.f_26508_, p_149222_);
        }

        public boolean m_6342_(BlockPos p_149224_) {
            return !this.f_26495_.m_8055_(p_149224_.m_7495_()).m_60795_();
        }
    }
}

