/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.ModelUtils;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import samebutdifferent.ecologics.entity.Penguin;
import samebutdifferent.ecologics.util.AnimationUtil;

@OnlyIn(value=Dist.CLIENT)
public class PenguinModel
extends AgeableListModel<Penguin> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("ecologics", "penguin"), "main");
    private final ModelPart body;
    public final ModelPart head;
    private final ModelPart leftFlipper;
    private final ModelPart rightFlipper;
    private final ModelPart egg;
    private final ModelPart leftFoot;
    private final ModelPart rightFoot;
    private float slidingAnimationProgress;
    private float swimmingAnimationProgress;

    public PenguinModel(ModelPart root) {
        super(true, 4.75f, 0.0f, 1.5f, 2.0f, 24.0f);
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.leftFlipper = this.body.m_171324_("leftFlipper");
        this.rightFlipper = this.body.m_171324_("rightFlipper");
        this.egg = this.body.m_171324_("egg");
        this.leftFoot = this.body.m_171324_("leftFoot");
        this.rightFoot = this.body.m_171324_("rightFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.0f, -5.0f, -3.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(23, 0).m_171488_(-1.0f, -2.0f, -5.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -2.0f, -3.0f, 8.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition leftFlipper = body.m_171599_("leftFlipper", CubeListBuilder.m_171558_().m_171514_(18, 21).m_171488_(0.0f, -1.0f, -3.0f, 1.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-1.0f, (float)0.0f));
        PartDefinition rightFlipper = body.m_171599_("rightFlipper", CubeListBuilder.m_171558_().m_171514_(18, 21).m_171480_().m_171488_(-1.0f, -1.0f, -3.0f, 1.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)-1.0f, (float)0.0f));
        PartDefinition egg = body.m_171599_("egg", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171488_(-1.5f, -4.0f, -6.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition leftFoot = body.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-1.0f, 0.0f, -2.0f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)7.0f, (float)-3.0f));
        PartDefinition rightFoot = body.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)7.0f, (float)-3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(Penguin entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_((Entity)entity, limbSwing, limbSwingAmount, partialTick);
        this.slidingAnimationProgress = entity.getSlidingAnimationProgress(partialTick);
        this.swimmingAnimationProgress = entity.getSwimmingAnimationProgress(partialTick);
    }

    public void setupAnim(Penguin entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupInitialAnimationValues();
        this.egg.f_104207_ = entity.isPregnant();
        float swingSlowdownFactor = 0.3f;
        if (this.swimmingAnimationProgress > 0.0f) {
            this.body.f_104203_ += ModelUtils.m_103125_((float)this.body.f_104203_, (float)((float)Math.toRadians(90.0)), (float)this.swimmingAnimationProgress) - Mth.m_14089_((float)(0.7f * ageInTicks)) * (swingSlowdownFactor * 0.25f);
            this.body.f_104201_ = Mth.m_14179_((float)this.swimmingAnimationProgress, (float)17.0f, (float)24.0f);
            this.body.f_104201_ += -Mth.m_14089_((float)(0.7f * ageInTicks)) * (swingSlowdownFactor * 0.025f);
            this.head.f_104203_ = Mth.m_14179_((float)this.swimmingAnimationProgress, (float)(headPitch * ((float)Math.PI / 180)), (float)0.0f);
            this.head.f_104204_ = Mth.m_14179_((float)this.swimmingAnimationProgress, (float)(netHeadYaw * ((float)Math.PI / 180)), (float)0.0f);
            this.head.f_104201_ = Mth.m_14179_((float)this.swimmingAnimationProgress, (float)15.0f, (float)(entity.m_6162_() ? 21.0f : 24.0f));
            this.head.f_104202_ = Mth.m_14179_((float)this.swimmingAnimationProgress, (float)0.0f, (float)-2.0f);
            this.head.f_104203_ += Mth.m_14089_((float)(0.7f * ((float)Math.toRadians(-40.0) + ageInTicks))) * (swingSlowdownFactor * 0.3f);
            this.leftFoot.f_104203_ = (float)((double)this.leftFoot.f_104203_ + (Math.toRadians(17.5) - (double)Mth.m_14089_((float)((float)Math.toRadians(-40.0) + ageInTicks))) * (double)swingSlowdownFactor);
            this.rightFoot.f_104203_ = (float)((double)this.rightFoot.f_104203_ + (Math.toRadians(17.5) - (double)Mth.m_14031_((float)((float)Math.toRadians(-40.0) + ageInTicks))) * (double)swingSlowdownFactor);
            this.leftFlipper.f_104203_ += Mth.m_14089_((float)((float)Math.toRadians(-80.0) + ageInTicks)) * (swingSlowdownFactor * 0.2f);
            this.leftFlipper.f_104205_ = (float)((double)this.leftFlipper.f_104205_ + (Math.toRadians(-5.0) - (double)Mth.m_14089_((float)((float)Math.toRadians(-80.0) + ageInTicks))) * (double)(swingSlowdownFactor * 0.25f));
            this.rightFlipper.f_104203_ += Mth.m_14089_((float)((float)Math.toRadians(-80.0) + ageInTicks)) * (swingSlowdownFactor * 0.2f);
            this.rightFlipper.f_104205_ = (float)((double)this.rightFlipper.f_104205_ + (Math.toRadians(5.0) - (double)Mth.m_14089_((float)((float)Math.toRadians(-80.0) + ageInTicks))) * (double)(swingSlowdownFactor * 0.25f));
        } else if (this.slidingAnimationProgress > 0.0f) {
            this.body.f_104203_ += ModelUtils.m_103125_((float)this.body.f_104203_, (float)((float)Math.toRadians(90.0)), (float)this.slidingAnimationProgress);
            this.body.f_104201_ = Mth.m_14179_((float)this.slidingAnimationProgress, (float)17.0f, (float)24.0f);
            this.body.f_104202_ += -Mth.m_14089_((float)(2.0f * limbSwing)) * swingSlowdownFactor * limbSwingAmount;
            this.head.f_104203_ = Mth.m_14179_((float)this.slidingAnimationProgress, (float)(headPitch * ((float)Math.PI / 180)), (float)0.0f);
            this.head.f_104204_ = Mth.m_14179_((float)this.slidingAnimationProgress, (float)(netHeadYaw * ((float)Math.PI / 180)), (float)0.0f);
            this.head.f_104201_ = Mth.m_14179_((float)this.slidingAnimationProgress, (float)15.0f, (float)(entity.m_6162_() ? 20.0f : 24.0f));
            this.head.f_104202_ = Mth.m_14179_((float)this.slidingAnimationProgress, (float)0.0f, (float)-4.0f);
            this.head.f_104201_ += -Mth.m_14089_((float)(2.0f * ((float)Math.toRadians(-80.0) + limbSwing))) * swingSlowdownFactor * limbSwingAmount;
            this.head.f_104202_ += -Mth.m_14089_((float)(2.0f * limbSwing)) * swingSlowdownFactor * limbSwingAmount;
            this.leftFoot.f_104203_ += ModelUtils.m_103125_((float)this.leftFoot.f_104203_, (float)((float)Math.toRadians(90.0)), (float)this.slidingAnimationProgress);
            this.rightFoot.f_104203_ += ModelUtils.m_103125_((float)this.rightFoot.f_104203_, (float)((float)Math.toRadians(90.0)), (float)this.slidingAnimationProgress);
            this.leftFlipper.f_104205_ = (float)((double)this.leftFlipper.f_104205_ + (Math.toRadians(-2.5) - (double)Mth.m_14089_((float)(2.0f * limbSwing))) * (double)(swingSlowdownFactor * 0.5f) * (double)limbSwingAmount);
            this.rightFlipper.f_104205_ = (float)((double)this.rightFlipper.f_104205_ + (Math.toRadians(2.5) - (double)Mth.m_14089_((float)(2.0f * limbSwing))) * (double)(swingSlowdownFactor * 0.5f) * (double)limbSwingAmount);
        } else {
            this.body.f_104204_ += Mth.m_14089_((float)((float)Math.toRadians(-20.0) + limbSwing)) * swingSlowdownFactor * limbSwingAmount;
            this.body.f_104205_ += Mth.m_14089_((float)limbSwing) * (swingSlowdownFactor * 0.5f) * limbSwingAmount;
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.head.f_104204_ += -Mth.m_14089_((float)((float)Math.toRadians(-80.0) + limbSwing)) * (swingSlowdownFactor * 0.5f) * limbSwingAmount;
            this.head.f_104205_ += -Mth.m_14089_((float)((float)Math.toRadians(-40.0) + limbSwing)) * (swingSlowdownFactor * 0.5f) * limbSwingAmount;
            this.head.f_104200_ += Mth.m_14089_((float)limbSwing) * (swingSlowdownFactor * 0.1f) * limbSwingAmount;
            this.leftFoot.f_104203_ = (float)((double)this.leftFoot.f_104203_ + (Math.toRadians(-10.0) + (double)Mth.m_14089_((float)limbSwing)) * (double)(swingSlowdownFactor * 2.0f) * (double)limbSwingAmount);
            this.rightFoot.f_104203_ = (float)((double)this.rightFoot.f_104203_ + (Math.toRadians(-10.0) - (double)Mth.m_14089_((float)limbSwing)) * (double)(swingSlowdownFactor * 2.0f) * (double)limbSwingAmount);
            this.leftFlipper.f_104205_ = (float)((double)this.leftFlipper.f_104205_ + (Math.toRadians(-10.0) + (double)Mth.m_14089_((float)((float)Math.toRadians(-40.0) + limbSwing))) * (double)(swingSlowdownFactor * 0.8f) * (double)limbSwingAmount);
            this.rightFlipper.f_104205_ = (float)((double)this.rightFlipper.f_104205_ + (Math.toRadians(10.0) + (double)Mth.m_14089_((float)((float)Math.toRadians(-40.0) + limbSwing))) * (double)(swingSlowdownFactor * 0.8f) * (double)limbSwingAmount);
        }
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body);
    }

    private void setupInitialAnimationValues() {
        AnimationUtil.setInitialValue(this.body, 0.0f, 17.0f, 0.0f);
        AnimationUtil.setInitialValue(this.head, 0.0f, 15.0f, 0.0f);
        AnimationUtil.setInitialValue(this.leftFlipper, 4.0f, -1.0f, 0.0f);
        AnimationUtil.setInitialValue(this.rightFlipper, -4.0f, -1.0f, 0.0f);
        AnimationUtil.setInitialValue(this.egg, 0.0f, 7.0f, 0.0f);
        AnimationUtil.setInitialValue(this.leftFoot, 2.0f, 7.0f, -3.0f);
        AnimationUtil.setInitialValue(this.rightFoot, -2.0f, 7.0f, -3.0f);
    }
}

