/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.replacement.rule;

import com.blamejared.crafttweaker.api.recipe.handler.ITargetingRule;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraft.world.item.crafting.Recipe;

public final class SpecificManagersTargetingRule
implements ITargetingRule {
    private final Collection<IRecipeManager<?>> recipeManagers;

    private SpecificManagersTargetingRule(Collection<IRecipeManager<?>> recipeManagers) {
        this.recipeManagers = Collections.unmodifiableCollection(recipeManagers);
    }

    public static SpecificManagersTargetingRule of(Collection<IRecipeManager<?>> recipeManagers) {
        if (recipeManagers.isEmpty()) {
            throw new IllegalArgumentException("Unable to create a specific managers targeting rule without any targets");
        }
        return new SpecificManagersTargetingRule(recipeManagers);
    }

    public static SpecificManagersTargetingRule of(IRecipeManager<?> ... recipes) {
        return SpecificManagersTargetingRule.of(new HashSet(Arrays.asList(recipes)));
    }

    @Override
    public boolean shouldBeReplaced(Recipe<?> recipe, IRecipeManager<?> manager) {
        return this.recipeManagers.contains(manager);
    }

    @Override
    public String describe() {
        return this.recipeManagers.stream().map(IRecipeManager::getCommandString).collect(Collectors.joining(", ", "managers {", "}"));
    }
}

