/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.base.ICollectionData;
import com.blamejared.crafttweaker.api.data.base.IData;
import com.blamejared.crafttweaker.api.data.base.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.data.base.visitor.DataVisitor;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.ListData")
@ZenRegister
@Document(value="vanilla/api/data/ListData")
public class ListData
implements ICollectionData {
    private final ListTag internal;

    public ListData(ListTag internal) {
        this.internal = internal;
    }

    @ZenCodeType.Constructor
    public ListData() {
        this.internal = new ListTag();
    }

    @ZenCodeType.Constructor
    public ListData(List<IData> list) {
        this.internal = new ListTag();
        if (list != null) {
            list.forEach(iData -> this.getInternal().add((Object)iData.getInternal()));
        }
    }

    @ZenCodeType.Constructor
    public ListData(IData ... array) {
        this(ListData.getArraySafe(array));
    }

    private static List<IData> getArraySafe(IData ... array) {
        if (array == null) {
            array = new IData[]{};
        }
        return Arrays.asList(array);
    }

    @Override
    public IData setAt(int index, IData value) {
        return TagToDataConverter.convert(this.getInternal().set(index, value.getInternal()));
    }

    @Override
    public void add(int index, IData value) {
        this.getInternal().add(index, value.getInternal());
    }

    @Override
    public void add(IData value) {
        this.getInternal().add((Object)value.getInternal());
    }

    @Override
    public IData remove(int index) {
        return TagToDataConverter.convert(this.getInternal().remove(index));
    }

    @Override
    public IData getAt(int index) {
        return TagToDataConverter.convert(this.getInternal().get(index));
    }

    @ZenCodeType.Method
    public <T extends IData> @ZenCodeType.Nullable T getData(Class<T> clazz, int index) {
        try {
            return TagToDataConverter.convertTo(this.getInternal().get(index), clazz);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to convert IData to " + clazz, e);
        }
    }

    @Override
    public int size() {
        return this.getInternal().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @Override
    public void clear() {
        this.getInternal().clear();
    }

    @Override
    public ListData copy() {
        return new ListData(this.getInternal());
    }

    @Override
    public ListData copyInternal() {
        return new ListData(this.getInternal().m_6426_());
    }

    public ListTag getInternal() {
        return this.internal;
    }

    @Override
    public List<IData> asList() {
        ArrayList<IData> data = new ArrayList<IData>();
        for (Tag inbt : this.getInternal()) {
            data.add(TagToDataConverter.convert(inbt));
        }
        return data;
    }

    @Override
    public boolean contains(IData data) {
        List<IData> dataValues = data.asList();
        if (dataValues != null && this.containsList(dataValues)) {
            return true;
        }
        for (Tag value : this.getInternal()) {
            if (!TagToDataConverter.convert(value).contains(data)) continue;
            return true;
        }
        return false;
    }

    private boolean containsList(List<IData> dataValues) {
        block0: for (IData dataValue : dataValues) {
            for (Tag value : this.getInternal()) {
                if (!TagToDataConverter.convert(value).contains(dataValue)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    @ZenCodeType.Caster(implicit=true)
    public List<IData> castToList() {
        return this.asList();
    }

    @Override
    public IData.Type getType() {
        return IData.Type.LIST;
    }

    @Override
    public <T> T accept(DataVisitor<T> visitor) {
        return visitor.visitList(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListData listData = (ListData)o;
        return this.internal.equals((Object)listData.internal);
    }

    public int hashCode() {
        return this.internal.hashCode();
    }
}

