/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.crop;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Set;
import net.darkhax.bookshelf.api.data.recipes.IRecipeSerializer;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.data.displaystate.DisplayState;
import net.darkhax.botanypots.data.recipes.crop.BasicCrop;
import net.darkhax.botanypots.data.recipes.crop.SerializerHarvestEntry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;

public final class BasicCropSerializer
extends IRecipeSerializer<BasicCrop> {
    public static BasicCropSerializer SERIALIZER = new BasicCropSerializer();

    public BasicCrop fromJson(ResourceLocation id, JsonObject json) {
        Ingredient seed = (Ingredient)Serializers.INGREDIENT.fromJSON(json, "seed");
        Set validSoils = Serializers.STRING.fromJSONSet(json, "categories");
        int growthTicks = (Integer)Serializers.INT.fromJSON(json, "growthTicks");
        List results = SerializerHarvestEntry.SERIALIZER.fromJSONList(json, "drops");
        int lightLevel = (Integer)Serializers.INT.fromJSON(json, "lightLevel", (Object)0);
        List states = DisplayState.SERIALIZER.fromJSONList(json, "display");
        if (growthTicks <= 0) {
            throw new IllegalArgumentException("Crop " + id + " has an invalid growth tick rate. It must use a positive integer.");
        }
        return new BasicCrop(id, seed, validSoils, growthTicks, results, states, lightLevel);
    }

    public BasicCrop fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        Ingredient seed = (Ingredient)Serializers.INGREDIENT.fromByteBuf(buffer);
        Set validSoils = Serializers.STRING.readByteBufSet(buffer);
        int growthTicks = (Integer)Serializers.INT.fromByteBuf(buffer);
        List results = SerializerHarvestEntry.SERIALIZER.fromByteBufList(buffer);
        List displayStates = DisplayState.SERIALIZER.fromByteBufList(buffer);
        int lightLevel = (Integer)Serializers.INT.fromByteBuf(buffer);
        return new BasicCrop(id, seed, validSoils, growthTicks, results, displayStates, lightLevel);
    }

    public void toNetwork(FriendlyByteBuf buffer, BasicCrop toWrite) {
        Serializers.INGREDIENT.toByteBuf(buffer, (Object)toWrite.seed);
        Serializers.STRING.writeByteBufSet(buffer, toWrite.soilCategories);
        Serializers.INT.toByteBuf(buffer, (Object)toWrite.growthTicks);
        SerializerHarvestEntry.SERIALIZER.toByteBufList(buffer, toWrite.results);
        DisplayState.SERIALIZER.toByteBufList(buffer, toWrite.displayStates);
        Serializers.INT.toByteBuf(buffer, (Object)toWrite.lightLevel);
    }
}

